/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.DefaultEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.schema.SegmentMetadataHolder;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class SystemSchema
extends AbstractSchema {
    public static final String NAME = "sys";
    private static final String SEGMENTS_TABLE = "segments";
    private static final String SERVERS_TABLE = "servers";
    private static final String SERVER_SEGMENTS_TABLE = "server_segments";
    private static final String TASKS_TABLE = "tasks";
    static final RowSignature SEGMENTS_SIGNATURE = RowSignature.builder().add("segment_id", ValueType.STRING).add("datasource", ValueType.STRING).add("start", ValueType.STRING).add("end", ValueType.STRING).add("size", ValueType.LONG).add("version", ValueType.STRING).add("partition_num", ValueType.LONG).add("num_replicas", ValueType.LONG).add("num_rows", ValueType.LONG).add("is_published", ValueType.LONG).add("is_available", ValueType.LONG).add("is_realtime", ValueType.LONG).add("payload", ValueType.STRING).build();
    static final RowSignature SERVERS_SIGNATURE = RowSignature.builder().add("server", ValueType.STRING).add("host", ValueType.STRING).add("plaintext_port", ValueType.LONG).add("tls_port", ValueType.LONG).add("server_type", ValueType.STRING).add("tier", ValueType.STRING).add("curr_size", ValueType.LONG).add("max_size", ValueType.LONG).build();
    static final RowSignature SERVER_SEGMENTS_SIGNATURE = RowSignature.builder().add("server", ValueType.STRING).add("segment_id", ValueType.STRING).build();
    static final RowSignature TASKS_SIGNATURE = RowSignature.builder().add("task_id", ValueType.STRING).add("type", ValueType.STRING).add("datasource", ValueType.STRING).add("created_time", ValueType.STRING).add("queue_insertion_time", ValueType.STRING).add("status", ValueType.STRING).add("runner_status", ValueType.STRING).add("duration", ValueType.LONG).add("location", ValueType.STRING).add("host", ValueType.STRING).add("plaintext_port", ValueType.LONG).add("tls_port", ValueType.LONG).add("error_msg", ValueType.STRING).build();
    private final Map<String, Table> tableMap;

    @Inject
    public SystemSchema(DruidSchema druidSchema, MetadataSegmentView metadataView, TimelineServerView serverView, AuthorizerMapper authorizerMapper, @Coordinator DruidLeaderClient coordinatorDruidLeaderClient, @IndexingService DruidLeaderClient overlordDruidLeaderClient, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        BytesAccumulatingResponseHandler responseHandler = new BytesAccumulatingResponseHandler();
        SegmentsTable segmentsTable = new SegmentsTable(druidSchema, metadataView, jsonMapper, authorizerMapper);
        this.tableMap = ImmutableMap.of((Object)SEGMENTS_TABLE, (Object)((Object)segmentsTable), (Object)SERVERS_TABLE, (Object)((Object)new ServersTable(serverView, authorizerMapper)), (Object)SERVER_SEGMENTS_TABLE, (Object)((Object)new ServerSegmentsTable(serverView, authorizerMapper)), (Object)TASKS_TABLE, (Object)((Object)new TasksTable(overlordDruidLeaderClient, jsonMapper, responseHandler, authorizerMapper)));
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private static JsonParserIterator<TaskStatusPlus> getTasks(DruidLeaderClient indexingServiceClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler) {
        Request request;
        try {
            request = indexingServiceClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/tasks", (Object[])new Object[0]), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ListenableFuture future = indexingServiceClient.goAsync(request, (HttpResponseHandler)responseHandler);
        JavaType typeRef = jsonMapper.getTypeFactory().constructType((TypeReference)new TypeReference<TaskStatusPlus>(){});
        return new JsonParserIterator(typeRef, (Future)future, request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper, responseHandler);
    }

    private static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final JsonParserIterator<T> it) {
        return new CloseableIterator<T>(){

            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    try {
                        it.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return hasNext;
            }

            public T next() {
                return iterator.next();
            }

            public void close() throws IOException {
                it.close();
            }
        };
    }

    @Nullable
    private static String extractHost(@Nullable String hostAndPort) {
        if (hostAndPort == null) {
            return null;
        }
        return HostAndPort.fromString((String)hostAndPort).getHostText();
    }

    private static int extractPort(@Nullable String hostAndPort) {
        if (hostAndPort == null) {
            return -1;
        }
        return HostAndPort.fromString((String)hostAndPort).getPortOrDefault(-1);
    }

    @Nullable
    private static String toStringOrNull(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    static class TasksTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidLeaderClient druidLeaderClient;
        private final ObjectMapper jsonMapper;
        private final BytesAccumulatingResponseHandler responseHandler;
        private final AuthorizerMapper authorizerMapper;

        public TasksTable(DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler, AuthorizerMapper authorizerMapper) {
            this.druidLeaderClient = druidLeaderClient;
            this.jsonMapper = jsonMapper;
            this.responseHandler = responseHandler;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return TASKS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class TasksEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<TaskStatusPlus> it;

                public TasksEnumerable(JsonParserIterator<TaskStatusPlus> tasks) {
                    this.it = ((TasksTable)this$0).getAuthorizedTasks((JsonParserIterator<TaskStatusPlus>)tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            String hostAndPort;
                            TaskStatusPlus task = (TaskStatusPlus)it.next();
                            if (task.getLocation().getHost() == null) {
                                hostAndPort = null;
                            } else {
                                int port = task.getLocation().getTlsPort() >= 0 ? task.getLocation().getTlsPort() : task.getLocation().getPort();
                                hostAndPort = HostAndPort.fromParts((String)task.getLocation().getHost(), (int)port).toString();
                            }
                            return new Object[]{task.getId(), task.getType(), task.getDataSource(), SystemSchema.toStringOrNull(task.getCreatedTime()), SystemSchema.toStringOrNull(task.getQueueInsertionTime()), SystemSchema.toStringOrNull(task.getStatusCode()), SystemSchema.toStringOrNull(task.getRunnerStatusCode()), task.getDuration() == null ? 0L : task.getDuration(), hostAndPort, task.getLocation().getHost(), (long)task.getLocation().getPort(), (long)task.getLocation().getTlsPort(), task.getErrorMsg()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new TasksEnumerable(SystemSchema.getTasks(this.druidLeaderClient, this.jsonMapper, this.responseHandler));
        }

        private CloseableIterator<TaskStatusPlus> getAuthorizedTasks(JsonParserIterator<TaskStatusPlus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = task -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)task.getDataSource()));
            Iterable authorizedTasks = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedTasks.iterator(), it);
        }
    }

    static class ServerSegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final TimelineServerView serverView;
        final AuthorizerMapper authorizerMapper;

        public ServerSegmentsTable(TimelineServerView serverView, AuthorizerMapper authorizerMapper) {
            this.serverView = serverView;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SERVER_SEGMENTS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            List druidServers = this.serverView.getDruidServers();
            int serverSegmentsTableSize = SERVER_SEGMENTS_SIGNATURE.getRowOrder().size();
            for (ImmutableDruidServer druidServer : druidServers) {
                for (DataSegment segment : druidServer.getSegments()) {
                    Object[] row = new Object[serverSegmentsTableSize];
                    row[0] = druidServer.getHost();
                    row[1] = segment.getId();
                    rows.add(row);
                }
            }
            return Linq4j.asEnumerable(rows);
        }
    }

    static class ServersTable
    extends AbstractTable
    implements ScannableTable {
        private final TimelineServerView serverView;
        private final AuthorizerMapper authorizerMapper;

        public ServersTable(TimelineServerView serverView, AuthorizerMapper authorizerMapper) {
            this.serverView = serverView;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SERVERS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        /*
         * Exception decompiling
         */
        public Enumerable<Object[]> scan(DataContext root) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class SegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidSchema druidSchema;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final MetadataSegmentView metadataView;

        public SegmentsTable(DruidSchema druidSchemna, MetadataSegmentView metadataView, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidSchema = druidSchemna;
            this.metadataView = metadataView;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SEGMENTS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Map<DataSegment, SegmentMetadataHolder> availableSegmentMetadata = this.druidSchema.getSegmentMetadata();
            Iterator<Map.Entry<DataSegment, SegmentMetadataHolder>> availableSegmentEntries = availableSegmentMetadata.entrySet().iterator();
            HashMap partialSegmentDataMap = Maps.newHashMapWithExpectedSize((int)this.druidSchema.getTotalSegments());
            for (SegmentMetadataHolder h : availableSegmentMetadata.values()) {
                PartialSegmentData partialSegmentData = new PartialSegmentData(h.isAvailable(), h.isRealtime(), h.getNumReplicas(), h.getNumRows());
                partialSegmentDataMap.put(h.getSegmentId(), partialSegmentData);
            }
            Iterator<DataSegment> metadataSegments = this.metadataView.getPublishedSegments();
            HashSet segmentsAlreadySeen = new HashSet();
            FluentIterable publishedSegments = FluentIterable.from(() -> this.getAuthorizedPublishedSegments(metadataSegments, root)).transform(val -> {
                try {
                    segmentsAlreadySeen.add(val.getId());
                    PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(val.getId());
                    long numReplicas = 0L;
                    long numRows = 0L;
                    long isRealtime = 0L;
                    long isAvailable = 0L;
                    if (partialSegmentData != null) {
                        numReplicas = partialSegmentData.getNumReplicas();
                        numRows = partialSegmentData.getNumRows();
                        isAvailable = partialSegmentData.isAvailable();
                        isRealtime = partialSegmentData.isRealtime();
                    }
                    return new Object[]{val.getId(), val.getDataSource(), val.getInterval().getStart().toString(), val.getInterval().getEnd().toString(), val.getSize(), val.getVersion(), (long)val.getShardSpec().getPartitionNum(), numReplicas, numRows, 1L, isAvailable, isRealtime, this.jsonMapper.writeValueAsString(val)};
                }
                catch (JsonProcessingException e) {
                    throw new RE((Throwable)e, "Error getting segment payload for segment %s", new Object[]{val.getId()});
                }
            });
            FluentIterable availableSegments = FluentIterable.from(() -> this.getAuthorizedAvailableSegments(availableSegmentEntries, root)).transform(val -> {
                try {
                    if (segmentsAlreadySeen.contains(((DataSegment)val.getKey()).getId())) {
                        return null;
                    }
                    PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(((DataSegment)val.getKey()).getId());
                    long numReplicas = partialSegmentData == null ? 0L : partialSegmentData.getNumReplicas();
                    return new Object[]{((DataSegment)val.getKey()).getId(), ((DataSegment)val.getKey()).getDataSource(), ((DataSegment)val.getKey()).getInterval().getStart().toString(), ((DataSegment)val.getKey()).getInterval().getEnd().toString(), ((DataSegment)val.getKey()).getSize(), ((DataSegment)val.getKey()).getVersion(), (long)((DataSegment)val.getKey()).getShardSpec().getPartitionNum(), numReplicas, ((SegmentMetadataHolder)val.getValue()).getNumRows(), ((SegmentMetadataHolder)val.getValue()).isPublished(), ((SegmentMetadataHolder)val.getValue()).isAvailable(), ((SegmentMetadataHolder)val.getValue()).isRealtime(), this.jsonMapper.writeValueAsString(val.getKey())};
                }
                catch (JsonProcessingException e) {
                    throw new RE((Throwable)e, "Error getting segment payload for segment %s", new Object[]{((DataSegment)val.getKey()).getId()});
                }
            });
            Iterable allSegments = Iterables.unmodifiableIterable((Iterable)Iterables.concat((Iterable)publishedSegments, (Iterable)availableSegments));
            return Linq4j.asEnumerable((Iterable)allSegments).where(Objects::nonNull);
        }

        private Iterator<DataSegment> getAuthorizedPublishedSegments(Iterator<DataSegment> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private Iterator<Map.Entry<DataSegment, SegmentMetadataHolder>> getAuthorizedAvailableSegments(Iterator<Map.Entry<DataSegment, SegmentMetadataHolder>> availableSegmentEntries, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)((DataSegment)segment.getKey()).getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> availableSegmentEntries, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private static class PartialSegmentData {
            private final long isAvailable;
            private final long isRealtime;
            private final long numReplicas;
            private final long numRows;

            public PartialSegmentData(long isAvailable, long isRealtime, long numReplicas, long numRows) {
                this.isAvailable = isAvailable;
                this.isRealtime = isRealtime;
                this.numReplicas = numReplicas;
                this.numRows = numRows;
            }

            public long isAvailable() {
                return this.isAvailable;
            }

            public long isRealtime() {
                return this.isRealtime;
            }

            public long getNumReplicas() {
                return this.numReplicas;
            }

            public long getNumRows() {
                return this.numRows;
            }
        }
    }
}

