/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.sql.calcite.table.RowSignature;

public class SortProject {
    private final RowSignature inputRowSignature;
    private final List<PostAggregator> postAggregators;
    private final RowSignature outputRowSignature;

    SortProject(RowSignature inputRowSignature, List<PostAggregator> postAggregators, RowSignature outputRowSignature) {
        this.inputRowSignature = (RowSignature)Preconditions.checkNotNull((Object)inputRowSignature, (Object)"inputRowSignature");
        this.postAggregators = (List)Preconditions.checkNotNull(postAggregators, (Object)"postAggregators");
        this.outputRowSignature = (RowSignature)Preconditions.checkNotNull((Object)outputRowSignature, (Object)"outputRowSignature");
        HashSet<String> inputColumnNames = new HashSet<String>(inputRowSignature.getRowOrder());
        Set postAggregatorNames = postAggregators.stream().map(PostAggregator::getName).collect(Collectors.toSet());
        for (String postAggregatorName : postAggregatorNames) {
            if (!inputColumnNames.contains(postAggregatorName)) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{postAggregatorName});
        }
        outputRowSignature.getRowOrder().forEach(field -> {
            if (!inputColumnNames.contains(field) && !postAggregatorNames.contains(field)) {
                throw new ISE("Missing field in rowOrder: %s", new Object[]{field});
            }
        });
    }

    public List<PostAggregator> getPostAggregators() {
        return this.postAggregators;
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortProject sortProject = (SortProject)o;
        return Objects.equals(this.inputRowSignature, sortProject.inputRowSignature) && Objects.equals(this.postAggregators, sortProject.postAggregators) && Objects.equals(this.outputRowSignature, sortProject.outputRowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.inputRowSignature, this.postAggregators, this.outputRowSignature);
    }

    public String toString() {
        return "SortProject{inputRowSignature=" + this.inputRowSignature + ", postAggregators=" + this.postAggregators + ", outputRowSignature=" + this.outputRowSignature + '}';
    }
}

