/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class DruidRexExecutor
implements RexExecutor {
    private static final RowSignature EMPTY_ROW_SIGNATURE = RowSignature.builder().build();
    private final PlannerContext plannerContext;

    public DruidRexExecutor(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        for (RexNode constExp : constExps) {
            RexNode literal;
            DruidExpression druidExpression = Expressions.toDruidExpression(this.plannerContext, EMPTY_ROW_SIGNATURE, constExp);
            if (druidExpression == null) {
                reducedValues.add(constExp);
                continue;
            }
            SqlTypeName sqlTypeName = constExp.getType().getSqlTypeName();
            Expr expr = Parser.parse((String)druidExpression.getExpression(), (ExprMacroTable)this.plannerContext.getExprMacroTable());
            ExprEval exprResult = expr.eval(name -> {
                throw new UnsupportedOperationException();
            });
            if (sqlTypeName == SqlTypeName.BOOLEAN) {
                literal = rexBuilder.makeLiteral((Object)exprResult.asBoolean(), constExp.getType(), true);
            } else if (sqlTypeName == SqlTypeName.DATE) {
                if (!constExp.getType().isNullable() && exprResult.isNumericNull()) {
                    throw new IAE("Illegal DATE constant: %s", new Object[]{constExp});
                }
                literal = rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()));
            } else if (sqlTypeName == SqlTypeName.TIMESTAMP) {
                if (!constExp.getType().isNullable() && exprResult.isNumericNull()) {
                    throw new IAE("Illegal TIMESTAMP constant: %s", new Object[]{constExp});
                }
                literal = rexBuilder.makeTimestampLiteral(Calcites.jodaToCalciteTimestampString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()), -1);
            } else if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                BigDecimal bigDecimal = exprResult.type() == ExprType.LONG ? BigDecimal.valueOf(exprResult.asLong()) : BigDecimal.valueOf(exprResult.asDouble());
                literal = rexBuilder.makeLiteral((Object)bigDecimal, constExp.getType(), true);
            } else {
                literal = rexBuilder.makeLiteral(exprResult.value(), constExp.getType(), true);
            }
            reducedValues.add(literal);
        }
    }
}

