/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class DruidConvertletTable
implements SqlRexConvertletTable {
    private static final SqlRexConvertlet BYPASS_CONVERTLET = (arg_0, arg_1) -> ((StandardConvertletTable)StandardConvertletTable.INSTANCE).convertCall(arg_0, arg_1);
    private static final SqlRexConvertlet STANDARD_CONVERTLET = (cx, call) -> StandardConvertletTable.INSTANCE.get(call).convertCall(cx, call);
    private static final List<SqlOperator> CURRENT_TIME_CONVERTLET_OPERATORS = ImmutableList.builder().add((Object)SqlStdOperatorTable.CURRENT_TIMESTAMP).add((Object)SqlStdOperatorTable.CURRENT_TIME).add((Object)SqlStdOperatorTable.CURRENT_DATE).add((Object)SqlStdOperatorTable.LOCALTIMESTAMP).add((Object)SqlStdOperatorTable.LOCALTIME).build();
    private static final List<SqlOperator> STANDARD_CONVERTLET_OPERATORS = ImmutableList.builder().add((Object)SqlStdOperatorTable.ROW).add((Object)SqlStdOperatorTable.NOT_IN).add((Object)SqlStdOperatorTable.NOT_LIKE).add((Object)SqlStdOperatorTable.BETWEEN).add((Object)SqlStdOperatorTable.NOT_BETWEEN).add((Object)SqlStdOperatorTable.SYMMETRIC_BETWEEN).add((Object)SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN).add((Object)SqlStdOperatorTable.ITEM).add((Object)SqlStdOperatorTable.TIMESTAMP_ADD).add((Object)SqlStdOperatorTable.UNION).add((Object)SqlStdOperatorTable.UNION_ALL).build();
    private final Map<SqlOperator, SqlRexConvertlet> table;

    public DruidConvertletTable(PlannerContext plannerContext) {
        this.table = DruidConvertletTable.createConvertletMap(plannerContext);
    }

    public SqlRexConvertlet get(SqlCall call) {
        if (call.getKind() == SqlKind.EXTRACT && ((SqlNode)call.getOperandList().get(1)).getKind() != SqlKind.LITERAL) {
            return BYPASS_CONVERTLET;
        }
        SqlRexConvertlet convertlet = this.table.get(call.getOperator());
        return convertlet != null ? convertlet : StandardConvertletTable.INSTANCE.get(call);
    }

    public static List<SqlOperator> knownOperators() {
        ArrayList<SqlOperator> retVal = new ArrayList<SqlOperator>(CURRENT_TIME_CONVERTLET_OPERATORS.size() + STANDARD_CONVERTLET_OPERATORS.size());
        retVal.addAll(CURRENT_TIME_CONVERTLET_OPERATORS);
        retVal.addAll(STANDARD_CONVERTLET_OPERATORS);
        return retVal;
    }

    private static Map<SqlOperator, SqlRexConvertlet> createConvertletMap(PlannerContext plannerContext) {
        CurrentTimestampAndFriendsConvertlet currentTimestampAndFriends = new CurrentTimestampAndFriendsConvertlet(plannerContext);
        HashMap<SqlOperator, SqlRexConvertlet> table = new HashMap<SqlOperator, SqlRexConvertlet>();
        for (SqlOperator operator : CURRENT_TIME_CONVERTLET_OPERATORS) {
            table.put(operator, currentTimestampAndFriends);
        }
        for (SqlOperator operator : STANDARD_CONVERTLET_OPERATORS) {
            table.put(operator, STANDARD_CONVERTLET);
        }
        return table;
    }

    private static class CurrentTimestampAndFriendsConvertlet
    implements SqlRexConvertlet {
        private final PlannerContext plannerContext;

        public CurrentTimestampAndFriendsConvertlet(PlannerContext plannerContext) {
            this.plannerContext = plannerContext;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlOperator operator = call.getOperator();
            if (operator.equals((Object)SqlStdOperatorTable.CURRENT_TIMESTAMP) || operator.equals((Object)SqlStdOperatorTable.LOCALTIMESTAMP)) {
                return cx.getRexBuilder().makeTimestampLiteral(Calcites.jodaToCalciteTimestampString(this.plannerContext.getLocalNow(), this.plannerContext.getTimeZone()), -1);
            }
            if (operator.equals((Object)SqlStdOperatorTable.CURRENT_TIME) || operator.equals((Object)SqlStdOperatorTable.LOCALTIME)) {
                return cx.getRexBuilder().makeTimeLiteral(Calcites.jodaToCalciteTimeString(this.plannerContext.getLocalNow(), this.plannerContext.getTimeZone()), -1);
            }
            if (operator.equals((Object)SqlStdOperatorTable.CURRENT_DATE)) {
                return cx.getRexBuilder().makeDateLiteral(Calcites.jodaToCalciteDateString(this.plannerContext.getLocalNow().hourOfDay().roundFloorCopy(), this.plannerContext.getTimeZone()));
            }
            throw new ISE("WTF?! Should not have got here, operator was: %s", new Object[]{operator});
        }
    }
}

