/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class TimeUnits {
    private static final Map<TimeUnitRange, Period> PERIOD_MAP = ImmutableMap.builder().put((Object)TimeUnitRange.SECOND, (Object)Period.seconds((int)1)).put((Object)TimeUnitRange.MINUTE, (Object)Period.minutes((int)1)).put((Object)TimeUnitRange.HOUR, (Object)Period.hours((int)1)).put((Object)TimeUnitRange.DAY, (Object)Period.days((int)1)).put((Object)TimeUnitRange.WEEK, (Object)Period.weeks((int)1)).put((Object)TimeUnitRange.MONTH, (Object)Period.months((int)1)).put((Object)TimeUnitRange.QUARTER, (Object)Period.months((int)3)).put((Object)TimeUnitRange.YEAR, (Object)Period.years((int)1)).build();

    public static PeriodGranularity toQueryGranularity(TimeUnitRange timeUnitRange, DateTimeZone timeZone) {
        Period period = PERIOD_MAP.get(timeUnitRange);
        if (period == null) {
            return null;
        }
        return new PeriodGranularity(period, null, timeZone);
    }
}

