/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.ExtractionFns;

public class SimpleExtraction {
    private final String column;
    private final ExtractionFn extractionFn;

    public SimpleExtraction(String column, ExtractionFn extractionFn) {
        this.column = (String)Preconditions.checkNotNull((Object)column, (Object)"column");
        this.extractionFn = extractionFn;
    }

    public static SimpleExtraction of(String column, ExtractionFn extractionFn) {
        return new SimpleExtraction(column, extractionFn);
    }

    public String getColumn() {
        return this.column;
    }

    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public SimpleExtraction cascade(ExtractionFn nextExtractionFn) {
        return new SimpleExtraction(this.column, ExtractionFns.cascade(this.extractionFn, (ExtractionFn)Preconditions.checkNotNull((Object)nextExtractionFn, (Object)"nextExtractionFn")));
    }

    public DimensionSpec toDimensionSpec(String outputName, ValueType outputType) {
        Preconditions.checkNotNull((Object)outputType, (Object)"outputType");
        return this.extractionFn == null ? new DefaultDimensionSpec(this.column, outputName, outputType) : new ExtractionDimensionSpec(this.column, outputName, outputType, this.extractionFn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleExtraction that = (SimpleExtraction)o;
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.extractionFn, this.column});
        }
        return this.column;
    }
}

