/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class OperatorConversions {
    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.fromFunctionCall(functionName, druidExpressions));
    }

    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName, Function<List<DruidExpression>, SimpleExtraction> simpleExtractionFunction) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.of(simpleExtractionFunction == null ? null : (SimpleExtraction)simpleExtractionFunction.apply((List<DruidExpression>)druidExpressions), DruidExpression.functionCall(functionName, druidExpressions)));
    }

    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, Function<List<DruidExpression>, DruidExpression> expressionFunction) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return expressionFunction.apply(druidExpressions);
    }

    public static OperatorBuilder operatorBuilder(String name) {
        return new OperatorBuilder(name);
    }

    public static class OperatorBuilder {
        private String name;
        private SqlKind kind = SqlKind.OTHER_FUNCTION;
        private SqlReturnTypeInference returnTypeInference;
        private SqlFunctionCategory functionCategory = SqlFunctionCategory.USER_DEFINED_FUNCTION;
        private List<SqlTypeFamily> operandTypes;
        private int requiredOperands = Integer.MAX_VALUE;

        private OperatorBuilder(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        public OperatorBuilder kind(SqlKind kind) {
            this.kind = kind;
            return this;
        }

        public OperatorBuilder returnType(SqlTypeName typeName) {
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlType(factory, typeName));
            return this;
        }

        public OperatorBuilder nullableReturnType(SqlTypeName typeName) {
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlTypeWithNullability(factory, typeName, true));
            return this;
        }

        public OperatorBuilder returnTypeInference(SqlReturnTypeInference returnTypeInference) {
            this.returnTypeInference = returnTypeInference;
            return this;
        }

        public OperatorBuilder functionCategory(SqlFunctionCategory functionCategory) {
            this.functionCategory = functionCategory;
            return this;
        }

        public OperatorBuilder operandTypes(SqlTypeFamily ... operandTypes) {
            this.operandTypes = Arrays.asList(operandTypes);
            return this;
        }

        public OperatorBuilder requiredOperands(int requiredOperands) {
            this.requiredOperands = requiredOperands;
            return this;
        }

        public SqlFunction build() {
            return new SqlFunction(this.name, this.kind, (SqlReturnTypeInference)Preconditions.checkNotNull((Object)this.returnTypeInference, (Object)"returnTypeInference"), null, (SqlOperandTypeChecker)OperandTypes.family((List)((List)Preconditions.checkNotNull(this.operandTypes, (Object)"operandTypes")), i -> i + 1 > this.requiredOperands), this.functionCategory);
        }
    }
}

