/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Joiner;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class BinaryOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final Joiner joiner;

    public BinaryOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.joiner = Joiner.on((String)(" " + druidOperator + " "));
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, operands -> {
            if (operands.size() < 2) {
                throw new ISE("WTF?! Got binary operator[%s] with %s args?", new Object[]{this.operator.getName(), operands.size()});
            }
            return DruidExpression.fromExpression(StringUtils.format((String)"(%s)", (Object[])new Object[]{this.joiner.join((Iterable)operands.stream().map(DruidExpression::getExpression).collect(Collectors.toList()))}));
        });
    }
}

