/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class MaxSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.MAX;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String expression;
        String fieldName;
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (arguments == null) {
            return null;
        }
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ValueType valueType = Calcites.getValueTypeForSqlTypeName(aggregateCall.getType().getSqlTypeName());
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        if (arg.isDirectColumnAccess()) {
            fieldName = arg.getDirectColumn();
            expression = null;
        } else {
            fieldName = null;
            expression = arg.getExpression();
        }
        return Aggregation.create(MaxSqlAggregator.createMaxAggregatorFactory(valueType, name, fieldName, expression, macroTable));
    }

    private static AggregatorFactory createMaxAggregatorFactory(ValueType aggregationType, String name, String fieldName, String expression, ExprMacroTable macroTable) {
        switch (aggregationType) {
            case LONG: {
                return new LongMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case FLOAT: {
                return new FloatMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case DOUBLE: {
                return new DoubleMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
        }
        throw new ISE("Cannot create aggregator factory for type[%s]", new Object[]{aggregationType});
    }
}

