/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class ApproxCountDistinctSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new ApproxCountDistinctSqlAggFunction();
    private static final String NAME = "APPROX_COUNT_DISTINCT";

    @Override
    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        HyperUniquesAggregatorFactory aggregatorFactory;
        String aggregatorName;
        RexNode rexNode = Expressions.fromFieldAccess(rowSignature, project, (Integer)Iterables.getOnlyElement((Iterable)aggregateCall.getArgList()));
        DruidExpression arg = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        if (arg == null) {
            return null;
        }
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        if (arg.isDirectColumnAccess() && rowSignature.getColumnType(arg.getDirectColumn()) == ValueType.COMPLEX) {
            aggregatorFactory = new HyperUniquesAggregatorFactory(aggregatorName, arg.getDirectColumn(), false, true);
        } else {
            DimensionSpec dimensionSpec;
            SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
            ValueType inputType = Calcites.getValueTypeForSqlTypeName(sqlTypeName);
            if (inputType == null) {
                throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{sqlTypeName, aggregatorName});
            }
            if (arg.isSimpleExtraction()) {
                dimensionSpec = arg.getSimpleExtraction().toDimensionSpec(null, inputType);
            } else {
                ExpressionVirtualColumn virtualColumn = arg.toVirtualColumn(Calcites.makePrefixedName(name, "v"), inputType, plannerContext.getExprMacroTable());
                dimensionSpec = new DefaultDimensionSpec(virtualColumn.getOutputName(), null, inputType);
                virtualColumns.add((VirtualColumn)virtualColumn);
            }
            aggregatorFactory = new CardinalityAggregatorFactory(aggregatorName, null, (List)ImmutableList.of((Object)dimensionSpec), false, true);
        }
        return Aggregation.create(virtualColumns, Collections.singletonList(aggregatorFactory), (PostAggregator)(finalizeAggregations ? new HyperUniqueFinalizingPostAggregator(name, aggregatorFactory.getName()) : null));
    }

    private static class ApproxCountDistinctSqlAggFunction
    extends SqlAggFunction {
        ApproxCountDistinctSqlAggFunction() {
            super(ApproxCountDistinctSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), InferTypes.VARCHAR_1024, (SqlOperandTypeChecker)OperandTypes.ANY, SqlFunctionCategory.STRING, false, false);
        }
    }
}

