/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchConnectionException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidConnection;
import org.apache.druid.sql.avatica.DruidStatement;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DruidMeta
extends MetaImpl {
    private static final Logger log = new Logger(DruidMeta.class);
    private final SqlLifecycleFactory sqlLifecycleFactory;
    private final ScheduledExecutorService exec;
    private final AvaticaServerConfig config;
    private final List<Authenticator> authenticators;
    private final ConcurrentMap<String, DruidConnection> connections = new ConcurrentHashMap<String, DruidConnection>();
    private final AtomicInteger connectionCount = new AtomicInteger();

    @Inject
    public DruidMeta(SqlLifecycleFactory sqlLifecycleFactory, AvaticaServerConfig config, Injector injector) {
        super(null);
        this.sqlLifecycleFactory = (SqlLifecycleFactory)Preconditions.checkNotNull((Object)sqlLifecycleFactory, (Object)"sqlLifecycleFactory");
        this.config = config;
        this.exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(StringUtils.format((String)"DruidMeta@%s-ScheduledExecutor", (Object[])new Object[]{Integer.toHexString(((Object)((Object)this)).hashCode())})).setDaemon(true).build());
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        this.authenticators = authenticatorMapper.getAuthenticatorChain();
    }

    public void openConnection(Meta.ConnectionHandle ch, Map<String, String> info) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            context.put(entry);
        }
        this.openDruidConnection(ch.id, (Map<String, Object>)context.build());
    }

    public void closeConnection(Meta.ConnectionHandle ch) {
        DruidConnection druidConnection = (DruidConnection)this.connections.remove(ch.id);
        if (druidConnection != null) {
            this.connectionCount.decrementAndGet();
            druidConnection.close();
        }
    }

    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        this.getDruidConnection(ch.id);
        return connProps;
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        DruidStatement druidStatement = this.getDruidConnection(ch.id).createStatement(this.sqlLifecycleFactory);
        return new Meta.StatementHandle(ch.id, druidStatement.getStatementId(), null);
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        DruidStatement druidStatement;
        Meta.StatementHandle statement = this.createStatement(ch);
        try {
            druidStatement = this.getDruidStatement(statement);
        }
        catch (NoSuchStatementException e) {
            throw new IllegalStateException(e);
        }
        DruidConnection druidConnection = this.getDruidConnection(statement.connectionId);
        AuthenticationResult authenticationResult = this.authenticateConnection(druidConnection);
        if (authenticationResult == null) {
            throw new ForbiddenException("Authentication failed.");
        }
        statement.signature = druidStatement.prepare(sql, maxRowCount, authenticationResult).getSignature();
        return statement;
    }

    @Deprecated
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, Meta.PrepareCallback callback) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle statement, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        DruidStatement druidStatement = this.getDruidStatement(statement);
        DruidConnection druidConnection = this.getDruidConnection(statement.connectionId);
        AuthenticationResult authenticationResult = this.authenticateConnection(druidConnection);
        if (authenticationResult == null) {
            throw new ForbiddenException("Authentication failed.");
        }
        Meta.Signature signature = druidStatement.prepare(sql, maxRowCount, authenticationResult).getSignature();
        Meta.Frame firstFrame = druidStatement.execute().nextFrame(0L, this.getEffectiveMaxRowsPerFrame(maxRowsInFirstFrame));
        return new Meta.ExecuteResult((List)ImmutableList.of((Object)Meta.MetaResultSet.create((String)statement.connectionId, (int)statement.id, (boolean)false, (Meta.Signature)signature, (Meta.Frame)firstFrame)));
    }

    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle statement, List<String> sqlCommands) {
        throw new UnsupportedOperationException("Batch statements not supported");
    }

    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle statement, List<List<TypedValue>> parameterValues) {
        throw new UnsupportedOperationException("Batch statements not supported");
    }

    public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        return this.getDruidStatement(statement).nextFrame(offset, this.getEffectiveMaxRowsPerFrame(fetchMaxRowCount));
    }

    @Deprecated
    public Meta.ExecuteResult execute(Meta.StatementHandle statement, List<TypedValue> parameterValues, long maxRowCount) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle statement, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        Preconditions.checkArgument((boolean)parameterValues.isEmpty(), (Object)"Expected parameterValues to be empty");
        DruidStatement druidStatement = this.getDruidStatement(statement);
        Meta.Signature signature = druidStatement.getSignature();
        Meta.Frame firstFrame = druidStatement.execute().nextFrame(0L, this.getEffectiveMaxRowsPerFrame(maxRowsInFirstFrame));
        return new Meta.ExecuteResult((List)ImmutableList.of((Object)Meta.MetaResultSet.create((String)statement.connectionId, (int)statement.id, (boolean)false, (Meta.Signature)signature, (Meta.Frame)firstFrame)));
    }

    public Iterable<Object> createIterable(Meta.StatementHandle statement, QueryState state, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        return null;
    }

    public void closeStatement(Meta.StatementHandle h) {
        DruidStatement druidStatement;
        DruidConnection druidConnection = (DruidConnection)this.connections.get(h.connectionId);
        if (druidConnection != null && (druidStatement = druidConnection.getStatement(h.id)) != null) {
            druidStatement.close();
        }
    }

    public boolean syncResults(Meta.StatementHandle sh, QueryState state, long offset) throws NoSuchStatementException {
        DruidStatement druidStatement = this.getDruidStatement(sh);
        boolean isDone = druidStatement.isDone();
        long currentOffset = druidStatement.getCurrentOffset();
        if (currentOffset != offset) {
            throw new ISE("Requested offset[%,d] does not match currentOffset[%,d]", new Object[]{offset, currentOffset});
        }
        return !isDone;
    }

    public void commit(Meta.ConnectionHandle ch) {
    }

    public void rollback(Meta.ConnectionHandle ch) {
    }

    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        return ImmutableMap.of();
    }

    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        String sql = "SELECT\n  DISTINCT CATALOG_NAME AS TABLE_CAT\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\nORDER BY\n  TABLE_CAT\n";
        return this.sqlResultSet(ch, "SELECT\n  DISTINCT CATALOG_NAME AS TABLE_CAT\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\nORDER BY\n  TABLE_CAT\n");
    }

    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        ArrayList<String> whereBuilder = new ArrayList<String>();
        if (catalog != null) {
            whereBuilder.add("SCHEMATA.CATALOG_NAME = " + Calcites.escapeStringLiteral(catalog));
        }
        if (schemaPattern.s != null) {
            whereBuilder.add("SCHEMATA.SCHEMA_NAME LIKE " + Calcites.escapeStringLiteral(schemaPattern.s));
        }
        String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
        String sql = "SELECT\n  SCHEMA_NAME AS TABLE_SCHEM,\n  CATALOG_NAME AS TABLE_CATALOG\nFROM\n  INFORMATION_SCHEMA.SCHEMATA\n" + where + "\nORDER BY\n  TABLE_CATALOG, TABLE_SCHEM\n";
        return this.sqlResultSet(ch, sql);
    }

    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        ArrayList<String> whereBuilder = new ArrayList<String>();
        if (catalog != null) {
            whereBuilder.add("TABLES.TABLE_CATALOG = " + Calcites.escapeStringLiteral(catalog));
        }
        if (schemaPattern.s != null) {
            whereBuilder.add("TABLES.TABLE_SCHEMA LIKE " + Calcites.escapeStringLiteral(schemaPattern.s));
        }
        if (tableNamePattern.s != null) {
            whereBuilder.add("TABLES.TABLE_NAME LIKE " + Calcites.escapeStringLiteral(tableNamePattern.s));
        }
        if (typeList != null) {
            ArrayList<String> escapedTypes = new ArrayList<String>();
            for (String type : typeList) {
                escapedTypes.add(Calcites.escapeStringLiteral(type));
            }
            whereBuilder.add("TABLES.TABLE_TYPE IN (" + Joiner.on((String)", ").join(escapedTypes) + ")");
        }
        String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
        String sql = "SELECT\n  TABLE_CATALOG AS TABLE_CAT,\n  TABLE_SCHEMA AS TABLE_SCHEM,\n  TABLE_NAME AS TABLE_NAME,\n  TABLE_TYPE AS TABLE_TYPE,\n  CAST(NULL AS VARCHAR) AS REMARKS,\n  CAST(NULL AS VARCHAR) AS TYPE_CAT,\n  CAST(NULL AS VARCHAR) AS TYPE_SCHEM,\n  CAST(NULL AS VARCHAR) AS TYPE_NAME,\n  CAST(NULL AS VARCHAR) AS SELF_REFERENCING_COL_NAME,\n  CAST(NULL AS VARCHAR) AS REF_GENERATION\nFROM\n  INFORMATION_SCHEMA.TABLES\n" + where + "\nORDER BY\n  TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME\n";
        return this.sqlResultSet(ch, sql);
    }

    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        ArrayList<String> whereBuilder = new ArrayList<String>();
        if (catalog != null) {
            whereBuilder.add("COLUMNS.TABLE_CATALOG = " + Calcites.escapeStringLiteral(catalog));
        }
        if (schemaPattern.s != null) {
            whereBuilder.add("COLUMNS.TABLE_SCHEMA LIKE " + Calcites.escapeStringLiteral(schemaPattern.s));
        }
        if (tableNamePattern.s != null) {
            whereBuilder.add("COLUMNS.TABLE_NAME LIKE " + Calcites.escapeStringLiteral(tableNamePattern.s));
        }
        if (columnNamePattern.s != null) {
            whereBuilder.add("COLUMNS.COLUMN_NAME LIKE " + Calcites.escapeStringLiteral(columnNamePattern.s));
        }
        String where = whereBuilder.isEmpty() ? "" : "WHERE " + Joiner.on((String)" AND ").join(whereBuilder);
        String sql = "SELECT\n  TABLE_CATALOG AS TABLE_CAT,\n  TABLE_SCHEMA AS TABLE_SCHEM,\n  TABLE_NAME AS TABLE_NAME,\n  COLUMN_NAME AS COLUMN_NAME,\n  CAST(JDBC_TYPE AS INTEGER) AS DATA_TYPE,\n  DATA_TYPE AS TYPE_NAME,\n  -1 AS COLUMN_SIZE,\n  -1 AS BUFFER_LENGTH,\n  -1 AS DECIMAL_DIGITS,\n  -1 AS NUM_PREC_RADIX,\n  CASE IS_NULLABLE WHEN 'YES' THEN 1 ELSE 0 END AS NULLABLE,\n  CAST(NULL AS VARCHAR) AS REMARKS,\n  COLUMN_DEFAULT AS COLUMN_DEF,\n  -1 AS SQL_DATA_TYPE,\n  -1 AS SQL_DATETIME_SUB,\n  -1 AS CHAR_OCTET_LENGTH,\n  CAST(ORDINAL_POSITION AS INTEGER) AS ORDINAL_POSITION,\n  IS_NULLABLE AS IS_NULLABLE,\n  CAST(NULL AS VARCHAR) AS SCOPE_CATALOG,\n  CAST(NULL AS VARCHAR) AS SCOPE_SCHEMA,\n  CAST(NULL AS VARCHAR) AS SCOPE_TABLE,\n  -1 AS SOURCE_DATA_TYPE,\n  'NO' AS IS_AUTOINCREMENT,\n  'NO' AS IS_GENERATEDCOLUMN\nFROM\n  INFORMATION_SCHEMA.COLUMNS\n" + where + "\nORDER BY\n  TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION\n";
        return this.sqlResultSet(ch, sql);
    }

    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        String sql = "SELECT\n  DISTINCT TABLE_TYPE AS TABLE_TYPE\nFROM\n  INFORMATION_SCHEMA.TABLES\nORDER BY\n  TABLE_TYPE\n";
        return this.sqlResultSet(ch, "SELECT\n  DISTINCT TABLE_TYPE AS TABLE_TYPE\nFROM\n  INFORMATION_SCHEMA.TABLES\nORDER BY\n  TABLE_TYPE\n");
    }

    @VisibleForTesting
    void closeAllConnections() {
        for (String connectionId : ImmutableSet.copyOf(this.connections.keySet())) {
            this.closeConnection(new Meta.ConnectionHandle(connectionId));
        }
    }

    private AuthenticationResult authenticateConnection(DruidConnection connection) {
        Map<String, Object> context = connection.context();
        for (Authenticator authenticator : this.authenticators) {
            AuthenticationResult authenticationResult = authenticator.authenticateJDBCContext(context);
            if (authenticationResult == null) continue;
            return authenticationResult;
        }
        return null;
    }

    private DruidConnection openDruidConnection(String connectionId, Map<String, Object> context) {
        DruidConnection putResult;
        if (this.connectionCount.incrementAndGet() > this.config.getMaxConnections()) {
            Iterator entryIterator = this.connections.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                if (!((DruidConnection)entry.getValue()).closeIfEmpty()) continue;
                entryIterator.remove();
                this.connectionCount.decrementAndGet();
                break;
            }
            if (this.connectionCount.get() > this.config.getMaxConnections()) {
                this.connectionCount.decrementAndGet();
                throw new ISE("Too many connections, limit is[%,d]", new Object[]{this.config.getMaxConnections()});
            }
        }
        if ((putResult = this.connections.putIfAbsent(connectionId, new DruidConnection(connectionId, this.config.getMaxStatementsPerConnection(), context))) != null) {
            this.connectionCount.decrementAndGet();
            throw new ISE("Connection[%s] already open.", new Object[]{connectionId});
        }
        log.debug("Connection[%s] opened.", new Object[]{connectionId});
        return this.getDruidConnection(connectionId);
    }

    @Nonnull
    private DruidConnection getDruidConnection(String connectionId) {
        DruidConnection connection = (DruidConnection)this.connections.get(connectionId);
        if (connection == null) {
            throw new NoSuchConnectionException(connectionId);
        }
        return connection.sync(this.exec.schedule(() -> {
            log.debug("Connection[%s] timed out.", new Object[]{connectionId});
            this.closeConnection(new Meta.ConnectionHandle(connectionId));
        }, new Interval((ReadableInstant)DateTimes.nowUtc(), (ReadablePeriod)this.config.getConnectionIdleTimeout()).toDurationMillis(), TimeUnit.MILLISECONDS));
    }

    @Nonnull
    private DruidStatement getDruidStatement(Meta.StatementHandle statement) throws NoSuchStatementException {
        DruidConnection connection = this.getDruidConnection(statement.connectionId);
        DruidStatement druidStatement = connection.getStatement(statement.id);
        if (druidStatement == null) {
            throw new NoSuchStatementException(statement);
        }
        return druidStatement;
    }

    private Meta.MetaResultSet sqlResultSet(Meta.ConnectionHandle ch, String sql) {
        Meta.StatementHandle statement = this.createStatement(ch);
        try {
            Meta.ExecuteResult result = this.prepareAndExecute(statement, sql, -1L, -1, null);
            Meta.MetaResultSet metaResultSet = (Meta.MetaResultSet)Iterables.getOnlyElement((Iterable)result.resultSets);
            if (!metaResultSet.firstFrame.done) {
                throw new ISE("Expected all results to be in a single frame!", new Object[0]);
            }
            Meta.MetaResultSet metaResultSet2 = metaResultSet;
            return metaResultSet2;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    private int getEffectiveMaxRowsPerFrame(int clientMaxRowsPerFrame) {
        if (this.config.getMaxRowsPerFrame() < 0) {
            return clientMaxRowsPerFrame;
        }
        if (clientMaxRowsPerFrame < 0) {
            return this.config.getMaxRowsPerFrame();
        }
        return Math.min(clientMaxRowsPerFrame, this.config.getMaxRowsPerFrame());
    }
}

