/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.LimitRequestsFilter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class QueryJettyServerInitializer
implements JettyServerInitializer {
    private static final Logger log = new Logger(QueryJettyServerInitializer.class);
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/status/health", "/druid/historical/v1/readiness", "/druid/broker/v1/readiness"});
    private final List<Handler> extensionHandlers;
    private final ServerConfig serverConfig;
    private final AuthConfig authConfig;
    private final QuerySchedulerProvider querySchedulerConfig;

    @Inject
    public QueryJettyServerInitializer(Set<Handler> extensionHandlers, ServerConfig serverConfig, AuthConfig authConfig, @Global QuerySchedulerProvider querySchedulerConfig) {
        this.extensionHandlers = ImmutableList.copyOf(extensionHandlers);
        this.serverConfig = serverConfig;
        this.authConfig = authConfig;
        this.querySchedulerConfig = querySchedulerConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        if (this.serverConfig.isEnableRequestLimit()) {
            Preconditions.checkArgument((this.serverConfig.getNumThreads() > 1 ? 1 : 0) != 0, (Object)"numThreads must be > 1 to enable Request Limit Filter.");
            log.info("Enabling Request Limit Filter with limit [%d].", new Object[]{this.serverConfig.getNumThreads() - 1});
            root.addFilter(new FilterHolder((Filter)new LimitRequestsFilter(this.serverConfig.getNumThreads() - 1)), "/*", null);
        }
        if (this.querySchedulerConfig.getNumThreads() > 0 && this.querySchedulerConfig.getNumThreads() < this.serverConfig.getNumThreads() && this.serverConfig.isEnableQueryRequestsQueuing()) {
            log.info("Enabling QoS Filter on query requests with limit [%d].", new Object[]{this.querySchedulerConfig.getNumThreads()});
            JettyBindings.QosFilterHolder filterHolder = new JettyBindings.QosFilterHolder(new String[]{"/druid/v2/*"}, this.querySchedulerConfig.getNumThreads(), this.serverConfig.getMaxQueryTimeout());
            JettyServerInitUtils.addFilters((ServletContextHandler)root, Collections.singleton(filterHolder));
        }
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        JettyServerInitUtils.addQosFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, (List)this.authConfig.getUnsecuredPaths());
        List authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)this.authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addAllowHttpMethodsFilter((ServletContextHandler)root, (List)this.serverConfig.getAllowedHttpMethods());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        FilterHolder guiceFilterHolder = JettyServerInitUtils.getGuiceFilterHolder((Injector)injector);
        root.addFilter(guiceFilterHolder, "/*", null);
        HandlerList handlerList = new HandlerList();
        for (Handler handler : server.getHandlers()) {
            handlerList.addHandler(handler);
        }
        handlerList.addHandler(JettyServerInitUtils.getJettyRequestLogHandler());
        for (Handler handler : this.extensionHandlers) {
            handlerList.addHandler(handler);
        }
        JettyServerInitUtils.maybeAddHSTSRewriteHandler((ServerConfig)this.serverConfig, (HandlerList)handlerList);
        handlerList.addHandler((Handler)JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel()));
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.setHandler((Handler)handlerList);
        server.setHandler((Handler)statisticsHandler);
    }
}

