/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.druid.cli.CliBroker;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.InventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.RealtimeModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.NoopDataSegmentPusher;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.NoopDataSegmentAnnouncer;
import org.apache.druid.server.initialization.jetty.ChatHandlerServerModule;
import org.apache.druid.timeline.DataSegment;

@Command(name="realtime", description="Runs a standalone realtime node for examples, see http://druid.io/docs/latest/Realtime.html for a description")
public class CliRealtimeExample
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);
    @Inject
    private Properties properties;

    public CliRealtimeExample() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new RealtimeModule(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/realtime");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8084);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8284);
            binder.bind(DataSegmentPusher.class).to(NoopDataSegmentPusher.class).in(LazySingleton.class);
            binder.bind(DataSegmentAnnouncer.class).to(NoopDataSegmentAnnouncer.class).in(LazySingleton.class);
            binder.bind(InventoryView.class).to(NoopInventoryView.class).in(LazySingleton.class);
            binder.bind(ServerView.class).to(NoopServerView.class).in(LazySingleton.class);
        }, (Object)new ChatHandlerServerModule(this.properties), (Object)new LookupModule());
    }

    private static class NoopInventoryView
    implements InventoryView {
        private NoopInventoryView() {
        }

        public DruidServer getInventoryValue(String serverKey) {
            return null;
        }

        public Collection<DruidServer> getInventory() {
            return ImmutableList.of();
        }

        public boolean isStarted() {
            return true;
        }

        public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
            return false;
        }
    }

    private static class NoopServerView
    implements ServerView {
        private NoopServerView() {
        }

        public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
        }

        public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        }
    }
}

