/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util.datasets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.primes.Primes;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.sql.calcite.util.datasets.MapBasedTestDataset;

public class Numbers
extends MapBasedTestDataset {
    protected Numbers() {
        this("numbers");
    }

    public Numbers(String name) {
        super(name);
    }

    @Override
    public final InputRowSchema getInputRowSchema() {
        return new InputRowSchema(new TimestampSpec("t", "iso", null), new DimensionsSpec((List)ImmutableList.builder().add((Object)new LongDimensionSchema("number")).add((Object)new LongDimensionSchema("is_prime")).add((Object)new DoubleDimensionSchema("inverse")).add((Object)new StringDimensionSchema("label")).add((Object)new StringDimensionSchema("letters", DimensionSchema.MultiValueHandling.ARRAY, null)).build()), null);
    }

    @Override
    public List<AggregatorFactory> getMetrics() {
        return ImmutableList.of((Object)new CountAggregatorFactory("cnt"));
    }

    @Override
    public List<Map<String, Object>> getRawRows() {
        return ImmutableList.of(this.makeRow(1, "one"), this.makeRow(2, "two"), this.makeRow(3, "three"), this.makeRow(4, "four"), this.makeRow(5, "five"), this.makeRow(6, "six"), this.makeRow(7, "seven"), this.makeRow(8, "eight"), this.makeRow(9, "nine"), this.makeRow(10, "ten"));
    }

    private Map<String, Object> makeRow(int num, String string) {
        return ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"number", (Object)Integer.toString(num)).put((Object)"is_prime", (Object)Primes.isPrime((int)num)).put((Object)"inverse", (Object)(1.0 / (double)num)).put((Object)"label", (Object)string).put((Object)"letters", this.lettersOf(string)).build();
    }

    private List<String> lettersOf(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        for (char c : string.toCharArray()) {
            ret.add(String.valueOf(c));
        }
        return ret;
    }
}

