/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util.datasets;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;

public abstract class MapBasedTestDataset
implements TestDataSet {
    protected final String name;

    protected MapBasedTestDataset(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final DataSegment makeSegment(QueryableIndex index) {
        DataSegment segment = DataSegment.builder().dataSource(this.name).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        return segment;
    }

    @Override
    public final QueryableIndex makeIndex(File tmpDir) {
        return IndexBuilder.create().tmpDir(new File(tmpDir, "idx")).inputTmpDir(new File(tmpDir, "input")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(this.getIndexSchema()).rows(this.getRows()).buildMMappedIndex();
    }

    public IncrementalIndexSchema getIndexSchema() {
        return new IncrementalIndexSchema.Builder().withMetrics(this.getMetrics().toArray(new AggregatorFactory[0])).withDimensionsSpec(this.getInputRowSchema().getDimensionsSpec()).withRollup(false).build();
    }

    public final Iterable<InputRow> getRows() {
        return this.getRawRows().stream().map(raw -> MapBasedTestDataset.createRow(raw, this.getInputRowSchema())).collect(Collectors.toList());
    }

    public static InputRow createRow(Map<String, ?> map, InputRowSchema inputRowSchema) {
        return MapInputRowParser.parse((InputRowSchema)inputRowSchema, map);
    }

    public RowSignature getInputRowSignature() {
        RowSignature.Builder rsBuilder = RowSignature.builder();
        for (DimensionSchema dimensionSchema : this.getInputRowSchema().getDimensionsSpec().getDimensions()) {
            rsBuilder.add(dimensionSchema.getName(), dimensionSchema.getColumnType());
        }
        return rsBuilder.build();
    }

    public abstract InputRowSchema getInputRowSchema();

    public abstract List<Map<String, Object>> getRawRows();

    public abstract List<AggregatorFactory> getMetrics();
}

