/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.server.EtagProvider;

public class CacheTestHelperModule
extends AbstractModule {
    protected final Cache cache;
    private CacheConfig cacheConfig;
    private EtagProvider etagProvider;

    public CacheTestHelperModule(ResultCacheMode resultCacheMode) {
        this.cacheConfig = new TestCacheConfig(resultCacheMode);
        switch (resultCacheMode) {
            case ENABLED: {
                this.etagProvider = new EtagProvider.ProvideEtagBasedOnDatasource();
                this.cache = MapCache.create((long)1000000L);
                break;
            }
            case DISABLED: {
                this.etagProvider = new EtagProvider.EmptyEtagProvider();
                this.cache = null;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Provides
    EtagProvider etagProvider() {
        return this.etagProvider;
    }

    @Provides
    CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Provides
    Cache getCache() {
        return this.cache;
    }

    public void configure() {
    }

    static class TestCacheConfig
    extends CacheConfig {
        private ResultCacheMode resultLevelCache;

        public TestCacheConfig(ResultCacheMode resultCacheMode) {
            this.resultLevelCache = resultCacheMode;
        }

        public boolean isPopulateResultLevelCache() {
            return this.resultLevelCache.isPopulateResultLevelCache();
        }

        public boolean isUseResultLevelCache() {
            return this.resultLevelCache.isUseResultLevelCache();
        }
    }

    public static enum ResultCacheMode {
        DISABLED,
        ENABLED;


        public Module makeModule() {
            return new CacheTestHelperModule(this);
        }

        public boolean isPopulateResultLevelCache() {
            return this != DISABLED;
        }

        public boolean isUseResultLevelCache() {
            return this != DISABLED;
        }
    }
}

