/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.ServiceStatusMonitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceStatusMonitorTest {
    private ServiceStatusMonitor monitor;
    private Map<String, Object> heartbeatTags;
    private Supplier<Map<String, Object>> heartbeatTagsSupplier = () -> this.heartbeatTags;
    private static String HEARTBEAT_METRIC_KEY = "service/heartbeat";

    @Before
    public void setUp() {
        this.monitor = new ServiceStatusMonitor();
        this.heartbeatTags = new HashMap<String, Object>();
        this.monitor.heartbeatTagsSupplier = this.heartbeatTagsSupplier;
    }

    @Test
    public void testDefaultHeartbeatReported() {
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        this.monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)1L, (long)emitter.getEvents().size());
        Assert.assertEquals((Object)HEARTBEAT_METRIC_KEY, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"value"));
    }

    @Test
    public void testLeaderTag() {
        this.heartbeatTags.put("leader", 1);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        this.monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)1L, (long)emitter.getEvents().size());
        Assert.assertEquals((Object)1, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"leader"));
        Assert.assertEquals((Object)HEARTBEAT_METRIC_KEY, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"value"));
    }

    @Test
    public void testMoreThanOneTag() {
        this.heartbeatTags.put("leader", 1);
        this.heartbeatTags.put("taskRunner", "http");
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        this.monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)1L, (long)emitter.getEvents().size());
        Assert.assertEquals((Object)1, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"leader"));
        Assert.assertEquals((Object)"http", (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"taskRunner"));
        Assert.assertEquals((Object)HEARTBEAT_METRIC_KEY, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"value"));
    }
}

