/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.server.metrics.GroupByStatsMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByStatsMonitorTest {
    private GroupByStatsProvider groupByStatsProvider;
    private BlockingPool<ByteBuffer> mergeBufferPool;
    private ExecutorService executorService;

    @Before
    public void setUp() {
        this.groupByStatsProvider = new GroupByStatsProvider(){

            public synchronized GroupByStatsProvider.AggregateStats getStatsSince() {
                return new GroupByStatsProvider.AggregateStats(1L, 100L, 2L, 200L, 300L);
            }
        };
        this.mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(1024), 5);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void testMonitor() {
        GroupByStatsMonitor monitor = new GroupByStatsMonitor(this.groupByStatsProvider, this.mergeBufferPool);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        emitter.flush();
        monitor.doMonitor((ServiceEmitter)emitter);
        Map<String, Long> resultMap = emitter.getEvents().stream().collect(Collectors.toMap(event -> (String)event.toMap().get((Object)"metric"), event -> (Long)event.toMap().get((Object)"value")));
        Assert.assertEquals((long)7L, (long)resultMap.size());
        Assert.assertEquals((long)0L, (long)resultMap.get("mergeBuffer/pendingRequests"));
        Assert.assertEquals((long)0L, (long)resultMap.get("mergeBuffer/used"));
        Assert.assertEquals((long)1L, (long)resultMap.get("mergeBuffer/queries"));
        Assert.assertEquals((long)100L, (long)resultMap.get("mergeBuffer/acquisitionTimeNs"));
        Assert.assertEquals((long)2L, (long)resultMap.get("groupBy/spilledQueries"));
        Assert.assertEquals((long)200L, (long)resultMap.get("groupBy/spilledBytes"));
        Assert.assertEquals((long)300L, (long)resultMap.get("groupBy/mergeDictionarySize"));
    }

    @Test
    public void testMonitoringMergeBuffer_acquiredCount() throws ExecutionException, InterruptedException, TimeoutException {
        this.executorService.submit(() -> this.mergeBufferPool.takeBatch(4)).get(20L, TimeUnit.SECONDS);
        GroupByStatsMonitor monitor = new GroupByStatsMonitor(this.groupByStatsProvider, this.mergeBufferPool);
        StubServiceEmitter emitter = new StubServiceEmitter("DummyService", "DummyHost");
        boolean ret = monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertTrue((boolean)ret);
        List numbers = emitter.getMetricValues("mergeBuffer/used", Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)numbers.size());
        Assert.assertEquals((long)4L, (long)((Number)numbers.get(0)).intValue());
    }

    @Test(timeout=2000L)
    public void testMonitoringMergeBuffer_pendingRequests() {
        this.executorService.submit(() -> this.mergeBufferPool.takeBatch(10));
        int count = 0;
        try {
            while (this.mergeBufferPool.getPendingRequests() == 0L) {
                Thread.sleep(100L);
                if (++count < 20) continue;
            }
            GroupByStatsMonitor monitor = new GroupByStatsMonitor(this.groupByStatsProvider, this.mergeBufferPool);
            StubServiceEmitter emitter = new StubServiceEmitter("DummyService", "DummyHost");
            boolean ret = monitor.doMonitor((ServiceEmitter)emitter);
            Assert.assertTrue((boolean)ret);
            List numbers = emitter.getMetricValues("mergeBuffer/pendingRequests", Collections.emptyMap());
            Assert.assertEquals((long)1L, (long)numbers.size());
            Assert.assertEquals((long)1L, (long)((Number)numbers.get(0)).intValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

