/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.junit.Assert;
import org.junit.Test;

public class AlertEventSerdeTest {
    @Test
    public void testSerializeAlertEventMap() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String timestamp = "2022-08-17T18:51:00.000Z";
        AlertEvent event = new AlertEvent(DateTimes.of((String)timestamp), "my-service", "my-host", AlertEvent.Severity.DEFAULT, "my-description", Collections.emptyMap());
        String actual = mapper.writeValueAsString((Object)event.toMap());
        String expected = "{\"feed\":\"alerts\",\"timestamp\":\"" + timestamp + "\",\"severity\":\"" + String.valueOf(AlertEvent.Severity.DEFAULT) + "\",\"service\":\"my-service\",\"host\":\"my-host\",\"description\":\"my-description\",\"data\":{}}";
        Assert.assertEquals((Object)mapper.readTree(expected), (Object)mapper.readTree(actual));
    }
}

