/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.initialization.AuthorizerMapperModule;
import org.apache.druid.server.security.AuthValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorizerMapperModuleTest {
    private AuthorizerMapperModule target;
    private Injector injector;

    @Before
    public void setUp() {
        this.target = new AuthorizerMapperModule();
        this.injector = Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
        }, this.target});
    }

    @Test
    public void testAuthorizerNameValidatorIsInjectedAsSingleton() {
        AuthValidator authValidator = (AuthValidator)this.injector.getInstance(AuthValidator.class);
        AuthValidator other = (AuthValidator)this.injector.getInstance(AuthValidator.class);
        Assert.assertSame((Object)authValidator, (Object)other);
    }
}

