/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SegmentUpdateResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.rules.IntervalDropRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.http.DataSourcesResource;
import org.apache.druid.server.http.SegmentsToUpdateFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.test.utils.ImmutableDruidDataSourceTestUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourcesResourceTest {
    private CoordinatorServerView inventoryView;
    private DruidServer server;
    private List<DruidDataSource> listDataSources;
    private List<DataSegment> dataSegmentList;
    private HttpServletRequest request;
    private SegmentsMetadataManager segmentsMetadataManager;
    private OverlordClient overlordClient;
    private AuditManager auditManager;
    private DataSourcesResource dataSourcesResource;

    @Before
    public void setUp() {
        this.request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        this.inventoryView = (CoordinatorServerView)EasyMock.createStrictMock(CoordinatorServerView.class);
        this.server = (DruidServer)EasyMock.niceMock(DruidServer.class);
        this.auditManager = (AuditManager)EasyMock.niceMock(AuditManager.class);
        this.dataSegmentList = new ArrayList<DataSegment>();
        this.dataSegmentList.add(new DataSegment("wiki", Intervals.of((String)"2010-01-01/P1D"), "v0", null, null, null, null, Integer.valueOf(9), 10L));
        this.dataSegmentList.add(new DataSegment("wiki", Intervals.of((String)"2010-01-22/P1D"), "v0", null, null, null, null, Integer.valueOf(9), 20L));
        this.dataSegmentList.add(new DataSegment("koala", Intervals.of((String)"2010-01-01/P1D"), "v0", null, null, null, null, Integer.valueOf(9), 30L));
        this.listDataSources = new ArrayList<DruidDataSource>();
        this.listDataSources.add(new DruidDataSource("wiki", new HashMap()).addSegment(this.dataSegmentList.get(0)));
        this.listDataSources.add(new DruidDataSource("koala", new HashMap()).addSegment(this.dataSegmentList.get(1)));
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createMock(SegmentsMetadataManager.class);
        this.overlordClient = (OverlordClient)EasyMock.createStrictMock(OverlordClient.class);
        this.dataSourcesResource = new DataSourcesResource(this.inventoryView, this.segmentsMetadataManager, null, this.overlordClient, AuthTestUtils.TEST_AUTHORIZER_MAPPER, null, this.auditManager);
    }

    @Test
    public void testGetFullQueryableDataSources() {
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        Response response = this.dataSourcesResource.getQueryableDataSources("full", null, this.request);
        Set result = (Set)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)2L, (long)result.size());
        ImmutableDruidDataSourceTestUtils.assertEquals(this.listDataSources.stream().map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toList()), new ArrayList<ImmutableDruidDataSource>(result));
        response = this.dataSourcesResource.getQueryableDataSources(null, null, this.request);
        List result1 = (List)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)2L, (long)result1.size());
        Assert.assertTrue((boolean)result1.contains("wiki"));
        Assert.assertTrue((boolean)result1.contains("koala"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSecuredGetFullQueryableDataSources() {
        AuthenticationResult authenticationResult = new AuthenticationResult("druid", "druid", null, null);
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult1, Resource resource, Action action) {
                        if (resource.getName().equals("wiki")) {
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        DataSourcesResource dataSourcesResource = new DataSourcesResource(this.inventoryView, null, null, this.overlordClient, authMapper, null, this.auditManager);
        Response response = dataSourcesResource.getQueryableDataSources("full", null, this.request);
        Set result = (Set)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)result.size());
        ImmutableDruidDataSourceTestUtils.assertEquals(this.listDataSources.get(0).toImmutableDruidDataSource(), (ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)result));
        response = dataSourcesResource.getQueryableDataSources(null, null, this.request);
        List result1 = (List)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)result1.size());
        Assert.assertTrue((boolean)result1.contains("wiki"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server, this.request});
    }

    @Test
    public void testGetSimpleQueryableDataSources() {
        EasyMock.expect((Object)this.server.getDataSources()).andReturn(this.listDataSources).atLeastOnce();
        EasyMock.expect((Object)this.server.getDataSource("wiki")).andReturn((Object)this.listDataSources.get(0)).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.server.getDataSource("koala")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        Response response = this.dataSourcesResource.getQueryableDataSources(null, "simple", this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List results = (List)response.getEntity();
        Assert.assertEquals((long)2L, (long)results.size());
        for (Map entry : results) {
            Assert.assertTrue((boolean)((Map)((Map)entry.get("properties")).get("tiers")).containsKey(null));
            Assert.assertNotNull(((Map)entry.get("properties")).get("segments"));
            Assert.assertEquals((Object)1, ((Map)((Map)entry.get("properties")).get("segments")).get("count"));
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testFullGetTheDataSource() {
        DruidDataSource dataSource1 = new DruidDataSource("wiki", new HashMap());
        EasyMock.expect((Object)this.server.getDataSource("wiki")).andReturn((Object)dataSource1).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        Response response = this.dataSourcesResource.getQueryableDataSource("wiki", "full");
        ImmutableDruidDataSource result = (ImmutableDruidDataSource)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ImmutableDruidDataSourceTestUtils.assertEquals(dataSource1.toImmutableDruidDataSource(), result);
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testNullGetTheDataSource() {
        EasyMock.expect((Object)this.server.getDataSource("none")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        Assert.assertEquals((long)204L, (long)this.dataSourcesResource.getQueryableDataSource("none", null).getStatus());
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSimpleGetTheDataSource() {
        DruidDataSource dataSource1 = new DruidDataSource("wiki", new HashMap());
        dataSource1.addSegment(new DataSegment("datasegment1", Intervals.of((String)"2010-01-01/P1D"), "", null, null, null, null, Integer.valueOf(9), 10L));
        EasyMock.expect((Object)this.server.getDataSource("wiki")).andReturn((Object)dataSource1).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        Response response = this.dataSourcesResource.getQueryableDataSource("wiki", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result = (Map)response.getEntity();
        Assert.assertEquals((Object)1, ((Map)((Map)result.get("tiers")).get(null)).get("segmentCount"));
        Assert.assertEquals((Object)10L, ((Map)((Map)result.get("tiers")).get(null)).get("size"));
        Assert.assertEquals((Object)10L, ((Map)((Map)result.get("tiers")).get(null)).get("replicatedSize"));
        Assert.assertNotNull(result.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-02T00:00:00.000Z", (Object)((Map)result.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)1, ((Map)result.get("segments")).get("count"));
        Assert.assertEquals((Object)10L, ((Map)result.get("segments")).get("size"));
        Assert.assertEquals((Object)10L, ((Map)result.get("segments")).get("replicatedSize"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSimpleGetTheDataSourceManyTiers() {
        EasyMock.expect((Object)this.server.getDataSource("wiki")).andReturn((Object)this.listDataSources.get(0)).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn((Object)"cold").atLeastOnce();
        DruidServer server2 = (DruidServer)EasyMock.createStrictMock(DruidServer.class);
        EasyMock.expect((Object)server2.getDataSource("wiki")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)server2.getTier()).andReturn((Object)"hot").atLeastOnce();
        DruidServer server3 = (DruidServer)EasyMock.createStrictMock(DruidServer.class);
        EasyMock.expect((Object)server3.getDataSource("wiki")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)server3.getTier()).andReturn((Object)"cold").atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server, (Object)server2, (Object)server3)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, server2, server3});
        Response response = this.dataSourcesResource.getQueryableDataSource("wiki", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result = (Map)response.getEntity();
        Assert.assertEquals((Object)2, ((Map)((Map)result.get("tiers")).get("cold")).get("segmentCount"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result.get("tiers")).get("cold")).get("size"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result.get("tiers")).get("cold")).get("replicatedSize"));
        Assert.assertEquals((Object)1, ((Map)((Map)result.get("tiers")).get("hot")).get("segmentCount"));
        Assert.assertEquals((Object)20L, ((Map)((Map)result.get("tiers")).get("hot")).get("size"));
        Assert.assertNotNull(result.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-23T00:00:00.000Z", (Object)((Map)result.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)2, ((Map)result.get("segments")).get("count"));
        Assert.assertEquals((Object)30L, ((Map)result.get("segments")).get("size"));
        Assert.assertEquals((Object)50L, ((Map)result.get("segments")).get("replicatedSize"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server, server2, server3});
    }

    @Test
    public void testSimpleGetTheDataSourceWithReplicatedSegments() {
        this.server = new DruidServer("server1", "host1", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        DruidServer server2 = new DruidServer("server2", "host2", null, 1234L, ServerType.HISTORICAL, "tier2", 0);
        DruidServer server3 = new DruidServer("server3", "host3", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
        server2.addDataSegment(this.dataSegmentList.get(0));
        server2.addDataSegment(this.dataSegmentList.get(1));
        server3.addDataSegment(this.dataSegmentList.get(2));
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server, (Object)server2, (Object)server3)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView});
        Response response = this.dataSourcesResource.getQueryableDataSource("wiki", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result1 = (Map)response.getEntity();
        Assert.assertEquals((Object)2, ((Map)((Map)result1.get("tiers")).get("tier1")).get("segmentCount"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result1.get("tiers")).get("tier1")).get("size"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result1.get("tiers")).get("tier1")).get("replicatedSize"));
        Assert.assertEquals((Object)2, ((Map)((Map)result1.get("tiers")).get("tier2")).get("segmentCount"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result1.get("tiers")).get("tier2")).get("size"));
        Assert.assertNotNull(result1.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result1.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-23T00:00:00.000Z", (Object)((Map)result1.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)2, ((Map)result1.get("segments")).get("count"));
        Assert.assertEquals((Object)30L, ((Map)result1.get("segments")).get("size"));
        Assert.assertEquals((Object)60L, ((Map)result1.get("segments")).get("replicatedSize"));
        response = this.dataSourcesResource.getQueryableDataSource("koala", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result2 = (Map)response.getEntity();
        Assert.assertEquals((Object)1, ((Map)((Map)result2.get("tiers")).get("tier1")).get("segmentCount"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result2.get("tiers")).get("tier1")).get("size"));
        Assert.assertEquals((Object)60L, ((Map)((Map)result2.get("tiers")).get("tier1")).get("replicatedSize"));
        Assert.assertNotNull(result2.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result2.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-02T00:00:00.000Z", (Object)((Map)result2.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)1, ((Map)result2.get("segments")).get("count"));
        Assert.assertEquals((Object)30L, ((Map)result2.get("segments")).get("size"));
        Assert.assertEquals((Object)60L, ((Map)result2.get("segments")).get("replicatedSize"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }

    @Test
    public void testGetSegmentDataSourceIntervals() {
        this.server = new DruidServer("who", "host", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView});
        ArrayList<Interval> expectedIntervals = new ArrayList<Interval>();
        expectedIntervals.add(Intervals.of((String)"2010-01-22T00:00:00.000Z/2010-01-23T00:00:00.000Z"));
        expectedIntervals.add(Intervals.of((String)"2010-01-01T00:00:00.000Z/2010-01-02T00:00:00.000Z"));
        Response response = this.dataSourcesResource.getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals("invalidDataSource", null, null);
        Assert.assertNull((Object)response.getEntity());
        response = this.dataSourcesResource.getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals("wiki", null, null);
        TreeSet actualIntervals = (TreeSet)response.getEntity();
        Assert.assertEquals((long)2L, (long)actualIntervals.size());
        Assert.assertEquals(expectedIntervals.get(0), actualIntervals.first());
        Assert.assertEquals(expectedIntervals.get(1), actualIntervals.last());
        response = this.dataSourcesResource.getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals("wiki", "simple", null);
        TreeMap results = (TreeMap)response.getEntity();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals(expectedIntervals.get(0), results.firstKey());
        Assert.assertEquals(expectedIntervals.get(1), results.lastKey());
        Assert.assertEquals((Object)1, ((Map)results.firstEntry().getValue()).get(DataSourcesResource.SimpleProperties.count));
        Assert.assertEquals((Object)1, ((Map)results.lastEntry().getValue()).get(DataSourcesResource.SimpleProperties.count));
        response = this.dataSourcesResource.getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals("wiki", null, "full");
        Map results2 = (Map)response.getEntity();
        int i = 1;
        for (Map.Entry entry : results2.entrySet()) {
            Assert.assertEquals((Object)this.dataSegmentList.get(i).getInterval(), entry.getKey());
            Assert.assertEquals((Object)this.dataSegmentList.get(i), ((Map)((Map)entry.getValue()).get(this.dataSegmentList.get(i).getId())).get("metadata"));
            --i;
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }

    @Test
    public void testGetServedSegmentsInIntervalInDataSource() {
        int i;
        this.server = new DruidServer("who", "host", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView});
        Response response = this.dataSourcesResource.getServedSegmentsInInterval("invalidDataSource", "2010-01-01/P1D", null, null);
        Assert.assertNull((Object)response.getEntity());
        response = this.dataSourcesResource.getServedSegmentsInInterval("wiki", "2010-03-01/P1D", null, null);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)response.getEntity());
        response = this.dataSourcesResource.getServedSegmentsInInterval("wiki", "2010-01-01/P1D", null, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.dataSegmentList.get(0).getId()), (Object)response.getEntity());
        response = this.dataSourcesResource.getServedSegmentsInInterval("wiki", "2010-01-01/P1M", null, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.dataSegmentList.get(1).getId(), (Object)this.dataSegmentList.get(0).getId()), (Object)response.getEntity());
        response = this.dataSourcesResource.getServedSegmentsInInterval("wiki", "2010-01-01/P1M", "simple", null);
        Map results = (Map)response.getEntity();
        Assert.assertEquals((long)2L, (long)results.size());
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)results.containsKey(this.dataSegmentList.get(i).getInterval()));
            Assert.assertEquals((Object)1, ((Map)results.get(this.dataSegmentList.get(i).getInterval())).get(DataSourcesResource.SimpleProperties.count));
        }
        response = this.dataSourcesResource.getServedSegmentsInInterval("wiki", "2010-01-01/P1M", null, "full");
        Map results1 = (Map)response.getEntity();
        i = 1;
        for (Map.Entry entry : results1.entrySet()) {
            Assert.assertEquals((Object)this.dataSegmentList.get(i).getInterval(), entry.getKey());
            Assert.assertEquals((Object)this.dataSegmentList.get(i), ((Map)((Map)entry.getValue()).get(this.dataSegmentList.get(i).getId())).get("metadata"));
            --i;
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }

    @Test
    public void testKillSegmentsInIntervalInDataSource() {
        String interval = "2010-01-01/P1D";
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        EasyMock.expect((Object)this.overlordClient.runKillTask("api-issued", "wiki", theInterval, null, null, null)).andReturn((Object)Futures.immediateFuture((Object)"kill_task_1"));
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.killUnusedSegmentsInInterval("wiki", interval, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.server});
    }

    @Test
    public void testMarkAsUnusedAllSegmentsInDataSourceBadRequest() {
        DruidExceptionMatcher.invalidInput().assertThrowsAndMatches(() -> this.dataSourcesResource.markAsUnusedAllSegmentsOrKillUnusedSegmentsInInterval("datasource", "true", "???", this.request));
    }

    @Test
    public void testMarkAsUnusedAllSegmentsInDataSource() {
        this.prepareRequestForAudit();
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki")).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.server});
        Response response = this.dataSourcesResource.markAsUnusedAllSegmentsOrKillUnusedSegmentsInInterval("wiki", null, null, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.request});
    }

    @Test
    public void testIsHandOffComplete() {
        MetadataRuleManager databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        IntervalLoadRule loadRule = new IntervalLoadRule(Intervals.of((String)"2013-01-02T00:00:00Z/2013-01-03T00:00:00Z"), null, null);
        IntervalDropRule dropRule = new IntervalDropRule(Intervals.of((String)"2013-01-01T00:00:00Z/2013-01-02T00:00:00Z"));
        DataSourcesResource dataSourcesResource = new DataSourcesResource(this.inventoryView, null, databaseRuleManager, null, null, null, this.auditManager);
        EasyMock.expect((Object)databaseRuleManager.getRulesWithDefault("wiki")).andReturn((Object)ImmutableList.of((Object)loadRule, (Object)dropRule)).once();
        EasyMock.replay((Object[])new Object[]{databaseRuleManager});
        String interval1 = "2013-01-01T01:00:00Z/2013-01-01T02:00:00Z";
        Response response1 = dataSourcesResource.isHandOffComplete("wiki", interval1, 1, "v1");
        Assert.assertTrue((boolean)((Boolean)response1.getEntity()));
        EasyMock.verify((Object[])new Object[]{databaseRuleManager});
        EasyMock.reset((Object[])new Object[]{databaseRuleManager});
        EasyMock.expect((Object)databaseRuleManager.getRulesWithDefault("wiki")).andReturn((Object)ImmutableList.of((Object)loadRule, (Object)dropRule)).once();
        EasyMock.expect((Object)this.inventoryView.getTimeline((DataSource)new TableDataSource("wiki"))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, databaseRuleManager});
        String interval2 = "2013-01-02T01:00:00Z/2013-01-02T02:00:00Z";
        Response response2 = dataSourcesResource.isHandOffComplete("wiki", interval2, 1, "v1");
        Assert.assertFalse((boolean)((Boolean)response2.getEntity()));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, databaseRuleManager});
        final String interval3 = "2013-01-02T02:00:00Z/2013-01-02T03:00:00Z";
        final SegmentLoadInfo segmentLoadInfo = new SegmentLoadInfo(this.createSegment(Intervals.of((String)interval3), "v1", 1));
        segmentLoadInfo.addServer(this.createHistoricalServerMetadata("test"));
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = new VersionedIntervalTimeline<String, SegmentLoadInfo>(null){

            public List<TimelineObjectHolder<String, SegmentLoadInfo>> lookupWithIncompletePartitions(Interval interval) {
                PartitionHolder partitionHolder = new PartitionHolder((PartitionChunk)new NumberedPartitionChunk(1, 1, (Object)segmentLoadInfo));
                ArrayList<TimelineObjectHolder<String, SegmentLoadInfo>> ret = new ArrayList<TimelineObjectHolder<String, SegmentLoadInfo>>();
                ret.add(new TimelineObjectHolder(Intervals.of((String)interval3), (Object)"v1", partitionHolder));
                return ret;
            }
        };
        EasyMock.reset((Object[])new Object[]{this.inventoryView, databaseRuleManager});
        EasyMock.expect((Object)databaseRuleManager.getRulesWithDefault("wiki")).andReturn((Object)ImmutableList.of((Object)loadRule, (Object)dropRule)).once();
        EasyMock.expect((Object)this.inventoryView.getTimeline((DataSource)new TableDataSource("wiki"))).andReturn((Object)timeline).once();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, databaseRuleManager});
        Response response3 = dataSourcesResource.isHandOffComplete("wiki", interval3, 1, "v1");
        Assert.assertTrue((boolean)((Boolean)response3.getEntity()));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, databaseRuleManager});
    }

    @Test
    public void testMarkSegmentAsUsed() {
        DataSegment segment = this.dataSegmentList.get(0);
        EasyMock.expect((Object)this.overlordClient.markSegmentAsUsed(segment.getId())).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(1))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markSegmentAsUsed(segment.getDataSource(), segment.getId().toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkSegmentAsUsedWhenOverlordIsOnOldVersion() {
        DataSegment segment = this.dataSegmentList.get(0);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND), StandardCharsets.UTF_8);
        EasyMock.expect((Object)this.overlordClient.markSegmentAsUsed(segment.getId())).andThrow((Throwable)new RuntimeException((Throwable)new HttpResponseException(responseHolder))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markSegmentAsUsed(segment.getDataSource(), segment.getId().toString());
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Object payload = response.getEntity();
        Assert.assertTrue((boolean)(payload instanceof ErrorResponse));
        ErrorResponse errorResponse = (ErrorResponse)payload;
        Assert.assertEquals((Object)"Could not update segments since Overlord is on an older version.", errorResponse.getAsMap().get("errorMessage"));
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkSegmentAsUsedNoChange() {
        DataSegment segment = this.dataSegmentList.get(0);
        EasyMock.expect((Object)this.overlordClient.markSegmentAsUsed(segment.getId())).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markSegmentAsUsed(segment.getDataSource(), segment.getId().toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInterval() {
        Interval interval = Intervals.of((String)"2010-01-22/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(interval, null, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(3))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsIntervalWithVersions() {
        Interval interval = Intervals.of((String)"2010-01-22/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(interval, null, (List)ImmutableList.of((Object)"v0"));
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(3))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsIntervalWithNonExistentVersion() {
        Interval interval = Intervals.of((String)"2010-01-22/P1D");
        SegmentsToUpdateFilter filter = new SegmentsToUpdateFilter(interval, null, (List)ImmutableList.of((Object)"foo"));
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", filter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", filter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsIntervalNoneUpdated() {
        Interval interval = Intervals.of((String)"2010-01-22/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(interval, null, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsSet() {
        ImmutableSet segmentIds = ImmutableSet.of((Object)this.dataSegmentList.get(1).getId().toString());
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(null, (Set)segmentIds, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(3))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsIntervalException() {
        Interval interval = Intervals.of((String)"2010-01-22/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(interval, null, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andThrow((Throwable)new RuntimeException("Error!")).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsNoDataSource() {
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.of((String)"2010-01-22/P1D"), null, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNullIntervalAndSegmentIdsAndVersions() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(null, null, null));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullIntervalAndEmptySegmentIds() {
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.of((String)"2010-01-22/P1D"), (Set)ImmutableSet.of(), null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(2))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(2), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullInterval() {
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.of((String)"2010-01-22/P1D"), null, null);
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullIntervalAndSegmentIds() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(Intervals.of((String)"2010-01-22/P1D"), (Set)ImmutableSet.of((Object)"segment1"), null));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullIntervalAndSegmentIdsAndVersions() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(Intervals.of((String)"2020/2030"), (Set)ImmutableSet.of((Object)"seg1"), (List)ImmutableList.of((Object)"v1", (Object)"v2")));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithEmptySegmentIds() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(null, (Set)ImmutableSet.of(), null));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithEmptyVersions() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(null, null, (List)ImmutableList.of()));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullVersions() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(null, null, (List)ImmutableList.of((Object)"v1", (Object)"v2")));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullSegmentIdsAndVersions() {
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", new SegmentsToUpdateFilter(null, (Set)ImmutableSet.of((Object)"segment1"), (List)ImmutableList.of((Object)"v1", (Object)"v2")));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullIntervalAndVersions() {
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.ETERNITY, null, (List)ImmutableList.of((Object)"v1", (Object)"v2"));
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(2))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(2), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonNullIntervalAndEmptyVersions() {
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.ETERNITY, null, (List)ImmutableList.of());
        EasyMock.expect((Object)this.overlordClient.markNonOvershadowedSegmentsAsUsed("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(5))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markAsUsedNonOvershadowedSegments("wiki", segmentFilter);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(5), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testSegmentLoadChecksForVersion() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertFalse((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v2", 2)));
        Assert.assertTrue((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v2", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertTrue((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testSegmentLoadChecksForAssignableServer() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertFalse((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createRealtimeServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testSegmentLoadChecksForPartitionNumber() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 1)));
        Assert.assertFalse((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testSegmentLoadChecksForInterval() {
        Assert.assertFalse((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-02"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-01/2011-04-03"), "v1", 1)));
        Assert.assertTrue((boolean)DataSourcesResource.isSegmentLoaded(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-04"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-02/2011-04-03"), "v1", 1)));
    }

    @Test
    public void testMarkSegmentsAsUnused() {
        DruidDataSource dataSource1 = new DruidDataSource("wiki", new HashMap());
        Set segmentIds = this.dataSegmentList.stream().filter(segment -> segment.getDataSource().equals(dataSource1.getName())).map(DataSegment::getId).collect(Collectors.toSet());
        SegmentsToUpdateFilter payload = new SegmentsToUpdateFilter(null, segmentIds.stream().map(SegmentId::toString).collect(Collectors.toSet()), null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", payload)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(1))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", payload, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(1), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkSegmentsAsUnusedNoChanges() {
        DruidDataSource dataSource1 = new DruidDataSource("wiki", new HashMap());
        Set segmentIds = this.dataSegmentList.stream().filter(segment -> segment.getDataSource().equals(dataSource1.getName())).map(DataSegment::getId).collect(Collectors.toSet());
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(null, segmentIds.stream().map(SegmentId::toString).collect(Collectors.toSet()), null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkSegmentsAsUnusedException() {
        DruidDataSource dataSource1 = new DruidDataSource("wiki", new HashMap());
        Set segmentIds = this.dataSegmentList.stream().filter(segment -> segment.getDataSource().equals(dataSource1.getName())).map(DataSegment::getId).collect(Collectors.toSet());
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(null, segmentIds.stream().map(SegmentId::toString).collect(Collectors.toSet()), null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andThrow((Throwable)new RuntimeException("Exception occurred")).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUnusedSegmentsInInterval() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(1))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(1), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalNoChanges() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalException() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andThrow((Throwable)new RuntimeException("Exception occurred")).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalNoDataSource() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithVersions() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, (List)ImmutableList.of((Object)"v1"));
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(2))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(2), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithNonExistentVersion() {
        Interval theInterval = Intervals.of((String)"2010-01-01/P1D");
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(theInterval, null, (List)ImmutableList.of((Object)"foo"));
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.inventoryView, this.server});
        this.prepareRequestForAudit();
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testSegmentsToUpdateFilterSerde() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String payload = "{\"interval\":\"2023-01-01T00:00:00.000Z/2024-01-01T00:00:00.000Z\",\"segmentIds\":null,\"versions\":[\"v1\"]}";
        SegmentsToUpdateFilter obj = (SegmentsToUpdateFilter)mapper.readValue("{\"interval\":\"2023-01-01T00:00:00.000Z/2024-01-01T00:00:00.000Z\",\"segmentIds\":null,\"versions\":[\"v1\"]}", SegmentsToUpdateFilter.class);
        Assert.assertEquals((Object)Intervals.of((String)"2023/2024"), (Object)obj.getInterval());
        Assert.assertEquals((Object)ImmutableList.of((Object)"v1"), (Object)obj.getVersions());
        Assert.assertNull((Object)obj.getSegmentIds());
        Assert.assertEquals((Object)"{\"interval\":\"2023-01-01T00:00:00.000Z/2024-01-01T00:00:00.000Z\",\"segmentIds\":null,\"versions\":[\"v1\"]}", (Object)mapper.writeValueAsString((Object)obj));
    }

    @Test
    public void testMarkSegmentsAsUnusedNullPayload() {
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", null, this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((Object)"Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.", (Object)response.getEntity());
    }

    @Test
    public void testMarkSegmentsAsUnusedWithNullIntervalAndSegmentIdsAndVersions() {
        SegmentsToUpdateFilter payload = new SegmentsToUpdateFilter(null, null, null);
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", payload, this.request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
    }

    @Test
    public void testMarkSegmentsAsUnusedWithNonNullIntervalAndEmptySegmentIds() {
        this.prepareRequestForAudit();
        SegmentsToUpdateFilter segmentFilter = new SegmentsToUpdateFilter(Intervals.of((String)"2010-01-01/P1D"), (Set)ImmutableSet.of(), null);
        EasyMock.expect((Object)this.overlordClient.markSegmentsAsUnused("wiki", segmentFilter)).andReturn((Object)Futures.immediateFuture((Object)new SegmentUpdateResponse(0))).once();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        Response response = this.dataSourcesResource.markSegmentsAsUnused("wiki", segmentFilter, this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new SegmentUpdateResponse(0), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{this.overlordClient});
    }

    @Test
    public void testGetDatasourceLoadstatusForceMetadataRefreshNull() {
        Response response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", null, null, null, null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testGetDatasourceLoadstatusNoSegmentForInterval() {
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments(List.of())).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        Response response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, null, null, null);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testGetDatasourceLoadstatusDefault() {
        DateTime now = DateTimes.nowUtc();
        DataSegment datasource1Segment1 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(5), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 10L);
        DataSegment datasource1Segment2 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(4), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 20L);
        DataSegment datasource2Segment1 = new DataSegment("koala", new Interval((ReadableInstant)now.minusDays(3), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 30L);
        ImmutableList segments = ImmutableList.of((Object)datasource1Segment1, (Object)datasource1Segment2);
        ImmutableMap completedLoadInfoMap = ImmutableMap.of((Object)datasource1Segment1.getId(), (Object)new SegmentLoadInfo(datasource1Segment1), (Object)datasource1Segment2.getId(), (Object)new SegmentLoadInfo(datasource1Segment2), (Object)datasource2Segment1.getId(), (Object)new SegmentLoadInfo(datasource2Segment1));
        ImmutableMap halfLoadedInfoMap = ImmutableMap.of((Object)datasource1Segment1.getId(), (Object)new SegmentLoadInfo(datasource1Segment1));
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        EasyMock.expect((Object)this.inventoryView.getLoadInfoForAllSegments()).andReturn((Object)completedLoadInfoMap).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        Response response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, null, null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)1L, (long)((Map)response.getEntity()).size());
        Assert.assertTrue((boolean)((Map)response.getEntity()).containsKey("wiki"));
        Assert.assertEquals((Object)100.0, ((Map)response.getEntity()).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        EasyMock.reset((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        EasyMock.expect((Object)this.inventoryView.getLoadInfoForAllSegments()).andReturn((Object)halfLoadedInfoMap).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, null, null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)1L, (long)((Map)response.getEntity()).size());
        Assert.assertTrue((boolean)((Map)response.getEntity()).containsKey("wiki"));
        Assert.assertEquals((Object)50.0, ((Map)response.getEntity()).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
    }

    @Test
    public void testGetDatasourceLoadstatusSimple() {
        DateTime now = DateTimes.nowUtc();
        DataSegment datasource1Segment1 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(5), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 10L);
        DataSegment datasource1Segment2 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(4), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 20L);
        DataSegment datasource2Segment1 = new DataSegment("koala", new Interval((ReadableInstant)now.minusDays(3), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 30L);
        ImmutableList segments = ImmutableList.of((Object)datasource1Segment1, (Object)datasource1Segment2);
        ImmutableMap completedLoadInfoMap = ImmutableMap.of((Object)datasource1Segment1.getId(), (Object)new SegmentLoadInfo(datasource1Segment1), (Object)datasource1Segment2.getId(), (Object)new SegmentLoadInfo(datasource1Segment2), (Object)datasource2Segment1.getId(), (Object)new SegmentLoadInfo(datasource2Segment1));
        ImmutableMap halfLoadedInfoMap = ImmutableMap.of((Object)datasource1Segment1.getId(), (Object)new SegmentLoadInfo(datasource1Segment1));
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        EasyMock.expect((Object)this.inventoryView.getLoadInfoForAllSegments()).andReturn((Object)completedLoadInfoMap).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        Response response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, "simple", null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)1L, (long)((Map)response.getEntity()).size());
        Assert.assertTrue((boolean)((Map)response.getEntity()).containsKey("wiki"));
        Assert.assertEquals((Object)0, ((Map)response.getEntity()).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        EasyMock.reset((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        EasyMock.expect((Object)this.inventoryView.getLoadInfoForAllSegments()).andReturn((Object)halfLoadedInfoMap).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
        response = this.dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, "simple", null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)1L, (long)((Map)response.getEntity()).size());
        Assert.assertTrue((boolean)((Map)response.getEntity()).containsKey("wiki"));
        Assert.assertEquals((Object)1, ((Map)response.getEntity()).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager, this.inventoryView});
    }

    @Test
    public void testGetDatasourceLoadstatusFull() {
        DateTime now = DateTimes.nowUtc();
        DataSegment datasource1Segment1 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(4), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 10L);
        DataSegment datasource1Segment2 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(3), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 20L);
        ImmutableList segments = ImmutableList.of((Object)datasource1Segment1, (Object)datasource1Segment2);
        HashMap<String, Object2LongOpenHashMap> underReplicationCountsPerDataSourcePerTier = new HashMap<String, Object2LongOpenHashMap>();
        Object2LongOpenHashMap tier1 = new Object2LongOpenHashMap();
        tier1.put((Object)"wiki", 0L);
        Object2LongOpenHashMap tier2 = new Object2LongOpenHashMap();
        tier2.put((Object)"wiki", 3L);
        underReplicationCountsPerDataSourcePerTier.put("tier1", tier1);
        underReplicationCountsPerDataSourcePerTier.put("tier2", tier2);
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        DruidCoordinator druidCoordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        EasyMock.expect((Object)druidCoordinator.getTierToDatasourceToUnderReplicatedCount((Iterable)EasyMock.anyObject(), EasyMock.eq((boolean)false))).andReturn(underReplicationCountsPerDataSourcePerTier).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, druidCoordinator});
        DataSourcesResource dataSourcesResource = new DataSourcesResource(null, this.segmentsMetadataManager, null, null, null, druidCoordinator, this.auditManager);
        Response response = dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, null, "full", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)2L, (long)((Map)response.getEntity()).size());
        Assert.assertEquals((long)1L, (long)((Map)((Map)response.getEntity()).get("tier1")).size());
        Assert.assertEquals((long)1L, (long)((Map)((Map)response.getEntity()).get("tier2")).size());
        Assert.assertEquals((Object)0L, ((Map)((Map)response.getEntity()).get("tier1")).get("wiki"));
        Assert.assertEquals((Object)3L, ((Map)((Map)response.getEntity()).get("tier2")).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
    }

    @Test
    public void testGetDatasourceLoadstatusFullAndComputeUsingClusterView() {
        DateTime now = DateTimes.nowUtc();
        DataSegment datasource1Segment1 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(5), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 10L);
        DataSegment datasource1Segment2 = new DataSegment("wiki", new Interval((ReadableInstant)now.minusDays(4), (ReadablePeriod)Period.days((int)1)), "", null, null, null, null, Integer.valueOf(9), 20L);
        ImmutableList segments = ImmutableList.of((Object)datasource1Segment1, (Object)datasource1Segment2);
        HashMap<String, Object2LongOpenHashMap> underReplicationCountsPerDataSourcePerTier = new HashMap<String, Object2LongOpenHashMap>();
        Object2LongOpenHashMap tier1 = new Object2LongOpenHashMap();
        tier1.put((Object)"wiki", 0L);
        Object2LongOpenHashMap tier2 = new Object2LongOpenHashMap();
        tier2.put((Object)"wiki", 3L);
        underReplicationCountsPerDataSourcePerTier.put("tier1", tier1);
        underReplicationCountsPerDataSourcePerTier.put("tier2", tier2);
        EasyMock.expect((Object)this.segmentsMetadataManager.forceUpdateDataSourcesSnapshot()).andReturn((Object)DataSourcesSnapshot.fromUsedSegments((Iterable)segments)).once();
        DruidCoordinator druidCoordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        EasyMock.expect((Object)druidCoordinator.getTierToDatasourceToUnderReplicatedCount((Iterable)EasyMock.anyObject(), EasyMock.eq((boolean)true))).andReturn(underReplicationCountsPerDataSourcePerTier).once();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager, druidCoordinator});
        DataSourcesResource dataSourcesResource = new DataSourcesResource(null, this.segmentsMetadataManager, null, null, null, druidCoordinator, this.auditManager);
        Response response = dataSourcesResource.getDatasourceLoadstatus("wiki", Boolean.valueOf(true), null, null, "full", "computeUsingClusterView");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertEquals((long)2L, (long)((Map)response.getEntity()).size());
        Assert.assertEquals((long)1L, (long)((Map)((Map)response.getEntity()).get("tier1")).size());
        Assert.assertEquals((long)1L, (long)((Map)((Map)response.getEntity()).get("tier2")).size());
        Assert.assertEquals((Object)0L, ((Map)((Map)response.getEntity()).get("tier1")).get("wiki"));
        Assert.assertEquals((Object)3L, ((Map)((Map)response.getEntity()).get("tier2")).get("wiki"));
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
    }

    private DruidServerMetadata createRealtimeServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.REALTIME);
    }

    private DruidServerMetadata createHistoricalServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.HISTORICAL);
    }

    private DruidServerMetadata createServerMetadata(String name, ServerType type) {
        return new DruidServerMetadata(name, name, null, 10000L, type, "tier", 1);
    }

    private DataSegment createSegment(Interval interval, String version, int partitionNumber) {
        return new DataSegment("test_ds", interval, version, null, null, null, (ShardSpec)new NumberedShardSpec(partitionNumber, 100), Integer.valueOf(0), 0L);
    }

    private void prepareRequestForAudit() {
        EasyMock.expect((Object)this.request.getHeader("X-Druid-Author")).andReturn((Object)"author").anyTimes();
        EasyMock.expect((Object)this.request.getHeader("X-Druid-Comment")).andReturn((Object)"comment").anyTimes();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"POST").anyTimes();
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)"/request/uri").anyTimes();
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)"query=string").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.request});
    }
}

