/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.common.config.TestConfigManagerConfig;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.TestMetadataStorageConnector;
import org.apache.druid.metadata.TestMetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.http.CoordinatorCompactionConfigsResource;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.skife.jdbi.v2.Handle;

@RunWith(value=MockitoJUnitRunner.class)
public class CoordinatorCompactionConfigsResourceTest {
    private static final double DELTA = 1.0E-9;
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    @Mock
    private HttpServletRequest mockHttpServletRequest;
    private TestCoordinatorConfigManager configManager;
    private CoordinatorCompactionConfigsResource resource;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockHttpServletRequest.getRemoteAddr()).thenReturn((Object)"123");
        TestAuditManager auditManager = new TestAuditManager();
        this.configManager = TestCoordinatorConfigManager.create(auditManager);
        this.resource = new CoordinatorCompactionConfigsResource((CoordinatorConfigManager)this.configManager);
        this.configManager.delegate.start();
    }

    @After
    public void tearDown() {
        this.configManager.delegate.stop();
    }

    @Test
    public void testGetDefaultClusterConfig() {
        Response response = this.resource.getCompactionConfig();
        DruidCompactionConfig defaultConfig = this.verifyAndGetPayload(response, DruidCompactionConfig.class);
        Assert.assertEquals((double)0.1, (double)defaultConfig.getCompactionTaskSlotRatio(), (double)1.0E-9);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)defaultConfig.getMaxCompactionTaskSlots());
        Assert.assertTrue((boolean)defaultConfig.getCompactionConfigs().isEmpty());
        Assert.assertFalse((boolean)defaultConfig.isUseSupervisors());
        Assert.assertEquals((Object)CompactionEngine.NATIVE, (Object)defaultConfig.getEngine());
    }

    @Test
    public void testSetCompactionTaskLimit() {
        this.resource.setCompactionTaskLimit(Double.valueOf(0.1), Integer.valueOf(100), this.mockHttpServletRequest);
        DruidCompactionConfig oldConfig = this.verifyAndGetPayload(this.resource.getCompactionConfig(), DruidCompactionConfig.class);
        Assert.assertEquals((long)100L, (long)oldConfig.getMaxCompactionTaskSlots());
        Assert.assertEquals((double)0.1, (double)oldConfig.getCompactionTaskSlotRatio(), (double)1.0E-9);
        Response response = this.resource.setCompactionTaskLimit(Double.valueOf(0.5), Integer.valueOf(9), this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.OK, response);
        DruidCompactionConfig updatedConfig = this.verifyAndGetPayload(this.resource.getCompactionConfig(), DruidCompactionConfig.class);
        Assert.assertEquals((double)0.5, (double)updatedConfig.getCompactionTaskSlotRatio(), (double)1.0E-9);
        Assert.assertEquals((long)9L, (long)updatedConfig.getMaxCompactionTaskSlots());
        Assert.assertEquals((Object)oldConfig.isUseSupervisors(), (Object)updatedConfig.isUseSupervisors());
        Assert.assertEquals((Object)oldConfig.getCompactionPolicy(), (Object)updatedConfig.getCompactionPolicy());
        Assert.assertEquals((Object)oldConfig.getEngine(), (Object)updatedConfig.getEngine());
        Assert.assertEquals((Object)oldConfig.getCompactionConfigs(), (Object)updatedConfig.getCompactionConfigs());
    }

    @Test
    public void testGetUnknownDatasourceConfigThrowsNotFound() {
        Response response = this.resource.getDatasourceCompactionConfig("wiki");
        this.verifyStatus(Response.Status.NOT_FOUND, response);
    }

    @Test
    public void testAddDatasourceConfig() {
        InlineSchemaDataSourceCompactionConfig newDatasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build();
        Response response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)newDatasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.OK, response);
        DataSourceCompactionConfig fetchedDatasourceConfig = (DataSourceCompactionConfig)this.verifyAndGetPayload(this.resource.getDatasourceCompactionConfig("wiki"), InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)newDatasourceConfig, (Object)fetchedDatasourceConfig);
        DruidCompactionConfig fullCompactionConfig = this.verifyAndGetPayload(this.resource.getCompactionConfig(), DruidCompactionConfig.class);
        Assert.assertEquals((long)1L, (long)fullCompactionConfig.getCompactionConfigs().size());
        Assert.assertEquals((Object)newDatasourceConfig, fullCompactionConfig.getCompactionConfigs().get(0));
    }

    @Test
    public void testAddDatasourceConfigWithMSQEngineIsInvalid() {
        InlineSchemaDataSourceCompactionConfig newDatasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withEngine(CompactionEngine.MSQ).build();
        Response response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)newDatasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.BAD_REQUEST, response);
        Assert.assertTrue((boolean)(response.getEntity() instanceof ErrorResponse));
        Assert.assertEquals((Object)"MSQ engine is supported only with supervisor-based compaction on the Overlord.", (Object)((ErrorResponse)response.getEntity()).getUnderlyingException().getMessage());
    }

    @Test
    public void testUpdateDatasourceConfig() {
        InlineSchemaDataSourceCompactionConfig originalDatasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withInputSegmentSizeBytes(Long.valueOf(500L)).withSkipOffsetFromLatest(Period.hours((int)1)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, Boolean.valueOf(true))).withEngine(CompactionEngine.NATIVE).build();
        Response response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)originalDatasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.OK, response);
        InlineSchemaDataSourceCompactionConfig updatedDatasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withInputSegmentSizeBytes(Long.valueOf(1000L)).withSkipOffsetFromLatest(Period.hours((int)3)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, Boolean.valueOf(false))).withEngine(CompactionEngine.MSQ).build();
        response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)updatedDatasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.BAD_REQUEST, response);
        DataSourceCompactionConfig latestDatasourceConfig = (DataSourceCompactionConfig)this.verifyAndGetPayload(this.resource.getDatasourceCompactionConfig("wiki"), InlineSchemaDataSourceCompactionConfig.class);
        Assert.assertEquals((Object)originalDatasourceConfig, (Object)latestDatasourceConfig);
        DruidCompactionConfig fullCompactionConfig = this.verifyAndGetPayload(this.resource.getCompactionConfig(), DruidCompactionConfig.class);
        Assert.assertEquals((long)1L, (long)fullCompactionConfig.getCompactionConfigs().size());
        Assert.assertEquals((Object)originalDatasourceConfig, fullCompactionConfig.getCompactionConfigs().get(0));
    }

    @Test
    public void testDeleteDatasourceConfig() {
        InlineSchemaDataSourceCompactionConfig datasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build();
        Response response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)datasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.OK, response);
        response = this.resource.deleteCompactionConfig("wiki", this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.OK, response);
        response = this.resource.getDatasourceCompactionConfig("wiki");
        this.verifyStatus(Response.Status.NOT_FOUND, response);
    }

    @Test
    public void testDeleteUnknownDatasourceConfigThrowsNotFound() {
        Response response = this.resource.deleteCompactionConfig("wiki", this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.NOT_FOUND, response);
    }

    @Test
    public void testUpdateIsRetriedIfFailureIsRetryable() {
        this.configManager.configUpdateResult = ConfigManager.SetResult.retryableFailure((Exception)new Exception("retryable"));
        this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.mockHttpServletRequest);
        Assert.assertEquals((long)5L, (long)this.configManager.numUpdateAttempts);
    }

    @Test
    public void testUpdateIsNotRetriedIfFailureIsNotRetryable() {
        this.configManager.configUpdateResult = ConfigManager.SetResult.failure((Exception)new Exception("not retryable"));
        this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), this.mockHttpServletRequest);
        Assert.assertEquals((long)1L, (long)this.configManager.numUpdateAttempts);
    }

    @Test
    public void testGetDatasourceConfigHistory() {
        InlineSchemaDataSourceCompactionConfig.Builder builder = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki");
        InlineSchemaDataSourceCompactionConfig configV1 = builder.build();
        this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)configV1, this.mockHttpServletRequest);
        InlineSchemaDataSourceCompactionConfig configV2 = builder.withEngine(CompactionEngine.NATIVE).build();
        this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)configV2, this.mockHttpServletRequest);
        InlineSchemaDataSourceCompactionConfig configV3 = builder.withEngine(CompactionEngine.NATIVE).withSkipOffsetFromLatest(Period.hours((int)1)).build();
        this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)configV3, this.mockHttpServletRequest);
        Response response = this.resource.getCompactionConfigHistory("wiki", null, null);
        this.verifyStatus(Response.Status.OK, response);
        List history = (List)response.getEntity();
        Assert.assertEquals((long)3L, (long)history.size());
        Assert.assertEquals((Object)configV1, (Object)((DataSourceCompactionConfigAuditEntry)history.get(0)).getCompactionConfig());
        Assert.assertEquals((Object)configV2, (Object)((DataSourceCompactionConfigAuditEntry)history.get(1)).getCompactionConfig());
        Assert.assertEquals((Object)configV3, (Object)((DataSourceCompactionConfigAuditEntry)history.get(2)).getCompactionConfig());
    }

    @Test
    public void testGetHistoryOfUnknownDatasourceReturnsEmpty() {
        Response response = this.resource.getCompactionConfigHistory("wiki", null, null);
        this.verifyStatus(Response.Status.OK, response);
        Assert.assertTrue((boolean)((List)response.getEntity()).isEmpty());
    }

    @Test
    public void testAddInvalidDatasourceConfigThrowsBadRequest() {
        InlineSchemaDataSourceCompactionConfig datasourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTaskContext(Collections.singletonMap("maxNumTasks", 1)).withEngine(CompactionEngine.MSQ).build();
        Response response = this.resource.addOrUpdateDatasourceCompactionConfig((DataSourceCompactionConfig)datasourceConfig, this.mockHttpServletRequest);
        this.verifyStatus(Response.Status.BAD_REQUEST, response);
        Assert.assertTrue((boolean)(response.getEntity() instanceof ErrorResponse));
        Assert.assertEquals((Object)"MSQ engine is supported only with supervisor-based compaction on the Overlord.", (Object)((ErrorResponse)response.getEntity()).getUnderlyingException().getMessage());
    }

    private <T> T verifyAndGetPayload(Response response, Class<T> type) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)type.isInstance(response.getEntity()));
        return (T)response.getEntity();
    }

    private void verifyStatus(Response.Status expectedStatus, Response response) {
        Assert.assertEquals((long)expectedStatus.getStatusCode(), (long)response.getStatus());
    }

    private static class TestAuditManager
    implements AuditManager {
        private final List<AuditEntry> audits = new ArrayList<AuditEntry>();

        private TestAuditManager() {
        }

        public void doAudit(AuditEntry event, Handle handle) {
        }

        public void doAudit(AuditEntry event) {
            String json;
            try {
                json = OBJECT_MAPPER.writeValueAsString(event.getPayload().raw());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            AuditEntry eventWithSerializedPayload = AuditEntry.builder().key(event.getKey()).type(event.getType()).auditInfo(event.getAuditInfo()).auditTime(event.getAuditTime()).request(event.getRequest()).serializedPayload(json).build();
            this.audits.add(eventWithSerializedPayload);
        }

        public List<AuditEntry> fetchAuditHistory(String key, String type, Interval interval) {
            return this.audits;
        }

        public List<AuditEntry> fetchAuditHistory(String type, int limit) {
            return this.audits;
        }

        public List<AuditEntry> fetchAuditHistory(String type, Interval interval) {
            return this.audits;
        }

        public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) {
            return this.audits;
        }

        public int removeAuditLogsOlderThan(long timestamp) {
            return 0;
        }
    }

    private static class TestCoordinatorConfigManager
    extends CoordinatorConfigManager {
        private final ConfigManager delegate;
        private int numUpdateAttempts;
        private ConfigManager.SetResult configUpdateResult;

        static TestCoordinatorConfigManager create(AuditManager auditManager) {
            TestMetadataStorageTablesConfig tablesConfig = new TestMetadataStorageTablesConfig(){

                public String getConfigTable() {
                    return "druid_config";
                }
            };
            TestDBConnector dbConnector = new TestDBConnector();
            ConfigManager configManager = new ConfigManager((MetadataStorageConnector)dbConnector, Suppliers.ofInstance((Object)tablesConfig), Suppliers.ofInstance((Object)new TestConfigManagerConfig()));
            return new TestCoordinatorConfigManager(new JacksonConfigManager(configManager, OBJECT_MAPPER, auditManager), configManager, auditManager, dbConnector, (MetadataStorageTablesConfig)tablesConfig);
        }

        TestCoordinatorConfigManager(JacksonConfigManager jackson, ConfigManager configManager, AuditManager auditManager, TestDBConnector dbConnector, MetadataStorageTablesConfig tablesConfig) {
            super(jackson, (MetadataStorageConnector)dbConnector, tablesConfig, auditManager);
            this.delegate = configManager;
        }

        public ConfigManager.SetResult getAndUpdateCompactionConfig(UnaryOperator<DruidCompactionConfig> operator, AuditInfo auditInfo) {
            ++this.numUpdateAttempts;
            if (this.configUpdateResult == null) {
                return super.getAndUpdateCompactionConfig(operator, auditInfo);
            }
            return this.configUpdateResult;
        }
    }

    private static class TestDBConnector
    extends TestMetadataStorageConnector {
        private final Map<List<String>, byte[]> values = new HashMap<List<String>, byte[]>();

        private TestDBConnector() {
        }

        public Void insertOrUpdate(String tableName, String keyColumn, String valueColumn, String key, byte[] value) {
            this.values.put(Arrays.asList(tableName, keyColumn, valueColumn, key), value);
            return null;
        }

        @Nullable
        public byte[] lookup(String tableName, String keyColumn, String valueColumn, String key) {
            return this.values.get(Arrays.asList(tableName, keyColumn, valueColumn, key));
        }

        public boolean compareAndSwap(List<MetadataCASUpdate> updates) {
            for (MetadataCASUpdate update : updates) {
                List<String> key = Arrays.asList(update.getTableName(), update.getKeyColumn(), update.getValueColumn(), update.getKey());
                byte[] currentValue = this.values.get(key);
                if (currentValue == null || Arrays.equals(currentValue, update.getOldValue())) {
                    this.values.put(key, update.getNewValue());
                    continue;
                }
                return false;
            }
            return true;
        }
    }
}

