/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class RoundRobinAssignmentTest
extends CoordinatorSimulationBaseTest {
    private static final long SIZE_1TB = 1000000L;
    private List<DruidServer> historicals;

    @Override
    public void setUp() {
        this.historicals = new ArrayList<DruidServer>();
        for (int i = 0; i < 10; ++i) {
            this.historicals.add(RoundRobinAssignmentTest.createHistorical(i, "tier_t1", 1000000L));
        }
    }

    @Test
    public void testSegmentsAreAssignedUniformly() {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(0).withMaxSegmentsInNodeLoadingQueue(0).withReplicationThrottleLimit(20000).withUseRoundRobinSegmentAssignment(true).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withDynamicConfig(config).withBalancer("random").withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withServers(this.historicals).withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X100D).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", 2000L);
        for (DruidServer historical : this.historicals) {
            Assert.assertEquals((long)200L, (long)historical.getTotalSegments());
        }
    }

    @Test
    public void testMultipleDatasourceSegmentsAreAssignedUniformly() {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(CoordinatorSimulationBaseTest.Segments.WIKI_10X100D);
        segments.addAll(CoordinatorSimulationBaseTest.Segments.KOALA_100X100D);
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(0).withMaxSegmentsInNodeLoadingQueue(0).withReplicationThrottleLimit(20000).withUseRoundRobinSegmentAssignment(true).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withDynamicConfig(config).withBalancer("random").withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 3).forever()).withRules("koala", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withServers(this.historicals).withSegments(segments).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", RoundRobinAssignmentTest.filterByDatasource("koala"), 10000L);
        this.verifyValue("segment/assigned/count", RoundRobinAssignmentTest.filterByDatasource("wiki"), 3000L);
        for (DruidServer historical : this.historicals) {
            Assert.assertEquals((long)1300L, (long)historical.getTotalSegments());
        }
    }
}

