/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.server.coordinator.loading.ReplicationThrottler;
import org.junit.Assert;
import org.junit.Test;

public class ReplicationThrottlerTest {
    private static final String TIER_1 = "t1";
    private static final String TIER_2 = "t2";

    @Test
    public void testTierDoesNotViolateThrottleLimit() {
        int replicationThrottleLimit = 10;
        ReplicationThrottler throttler = new ReplicationThrottler((Map)ImmutableMap.of(), 10);
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)throttler.isReplicationThrottledForTier(TIER_1));
            throttler.incrementAssignedReplicas(TIER_1);
            Assert.assertFalse((boolean)throttler.isReplicationThrottledForTier(TIER_2));
            throttler.incrementAssignedReplicas(TIER_2);
        }
    }

    @Test
    public void testTierWithLoadingReplicasDoesNotViolateThrottleLimit() {
        int replicationThrottleLimit = 10;
        ReplicationThrottler throttler = new ReplicationThrottler((Map)ImmutableMap.of((Object)TIER_1, (Object)10, (Object)TIER_2, (Object)7), 10);
        Assert.assertTrue((boolean)throttler.isReplicationThrottledForTier(TIER_1));
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)throttler.isReplicationThrottledForTier(TIER_2));
            throttler.incrementAssignedReplicas(TIER_2);
        }
        Assert.assertTrue((boolean)throttler.isReplicationThrottledForTier(TIER_2));
    }
}

