/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CostBalancerStrategyTest {
    private static final double DELTA = 1.0E-6;
    private ExecutorService balancerExecutor;
    private CostBalancerStrategy strategy;
    private int uniqueServerId;

    @Before
    public void setup() {
        this.balancerExecutor = Execs.singleThreaded((String)"test-balance-exec-%d");
        this.strategy = new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)this.balancerExecutor));
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("test-service", "host");
        EmittingLogger.registerEmitter((ServiceEmitter)serviceEmitter);
    }

    @After
    public void tearDown() {
        if (this.balancerExecutor != null) {
            this.balancerExecutor.shutdownNow();
        }
    }

    @Test
    public void testIntervalCostAdditivity() {
        Assert.assertEquals((double)this.intervalCost(1.0, 1.0, 3.0), (double)(this.intervalCost(1.0, 1.0, 2.0) + this.intervalCost(1.0, 2.0, 3.0)), (double)1.0E-6);
        Assert.assertEquals((double)this.intervalCost(2.0, 1.0, 3.0), (double)(this.intervalCost(2.0, 1.0, 2.0) + this.intervalCost(2.0, 2.0, 3.0)), (double)1.0E-6);
        Assert.assertEquals((double)this.intervalCost(3.0, 1.0, 2.0), (double)(this.intervalCost(1.0, 0.0, 1.0) + this.intervalCost(1.0, 1.0, 2.0) + this.intervalCost(1.0, 1.0, 2.0)), (double)1.0E-6);
    }

    private double intervalCost(double x1, double y0, double y1) {
        return CostBalancerStrategy.intervalCost((double)x1, (double)y0, (double)y1);
    }

    @Test
    public void testIntervalCost() {
        Assert.assertEquals((double)0.3995764, (double)this.intervalCost(1.0, 1.0, 2.0), (double)1.0E-6);
        Assert.assertEquals((double)0.3995764, (double)this.intervalCost(1.0, -1.0, 0.0), (double)1.0E-6);
        Assert.assertEquals((double)0.7357589, (double)this.intervalCost(1.0, 0.0, 1.0), (double)1.0E-6);
        Assert.assertEquals((double)2.270671, (double)this.intervalCost(2.0, 0.0, 2.0), (double)1.0E-6);
        Assert.assertEquals((double)1.681908, (double)this.intervalCost(2.0, 1.0, 3.0), (double)1.0E-6);
        Assert.assertEquals((double)1.135335, (double)this.intervalCost(2.0, 1.0, 2.0), (double)1.0E-6);
        Assert.assertEquals((double)1.135335, (double)this.intervalCost(2.0, 0.0, 1.0), (double)1.0E-6);
        Assert.assertEquals((double)1.534912, (double)this.intervalCost(3.0, 1.0, 2.0), (double)1.0E-6);
    }

    @Test
    public void testJointSegmentsCost() {
        long noGap = 0L;
        long oneDayGap = TimeUnit.DAYS.toMillis(1L);
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.HOUR, 0L, 1.980884);
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.HOUR, oneDayGap, 1.00007);
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.DAY, 0L, 35.110275);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.DAY, 0L, 926.232308);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.DAY, oneDayGap, 599.434267);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.DAY, 7L * oneDayGap, 9.36616);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.MONTH, 0L, 2125.10084);
        this.verifyJointSegmentsCost(GranularityType.MONTH, GranularityType.MONTH, 0L, 98247.57647);
        this.verifyJointSegmentsCost(GranularityType.MONTH, GranularityType.MONTH, 7L * oneDayGap, 79719.068161);
        this.verifyJointSegmentsCost(GranularityType.MONTH, GranularityType.YEAR, 0L, 100645.313535);
        this.verifyJointSegmentsCost(GranularityType.YEAR, GranularityType.YEAR, 0L, 1208453.347454);
        this.verifyJointSegmentsCost(GranularityType.YEAR, GranularityType.YEAR, 7L * oneDayGap, 1189943.571325);
    }

    @Test
    public void testJointSegmentsCostSymmetry() {
        DataSegment segmentA = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2010-01-01").eachOfSizeInMb(100L).get(0);
        DataSegment segmentB = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.MONTH).startingAt("2010-01-01").eachOfSizeInMb(100L).get(0);
        Assert.assertEquals((double)CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segmentA, (DataSegment)segmentB), (double)CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segmentB, (DataSegment)segmentA), (double)1.0E-6);
    }

    @Test
    public void testJointSegmentsCostMultipleDatasources() {
        DataSegment wikiSegment = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2010-01-01").eachOfSizeInMb(100L).get(0);
        DataSegment koalaSegment = CreateDataSegments.ofDatasource("koala").forIntervals(1, Granularities.DAY).startingAt("2010-01-01").eachOfSizeInMb(100L).get(0);
        double crossDatasourceCost = CostBalancerStrategy.computeJointSegmentsCost((DataSegment)koalaSegment, (DataSegment)wikiSegment);
        Assert.assertEquals((double)(2.0 * crossDatasourceCost), (double)CostBalancerStrategy.computeJointSegmentsCost((DataSegment)wikiSegment, (DataSegment)wikiSegment), (double)1.0E-6);
        Assert.assertEquals((double)(2.0 * crossDatasourceCost), (double)CostBalancerStrategy.computeJointSegmentsCost((DataSegment)koalaSegment, (DataSegment)koalaSegment), (double)1.0E-6);
    }

    @Test
    public void testJointSegmentsCostWith45DayGap() {
        long gap1Day = TimeUnit.DAYS.toMillis(1L);
        long gap45Days = 45L * gap1Day;
        long gap1Hour = TimeUnit.HOURS.toMillis(1L);
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.HOUR, gap1Hour + gap45Days, 0.0);
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.DAY, gap1Hour + gap45Days, 0.0);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.DAY, gap1Day + gap45Days, 0.0);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.MONTH, gap1Day + gap45Days, 0.0);
        this.verifyJointSegmentsCost(GranularityType.MONTH, GranularityType.MONTH, 30L * gap1Day + gap45Days, 0.0);
        this.verifyJointSegmentsCost(GranularityType.YEAR, GranularityType.YEAR, 365L * gap1Day + gap45Days, 0.0);
    }

    @Test
    public void testJointSegmentsCostAllGranularity() {
        this.verifyJointSegmentsCost(GranularityType.HOUR, GranularityType.ALL, 0L, 138.516732);
        this.verifyJointSegmentsCost(GranularityType.DAY, GranularityType.ALL, 0L, 3323.962523);
        this.verifyJointSegmentsCost(GranularityType.MONTH, GranularityType.ALL, 0L, 103043.057744);
        this.verifyJointSegmentsCost(GranularityType.YEAR, GranularityType.ALL, 0L, 1213248.808913);
        DataSegment segmentAllGranularity = CreateDataSegments.ofDatasource("ds").forIntervals(1, Granularities.ALL).eachOfSizeInMb(100L).get(0);
        double cost = CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segmentAllGranularity, (DataSegment)segmentAllGranularity);
        Assert.assertTrue((cost >= 3.548E14 && cost <= 3.549E14 ? 1 : 0) != 0);
    }

    @Test
    public void testComputePlacementCost() {
        List<DataSegment> daySegments = CreateDataSegments.ofDatasource("wiki").forIntervals(10, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(100L);
        List<DataSegment> monthSegments = CreateDataSegments.ofDatasource("wiki").forIntervals(10, Granularities.MONTH).startingAt("2022-03-01").withNumPartitions(10).eachOfSizeInMb(100L);
        List<DataSegment> yearSegments = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.YEAR).startingAt("2023-01-01").withNumPartitions(30).eachOfSizeInMb(100L);
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(daySegments);
        segments.addAll(monthSegments);
        segments.addAll(yearSegments);
        List historicals = IntStream.range(0, 3).mapToObj(i -> this.createHistorical()).collect(Collectors.toList());
        Random random = new Random(100L);
        segments.forEach(segment -> ((DruidServer)historicals.get(random.nextInt(historicals.size()))).addDataSegment(segment));
        List serverHolders = historicals.stream().map(server -> new ServerHolder(server.toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon())).collect(Collectors.toList());
        ServerHolder serverA = (ServerHolder)serverHolders.get(0);
        ServerHolder serverB = (ServerHolder)serverHolders.get(1);
        ServerHolder serverC = (ServerHolder)serverHolders.get(2);
        DataSegment daySegment = daySegments.get(0);
        this.verifyPlacementCost(daySegment, serverA, 5191.500804);
        this.verifyPlacementCost(daySegment, serverB, 8691.39208);
        this.verifyPlacementCost(daySegment, serverC, 6418.467818);
        DataSegment monthSegment = monthSegments.get(0);
        this.verifyPlacementCost(monthSegment, serverA, 301935.940609);
        this.verifyPlacementCost(monthSegment, serverB, 301935.940606);
        this.verifyPlacementCost(monthSegment, serverC, 304333.677669);
        DataSegment yearSegment = yearSegments.get(0);
        this.verifyPlacementCost(yearSegment, serverA, 8468764.380437);
        this.verifyPlacementCost(yearSegment, serverB, 1.2098919896931E7);
        this.verifyPlacementCost(yearSegment, serverC, 1.4501440169452E7);
        DataSegment allGranularitySegment = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.ALL).eachOfSizeInMb(100L).get(0);
        this.verifyPlacementCost(allGranularitySegment, serverA, 1.1534173737329768E7);
        this.verifyPlacementCost(allGranularitySegment, serverB, 1.6340633534241956E7);
        this.verifyPlacementCost(allGranularitySegment, serverC, 1.902640052158297E7);
    }

    @Test
    public void testGetStats() {
        ServerHolder serverA = new ServerHolder(this.createHistorical().toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
        ServerHolder serverB = new ServerHolder(this.createHistorical().toImmutableDruidServer(), (LoadQueuePeon)new TestLoadQueuePeon());
        DataSegment segment = CreateDataSegments.ofDatasource("wiki").eachOfSizeInMb(100L).get(0);
        this.strategy.findServersToLoadSegment(segment, Arrays.asList(serverA, serverB));
        CoordinatorRunStats computeStats = this.strategy.getStats();
        Assert.assertEquals((long)1L, (long)computeStats.get(Stats.Balancer.COMPUTATION_COUNT));
        long computeTime = computeStats.get(Stats.Balancer.COMPUTATION_TIME);
        Assert.assertTrue((computeTime >= 0L && computeTime <= 100L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)computeStats.hasStat(Stats.Balancer.COMPUTATION_ERRORS));
    }

    @Test
    public void testFindServerAfterExecutorShutdownThrowsException() {
        DataSegment segment = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2012-10-24").eachOfSizeInMb(100L).get(0);
        TestLoadQueuePeon peon = new TestLoadQueuePeon();
        ServerHolder serverA = new ServerHolder(this.createHistorical().toImmutableDruidServer(), (LoadQueuePeon)peon);
        ServerHolder serverB = new ServerHolder(this.createHistorical().toImmutableDruidServer(), (LoadQueuePeon)peon);
        this.balancerExecutor.shutdownNow();
        Assert.assertThrows(RejectedExecutionException.class, () -> this.strategy.findServersToLoadSegment(segment, Arrays.asList(serverA, serverB)));
    }

    private void verifyPlacementCost(DataSegment segment, ServerHolder server, double expectedCost) {
        double observedCost = this.strategy.computePlacementCost(segment, server);
        Assert.assertEquals((double)expectedCost, (double)observedCost, (double)1.0E-6);
        double totalJointSegmentCost = 0.0;
        for (DataSegment segmentOnServer : server.getServer().iterateAllSegments()) {
            totalJointSegmentCost += CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segment, (DataSegment)segmentOnServer);
        }
        if (server.isServingSegment(segment)) {
            totalJointSegmentCost -= CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segment, (DataSegment)segment);
        }
        Assert.assertEquals((double)totalJointSegmentCost, (double)observedCost, (double)1.0E-6);
    }

    private void verifyJointSegmentsCost(GranularityType granularityX, GranularityType granularityY, long startGapMillis, double expectedCost) {
        DataSegment segmentX = CreateDataSegments.ofDatasource("wiki").forIntervals(1, granularityX.getDefaultGranularity()).startingAt("2012-10-24").eachOfSizeInMb(100L).get(0);
        DateTime startTimeY = segmentX.getInterval().getStart().plus(startGapMillis);
        DataSegment segmentY = CreateDataSegments.ofDatasource("wiki").forIntervals(1, granularityY.getDefaultGranularity()).startingAt(startTimeY).eachOfSizeInMb(100L).get(0);
        double observedCost = CostBalancerStrategy.computeJointSegmentsCost((DataSegment)segmentX, (DataSegment)segmentY);
        Assert.assertEquals((double)expectedCost, (double)observedCost, (double)1.0E-6);
    }

    private DruidServer createHistorical() {
        String serverName = "hist_" + this.uniqueServerId++;
        return new DruidServer(serverName, serverName, null, 0x280000000L, ServerType.HISTORICAL, "hot", 1);
    }
}

