/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.discovery.LatchableServiceAnnouncer;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.segment.cache.NoopSegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CloneStatusManager;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.MetadataManager;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.CoordinatorPeriodConfig;
import org.apache.druid.server.coordinator.config.CoordinatorRunConfig;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroup;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.duty.DutyGroupStatus;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.apache.druid.server.coordinator.loading.LoadPeonCallback;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.server.http.CoordinatorDynamicConfigSyncer;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorTest {
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private DruidCoordinator coordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private DataSourcesSnapshot dataSourcesSnapshot;
    private ServerInventoryView serverInventoryView;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private LoadQueueTaskMaster loadQueueTaskMaster;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private DruidNode druidNode;
    private OverlordClient overlordClient;
    private CompactionStatusTracker statusTracker;
    private LatchableServiceEmitter serviceEmitter;

    @Before
    public void setUp() throws Exception {
        this.serverInventoryView = (ServerInventoryView)EasyMock.createMock(ServerInventoryView.class);
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createNiceMock(SegmentsMetadataManager.class);
        this.dataSourcesSnapshot = (DataSourcesSnapshot)EasyMock.createNiceMock(DataSourcesSnapshot.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        this.loadQueueTaskMaster = (LoadQueueTaskMaster)EasyMock.createMock(LoadQueueTaskMaster.class);
        this.overlordClient = (OverlordClient)EasyMock.createMock(OverlordClient.class);
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<DruidCompactionConfig>(DruidCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        this.statusTracker = new CompactionStatusTracker((ObjectMapper)objectMapper);
        this.druidCoordinatorConfig = new DruidCoordinatorConfig(new CoordinatorRunConfig(new Duration(1L), new Duration(100L)), new CoordinatorPeriodConfig(null, null), CoordinatorKillConfigs.DEFAULT, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), null);
        this.druidNode = new DruidNode("hey", "what", false, Integer.valueOf(1234), null, true, false);
        this.scheduledExecutorFactory = ScheduledExecutors::fixed;
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.serviceEmitter = new LatchableServiceEmitter();
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(configManager), this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, this.overlordClient, this.loadQueueTaskMaster, new SegmentLoadQueueManager(this.serverInventoryView, this.loadQueueTaskMaster), (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER), (CoordinatorDynamicConfigSyncer)EasyMock.niceMock(CoordinatorDynamicConfigSyncer.class), (CloneStatusManager)EasyMock.niceMock(CloneStatusManager.class));
    }

    private MetadataManager createMetadataManager(JacksonConfigManager configManager) {
        return new MetadataManager(null, new CoordinatorConfigManager(configManager, null, null, null), this.segmentsMetadataManager, null, this.metadataRuleManager, null, null, (SegmentMetadataCache)NoopSegmentMetadataCache.instance());
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun() throws Exception {
        String dataSource = "dataSource1";
        String tier = "hot";
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)tier, (Object)2), null);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)foreverLoadRule)).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] dataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSources[0].addSegment(dataSegment);
        this.setupSegmentsMetadataMock(dataSources[0]);
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        DruidServer druidServer = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, tier, 0);
        LoadQueuePeon loadQueuePeon = this.createImmediateLoadPeonFor(druidServer);
        this.setupPeons(Collections.singletonMap("server1", loadQueuePeon));
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)druidServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        Assert.assertNull((Object)this.coordinator.getReplicationFactor(dataSegment.getId()));
        Assert.assertNull((Object)this.coordinator.getBroadcastSegments());
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        this.serviceEmitter.coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)dataSource, (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Object2IntMap numsUnavailableUsedSegmentsPerDataSource = this.coordinator.getDatasourceToUnavailableSegmentCount();
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.size());
        Assert.assertEquals((long)0L, (long)numsUnavailableUsedSegmentsPerDataSource.getInt((Object)dataSource));
        Assert.assertEquals((long)0L, (long)this.coordinator.getBroadcastSegments().size());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSource = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource.get((Object)dataSource));
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.getLong((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSourceUsingClusterView = (Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSourceUsingClusterView.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView.get((Object)dataSource));
        Assert.assertEquals((long)0L, (long)underRepliicationCountsPerDataSourceUsingClusterView.getLong((Object)dataSource));
        Assert.assertEquals((Object)2, (Object)this.coordinator.getReplicationFactor(dataSegment.getId()));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testCoordinatorTieredRun() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        IntervalLoadRule hotTier = new IntervalLoadRule(Intervals.of((String)"2018-01-01/P1M"), (Map)ImmutableMap.of((Object)"hot", (Object)1), null);
        ForeverLoadRule coldTier = new ForeverLoadRule((Map)ImmutableMap.of((Object)"cold", (Object)1), null);
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        Set<DataSegment> dataSegments = Set.of(new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        LoadQueuePeon loadQueuePeonHot = this.createImmediateLoadPeonFor(hotServer);
        LoadQueuePeon loadQueuePeonCold = this.createImmediateLoadPeonFor(coldServer);
        this.setupPeons((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)loadQueuePeonHot, (Object)"cold", (Object)loadQueuePeonCold));
        loadQueuePeonHot.start();
        loadQueuePeonCold.start();
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource("dataSource", Collections.emptyMap())};
        dataSegments.forEach(arg_0 -> ((DruidDataSource)druidDataSources[0]).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSources[0]);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)hotTier, (Object)coldTier)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        this.serviceEmitter.coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        dataSegments.forEach(dataSegment -> Assert.assertEquals((Object)1, (Object)this.coordinator.getReplicationFactor(dataSegment.getId())));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testComputeUnderReplicationCountsPerDataSourcePerTierForSegmentsWithBroadcastRule() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        String tierName1 = "tier1";
        String tierName2 = "tier2";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        DruidServer brokerServer1 = new DruidServer("broker1", "broker1", null, 5L, ServerType.BROKER, "tier1", 0);
        DruidServer brokerServer2 = new DruidServer("broker2", "broker2", null, 5L, ServerType.BROKER, "tier2", 0);
        DruidServer peonServer = new DruidServer("peon", "peon", null, 5L, ServerType.INDEXER_EXECUTOR, "tier2", 0);
        Set<DataSegment> dataSegments = Set.of(new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        LoadQueuePeon loadQueuePeonHot = this.createImmediateLoadPeonFor(hotServer);
        LoadQueuePeon loadQueuePeonCold = this.createImmediateLoadPeonFor(coldServer);
        LoadQueuePeon loadQueuePeonBroker1 = this.createImmediateLoadPeonFor(brokerServer1);
        LoadQueuePeon loadQueuePeonBroker2 = this.createImmediateLoadPeonFor(brokerServer2);
        LoadQueuePeon loadQueuePeonPoenServer = this.createImmediateLoadPeonFor(peonServer);
        this.setupPeons((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)loadQueuePeonHot, (Object)"cold", (Object)loadQueuePeonCold, (Object)"broker1", (Object)loadQueuePeonBroker1, (Object)"broker2", (Object)loadQueuePeonBroker2, (Object)"peon", (Object)loadQueuePeonPoenServer));
        loadQueuePeonHot.start();
        loadQueuePeonCold.start();
        loadQueuePeonBroker1.start();
        loadQueuePeonBroker2.start();
        loadQueuePeonPoenServer.start();
        DruidDataSource druidDataSource = new DruidDataSource("dataSource", Collections.emptyMap());
        dataSegments.forEach(arg_0 -> ((DruidDataSource)druidDataSource).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSource);
        ForeverBroadcastDistributionRule broadcastDistributionRule = new ForeverBroadcastDistributionRule();
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)broadcastDistributionRule)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer, (Object)brokerServer1, (Object)brokerServer2, (Object)peonServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        this.serviceEmitter.coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getDatasourceToLoadStatus());
        Assert.assertEquals(dataSegments, (Object)this.coordinator.getBroadcastSegments());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier2")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.getTierToDatasourceToUnderReplicatedCount(true);
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier2")).getLong((Object)"dataSource"));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test
    public void testCompactSegmentsDutyWhenCustomDutyGroupEmpty() {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        CoordinatorCustomDutyGroups emptyCustomDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of());
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, this.overlordClient, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, emptyCustomDutyGroups, (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER), (CoordinatorDynamicConfigSyncer)EasyMock.niceMock(CoordinatorDynamicConfigSyncer.class), (CloneStatusManager)EasyMock.niceMock(CloneStatusManager.class));
        this.coordinator.start();
        List duties = this.coordinator.getStatusOfDuties();
        Assert.assertEquals((long)3L, (long)duties.size());
        Assert.assertEquals((Object)"HistoricalManagementDuties", (Object)((DutyGroupStatus)duties.get(0)).getName());
        Assert.assertEquals((Object)"IndexingServiceDuties", (Object)((DutyGroupStatus)duties.get(1)).getName());
        Assert.assertEquals((Object)"MetadataStoreManagementDuties", (Object)((DutyGroupStatus)duties.get(2)).getName());
        String compactDutyName = CompactSegments.class.getName();
        Assert.assertTrue((boolean)((DutyGroupStatus)duties.get(1)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(0)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(2)).getDutyNames().contains(compactDutyName));
        this.coordinator.stop();
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupDoesNotContainsCompactSegments() {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        CoordinatorCustomDutyGroup group = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), null)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, this.overlordClient, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, customDutyGroups, (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER), (CoordinatorDynamicConfigSyncer)EasyMock.niceMock(CoordinatorDynamicConfigSyncer.class), (CloneStatusManager)EasyMock.niceMock(CloneStatusManager.class));
        this.coordinator.start();
        List duties = this.coordinator.getStatusOfDuties();
        Assert.assertEquals((long)4L, (long)duties.size());
        Assert.assertEquals((Object)"HistoricalManagementDuties", (Object)((DutyGroupStatus)duties.get(0)).getName());
        Assert.assertEquals((Object)"IndexingServiceDuties", (Object)((DutyGroupStatus)duties.get(1)).getName());
        Assert.assertEquals((Object)"MetadataStoreManagementDuties", (Object)((DutyGroupStatus)duties.get(2)).getName());
        Assert.assertEquals((Object)"group1", (Object)((DutyGroupStatus)duties.get(3)).getName());
        String compactDutyName = CompactSegments.class.getName();
        Assert.assertTrue((boolean)((DutyGroupStatus)duties.get(1)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(0)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(2)).getDutyNames().contains(compactDutyName));
        this.coordinator.stop();
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupContainsCompactSegments() {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        CoordinatorCustomDutyGroup compactSegmentCustomGroup = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new CompactSegments(this.statusTracker, null)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)compactSegmentCustomGroup));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(null), this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, this.overlordClient, this.loadQueueTaskMaster, null, (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, customDutyGroups, (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER), (CoordinatorDynamicConfigSyncer)EasyMock.niceMock(CoordinatorDynamicConfigSyncer.class), (CloneStatusManager)EasyMock.niceMock(CloneStatusManager.class));
        this.coordinator.start();
        List duties = this.coordinator.getStatusOfDuties();
        Assert.assertEquals((long)4L, (long)duties.size());
        Assert.assertEquals((Object)"HistoricalManagementDuties", (Object)((DutyGroupStatus)duties.get(0)).getName());
        Assert.assertEquals((Object)"IndexingServiceDuties", (Object)((DutyGroupStatus)duties.get(1)).getName());
        Assert.assertEquals((Object)"MetadataStoreManagementDuties", (Object)((DutyGroupStatus)duties.get(2)).getName());
        Assert.assertEquals((Object)"group1", (Object)((DutyGroupStatus)duties.get(3)).getName());
        String compactDutyName = CompactSegments.class.getName();
        Assert.assertTrue((boolean)((DutyGroupStatus)duties.get(3)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(0)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(1)).getDutyNames().contains(compactDutyName));
        Assert.assertFalse((boolean)((DutyGroupStatus)duties.get(2)).getDutyNames().contains(compactDutyName));
        this.coordinator.stop();
    }

    @Test(timeout=3000L)
    public void testCoordinatorCustomDutyGroupsRunAsExpected() throws Exception {
        this.setupPeons(Collections.emptyMap());
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<DruidCompactionConfig>(DruidCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        DataSegment dataSegment = new DataSegment("dataSource1", Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        DataSourcesSnapshot dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(Collections.singleton(dataSegment));
        EasyMock.expect((Object)this.segmentsMetadataManager.getRecentDataSourcesSnapshot()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.loadQueueTaskMaster, this.segmentsMetadataManager});
        CountDownLatch latch1 = new CountDownLatch(1);
        CoordinatorCustomDuty duty1 = params -> {
            latch1.countDown();
            return params;
        };
        CoordinatorCustomDutyGroup group1 = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty1));
        CountDownLatch latch2 = new CountDownLatch(1);
        CoordinatorCustomDuty duty2 = params -> {
            latch2.countDown();
            return params;
        };
        CoordinatorCustomDutyGroup group2 = new CoordinatorCustomDutyGroup("group2", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty2));
        CoordinatorCustomDutyGroups groups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group1, (Object)group2));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, this.createMetadataManager(configManager), this.serverInventoryView, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, this.overlordClient, this.loadQueueTaskMaster, new SegmentLoadQueueManager(this.serverInventoryView, this.loadQueueTaskMaster), (ServiceAnnouncer)new LatchableServiceAnnouncer(this.leaderAnnouncerLatch, this.leaderUnannouncerLatch), this.druidNode, groups, (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER), (CoordinatorDynamicConfigSyncer)EasyMock.niceMock(CoordinatorDynamicConfigSyncer.class), (CloneStatusManager)EasyMock.niceMock(CloneStatusManager.class));
        this.coordinator.start();
        latch1.await();
        latch2.await();
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun_queryFromDeepStorage() throws Exception {
        String dataSource = "dataSource1";
        String coldTier = "coldTier";
        String hotTier = "hotTier";
        IntervalLoadRule intervalLoadRule = new IntervalLoadRule(Intervals.of((String)"2010-02-01/P1M"), (Map)ImmutableMap.of((Object)hotTier, (Object)1), null);
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)coldTier, (Object)0), null);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)intervalLoadRule, (Object)foreverLoadRule)).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] dataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        DataSegment dataSegmentHot = new DataSegment(dataSource, Intervals.of((String)"2010-02-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSources[0].addSegment(dataSegment).addSegment(dataSegmentHot);
        this.setupSegmentsMetadataMock(dataSources[0]);
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment, (Object)dataSegmentHot)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        DruidServer druidServer1 = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, hotTier, 0);
        DruidServer druidServer2 = new DruidServer("server2", "localhost", null, 5L, ServerType.HISTORICAL, coldTier, 0);
        this.setupPeons((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"server1", (Object)new TestLoadQueuePeon(), (Object)"server2", (Object)this.createImmediateLoadPeonFor(druidServer2)));
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)druidServer1, (Object)druidServer2)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView, this.loadQueueTaskMaster});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        this.serviceEmitter.coordinatorRunLatch.await();
        Object2IntMap numsUnavailableUsedSegmentsPerDataSource = this.coordinator.getDatasourceToUnavailableSegmentCount();
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.size());
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.getInt((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.getTierToDatasourceToUnderReplicatedCount(false);
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSourceHotTier = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(hotTier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceHotTier);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSourceHotTier.getLong((Object)dataSource));
        Object2LongMap underRepliicationCountsPerDataSourceColdTier = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(coldTier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceColdTier);
        Assert.assertEquals((long)0L, (long)underRepliicationCountsPerDataSourceColdTier.getLong((Object)dataSource));
        Object2IntMap numsDeepStorageOnlySegmentsPerDataSource = this.coordinator.getDatasourceToDeepStorageQueryOnlySegmentCount();
        Assert.assertEquals((long)1L, (long)numsDeepStorageOnlySegmentsPerDataSource.getInt((Object)dataSource));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test
    public void testSimulateRunWithEmptyDatasourceCompactionConfigs() {
        DataSourcesSnapshot dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(Collections.emptyList());
        EasyMock.expect((Object)this.segmentsMetadataManager.getRecentDataSourcesSnapshot()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        CompactionSimulateResult result = this.coordinator.simulateRunWithConfigUpdate(new ClusterCompactionConfig(Double.valueOf(0.2), null, null, null, null));
        Assert.assertEquals(Collections.emptyMap(), (Object)result.getCompactionStates());
    }

    private void setupSegmentsMetadataMock(DruidDataSource dataSource) {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        DataSourcesSnapshot dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments((Iterable)dataSource.getSegments());
        EasyMock.expect((Object)this.segmentsMetadataManager.getRecentDataSourcesSnapshot()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.expect((Object)this.dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
    }

    private void setupPeons(Map<String, LoadQueuePeon> peonMap) {
        this.loadQueueTaskMaster.resetPeonsForNewServers((List)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        this.loadQueueTaskMaster.onLeaderStart();
        EasyMock.expectLastCall().anyTimes();
        this.loadQueueTaskMaster.onLeaderStop();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.loadQueueTaskMaster.getAllPeons()).andReturn(peonMap).anyTimes();
        EasyMock.expect((Object)this.loadQueueTaskMaster.getPeonForServer((ImmutableDruidServer)EasyMock.anyObject())).andAnswer(() -> (LoadQueuePeon)peonMap.get(((ImmutableDruidServer)EasyMock.getCurrentArgument((int)0)).getName())).anyTimes();
    }

    private LoadQueuePeon createImmediateLoadPeonFor(final DruidServer server) {
        return new TestLoadQueuePeon(){

            @Override
            public void loadSegment(DataSegment segment, SegmentAction action, @Nullable LoadPeonCallback callback) {
                server.addDataSegment(segment);
                super.loadSegment(segment, action, callback);
            }
        };
    }

    private static class LatchableServiceEmitter
    extends ServiceEmitter {
        private final CountDownLatch coordinatorRunLatch = new CountDownLatch(2);

        private LatchableServiceEmitter() {
            super("", "", null);
        }

        public void emit(Event event) {
            if (event instanceof ServiceMetricEvent) {
                ServiceMetricEvent metricEvent = (ServiceMetricEvent)event;
                String dutyGroupName = (String)metricEvent.getUserDims().get("dutyGroup");
                if (Stats.CoordinatorRun.GROUP_RUN_TIME.getMetricName().equals(metricEvent.getMetric()) && "HistoricalManagementDuties".equals(dutyGroupName)) {
                    this.coordinatorRunLatch.countDown();
                }
            }
        }
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

