/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class DruidCompactionConfigTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerdeDefaultConfig() throws Exception {
        DruidCompactionConfig defaultConfig = DruidCompactionConfig.empty();
        String json = MAPPER.writeValueAsString((Object)defaultConfig);
        DruidCompactionConfig deserialized = (DruidCompactionConfig)MAPPER.readValue(json, DruidCompactionConfig.class);
        Assert.assertEquals((Object)defaultConfig, (Object)deserialized);
    }

    @Test
    public void testSerdeWithDatasourceConfigs() throws Exception {
        DruidCompactionConfig config = new DruidCompactionConfig(Arrays.asList(InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withSkipOffsetFromLatest(Period.hours((int)1)).build(), InlineSchemaDataSourceCompactionConfig.builder().forDataSource("koala").withSkipOffsetFromLatest(Period.hours((int)2)).build()), null, null, null, null, null);
        String json = MAPPER.writeValueAsString((Object)config);
        DruidCompactionConfig deserialized = (DruidCompactionConfig)MAPPER.readValue(json, DruidCompactionConfig.class);
        Assert.assertEquals((Object)config, (Object)deserialized);
    }

    @Test
    public void testCopyWithClusterConfig() {
        DruidCompactionConfig config = DruidCompactionConfig.empty();
        ClusterCompactionConfig clusterConfig = new ClusterCompactionConfig(Double.valueOf(0.5), Integer.valueOf(10), (CompactionCandidateSearchPolicy)new NewestSegmentFirstPolicy(null), Boolean.valueOf(true), CompactionEngine.MSQ);
        DruidCompactionConfig copy = config.withClusterConfig(clusterConfig);
        Assert.assertEquals((Object)clusterConfig, (Object)copy.clusterConfig());
        Assert.assertNotEquals((Object)clusterConfig, (Object)config.clusterConfig());
    }

    @Test
    public void testCopyWithDatasourceConfigs() {
        DruidCompactionConfig config = DruidCompactionConfig.empty();
        Assert.assertTrue((boolean)config.getCompactionConfigs().isEmpty());
        InlineSchemaDataSourceCompactionConfig dataSourceConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withEngine(CompactionEngine.NATIVE).build();
        DruidCompactionConfig copy = config.withDatasourceConfigs(Collections.singletonList(dataSourceConfig));
        Assert.assertEquals((long)1L, (long)copy.getCompactionConfigs().size());
        Assert.assertEquals((Object)dataSourceConfig, (Object)copy.findConfigForDatasource("wiki").orNull());
    }

    @Test
    public void testDefaultConfigValues() {
        DruidCompactionConfig config = DruidCompactionConfig.empty();
        Assert.assertTrue((boolean)config.getCompactionConfigs().isEmpty());
        Assert.assertTrue((boolean)(config.getCompactionPolicy() instanceof NewestSegmentFirstPolicy));
        Assert.assertEquals((Object)CompactionEngine.NATIVE, (Object)config.getEngine());
        Assert.assertEquals((double)0.1, (double)config.getCompactionTaskSlotRatio(), (double)1.0E-9);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.getMaxCompactionTaskSlots());
    }
}

