/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Ignore
@RunWith(value=Parameterized.class)
public class CostBalancerStrategyBenchmark
extends AbstractBenchmark {
    private final CostBalancerStrategy strategy;
    private final List<ServerHolder> serverHolderList;
    volatile ServerHolder selected;
    private final Interval interval1 = Intervals.of((String)"2015-01-01T01:00:00Z/2015-01-01T02:00:00Z");
    private final Interval interval2 = Intervals.of((String)"2015-02-01T01:00:00Z/2015-02-01T02:00:00Z");
    volatile Long sum;

    @Parameterized.Parameters
    public static List<CostBalancerStrategy[]> factoryClasses() {
        return Arrays.asList({new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)1, (String)"CostBalancerStrategyBenchmark-%d")))}, {new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)4, (String)"CostBalancerStrategyBenchmark-%d")))});
    }

    public CostBalancerStrategyBenchmark(CostBalancerStrategy costBalancerStrategy) {
        this.strategy = costBalancerStrategy;
        this.serverHolderList = this.initServers();
    }

    private List<ServerHolder> initServers() {
        ArrayList<DruidServer> servers = new ArrayList<DruidServer>();
        for (int i = 0; i < 6; ++i) {
            DruidServer druidServer = new DruidServer("server_" + i, "localhost", null, 10000000L, ServerType.HISTORICAL, "hot", 1);
            servers.add(druidServer);
        }
        List<DataSegment> segments = CreateDataSegments.ofDatasource("wikipedia").forIntervals(200, Granularities.DAY).withNumPartitions(100).eachOfSizeInMb(200L);
        Random random = new Random(100L);
        segments.forEach(segment -> ((DruidServer)servers.get(random.nextInt(servers.size()))).addDataSegment(segment));
        return servers.stream().map(DruidServer::toImmutableDruidServer).map(server -> new ServerHolder(server, null)).collect(Collectors.toList());
    }

    @Test
    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    public void testBenchmark() {
        DataSegment segment = DataSegment.builder().dataSource("testds").version("1000").interval(this.interval1).size(100L).build();
        Iterator candidates = this.strategy.findServersToLoadSegment(segment, this.serverHolderList);
        this.selected = candidates.hasNext() ? (ServerHolder)candidates.next() : null;
    }

    @BenchmarkOptions(warmupRounds=1000, benchmarkRounds=1000000)
    @Test
    public void testJodaGap() {
        long diff = 0L;
        for (int i = 0; i < 1000; ++i) {
            diff += this.interval1.gap((ReadableInterval)this.interval2).toDurationMillis();
        }
        this.sum = diff;
    }
}

