/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.CompactionTaskStatus;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionStatusTrackerTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final DataSegment WIKI_SEGMENT = CreateDataSegments.ofDatasource("wiki").eachOfSizeInMb(100L).get(0);
    private CompactionStatusTracker statusTracker;

    @Before
    public void setup() {
        this.statusTracker = new CompactionStatusTracker(MAPPER);
    }

    @Test
    public void testGetLatestTaskStatusForSubmittedTask() {
        CompactionCandidate candidateSegments = CompactionCandidate.from(Collections.singletonList(WIKI_SEGMENT));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task1"), candidateSegments);
        CompactionTaskStatus status = this.statusTracker.getLatestTaskStatus(candidateSegments);
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)status.getState());
    }

    @Test
    public void testGetLatestTaskStatusForSuccessfulTask() {
        CompactionCandidate candidateSegments = CompactionCandidate.from(Collections.singletonList(WIKI_SEGMENT));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task1"), candidateSegments);
        this.statusTracker.onTaskFinished("task1", TaskStatus.success((String)"task1"));
        CompactionTaskStatus status = this.statusTracker.getLatestTaskStatus(candidateSegments);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)status.getState());
    }

    @Test
    public void testGetLatestTaskStatusForFailedTask() {
        CompactionCandidate candidateSegments = CompactionCandidate.from(Collections.singletonList(WIKI_SEGMENT));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task1"), candidateSegments);
        this.statusTracker.onTaskFinished("task1", TaskStatus.failure((String)"task1", (String)"some failure"));
        CompactionTaskStatus status = this.statusTracker.getLatestTaskStatus(candidateSegments);
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getState());
        Assert.assertEquals((long)1L, (long)status.getNumConsecutiveFailures());
    }

    @Test
    public void testGetLatestTaskStatusForRepeatedlyFailingTask() {
        CompactionCandidate candidateSegments = CompactionCandidate.from(Collections.singletonList(WIKI_SEGMENT));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task1"), candidateSegments);
        this.statusTracker.onTaskFinished("task1", TaskStatus.failure((String)"task1", (String)"some failure"));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task2"), candidateSegments);
        CompactionTaskStatus status = this.statusTracker.getLatestTaskStatus(candidateSegments);
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)status.getState());
        Assert.assertEquals((long)1L, (long)status.getNumConsecutiveFailures());
        this.statusTracker.onTaskFinished("task2", TaskStatus.failure((String)"task2", (String)"second failure"));
        status = this.statusTracker.getLatestTaskStatus(candidateSegments);
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getState());
        Assert.assertEquals((long)2L, (long)status.getNumConsecutiveFailures());
    }

    @Test
    public void testComputeCompactionStatusForSuccessfulTask() {
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build();
        NewestSegmentFirstPolicy policy = new NewestSegmentFirstPolicy(null);
        CompactionCandidate candidateSegments = CompactionCandidate.from(Collections.singletonList(WIKI_SEGMENT));
        CompactionStatus status = this.statusTracker.computeCompactionStatus(candidateSegments, (DataSourceCompactionConfig)compactionConfig, (CompactionCandidateSearchPolicy)policy);
        Assert.assertEquals((Object)CompactionStatus.State.PENDING, (Object)status.getState());
        Assert.assertEquals((Object)"not compacted yet", (Object)status.getReason());
        this.statusTracker.onSegmentTimelineUpdated(DateTimes.nowUtc().minusMinutes(1));
        this.statusTracker.onTaskSubmitted(this.createCompactionTask("task1"), candidateSegments);
        this.statusTracker.onTaskFinished("task1", TaskStatus.success((String)"task1"));
        status = this.statusTracker.computeCompactionStatus(candidateSegments, (DataSourceCompactionConfig)compactionConfig, (CompactionCandidateSearchPolicy)policy);
        Assert.assertEquals((Object)CompactionStatus.State.SKIPPED, (Object)status.getState());
        Assert.assertEquals((Object)"Segment timeline not updated since last compaction task succeeded", (Object)status.getReason());
        this.statusTracker.onSegmentTimelineUpdated(DateTimes.nowUtc());
        status = this.statusTracker.computeCompactionStatus(candidateSegments, (DataSourceCompactionConfig)compactionConfig, (CompactionCandidateSearchPolicy)policy);
        Assert.assertEquals((Object)CompactionStatus.State.PENDING, (Object)status.getState());
    }

    private ClientCompactionTaskQuery createCompactionTask(String taskId) {
        return new ClientCompactionTaskQuery(taskId, "wiki", null, null, null, null, null, null, null, null, null);
    }
}

