/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.server.EtagProvider;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TestClusterQuerySegmentWalker
implements QuerySegmentWalker {
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>> timelines;
    private final QueryRunnerFactoryConglomerate conglomerate;
    @Nullable
    private final QueryScheduler scheduler;
    private final EtagProvider etagProvider;

    @Inject
    TestClusterQuerySegmentWalker(TestSegmentsBroker testSegmentsBroker, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler, EtagProvider etagProvider) {
        this(testSegmentsBroker.timelines, conglomerate, scheduler, etagProvider);
    }

    TestClusterQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>> timelines, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler, EtagProvider etagProvider) {
        this.timelines = timelines;
        this.conglomerate = conglomerate;
        this.scheduler = scheduler;
        this.etagProvider = etagProvider;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return (queryPlus, responseContext) -> {
            ExecutionVertex ev = ExecutionVertex.of((Query)queryPlus.getQuery());
            if (!ev.isProcessable() || !ev.isTableBased()) {
                throw new ISE("Cannot handle datasource: %s", new Object[]{queryPlus.getQuery().getDataSource()});
            }
            String dataSourceName = ev.getBaseTableDataSource().getName();
            FunctionalIterable segmentDescriptors = FunctionalIterable.create((Iterable)intervals).transformCat(interval -> this.getSegmentsForTable(dataSourceName, (Interval)interval)).transform(WindowedSegment::getDescriptor);
            return this.getQueryRunnerForSegments(queryPlus.getQuery(), (Iterable<SegmentDescriptor>)segmentDescriptors).run(queryPlus, responseContext);
        };
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        ExecutionVertex ev = ExecutionVertex.of(query);
        if (!ev.canRunQueryUsingClusterWalker()) {
            throw new ISE("Cannot handle datasource: %s", new Object[]{dataSourceFromQuery});
        }
        String dataSourceName = ev.getBaseTableDataSource().getName();
        QueryToolChest toolChest = factory.getToolchest();
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{dataSourceFromQuery});
        }
        SegmentMapFunction segmentMapFn = ev.createSegmentMapFunction((PolicyEnforcer)NoopPolicyEnforcer.instance());
        FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration((queryPlus, responseContext) -> this.makeTableRunner(toolChest, factory, this.getSegmentsForTable(dataSourceName, specs), segmentMapFn).run(GroupByQueryRunnerTestHelper.populateResourceId((QueryPlus)queryPlus), responseContext)), false)), toolChest);
        return (arg_0, arg_1) -> this.lambda$getQueryRunnerForSegments$5(specs, (QueryRunner)baseRunner, arg_0, arg_1);
    }

    private <T> QueryRunner<T> makeTableRunner(final QueryToolChest<T, Query<T>> toolChest, final QueryRunnerFactory<T, Query<T>> factory, Iterable<WindowedSegment> segments, final SegmentMapFunction segmentMapFn) {
        final ArrayList segmentsList = Lists.newArrayList(segments);
        if (segmentsList.isEmpty()) {
            return new NoopQueryRunner();
        }
        return new QueryRunner<T>(){

            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                Closer closer = Closer.create();
                try {
                    FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)FunctionalIterable.create((Iterable)segmentsList).transform(segment -> new SpecificSegmentQueryRunner(factory.createRunner((Segment)closer.register((Closeable)((Segment)((Optional)segmentMapFn.apply((Object)segment.getSegment())).orElseThrow()))), new SpecificSegmentSpec(segment.getDescriptor())))), true), toolChest);
                    return runner.run(queryPlus, responseContext).withBaggage((Closeable)closer);
                }
                catch (Throwable e) {
                    throw CloseableUtils.closeAndWrapInCatch((Throwable)e, (Closeable)closer);
                }
            }
        };
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Interval interval) {
        VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (TimelineObjectHolder holder : timeline.lookup(interval)) {
            for (PartitionChunk chunk : holder.getObject()) {
                retVal.add(new WindowedSegment((ReferenceCountedSegmentProvider)chunk.getObject(), holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber()));
            }
        }
        return retVal;
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Iterable<SegmentDescriptor> specs) {
        VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (SegmentDescriptor spec : specs) {
            PartitionChunk entry = timeline.findChunk(spec.getInterval(), (Object)spec.getVersion(), spec.getPartitionNumber());
            retVal.add(new WindowedSegment((ReferenceCountedSegmentProvider)entry.getObject(), spec.getInterval(), spec.getVersion(), spec.getPartitionNumber()));
        }
        return retVal;
    }

    private /* synthetic */ Sequence lambda$getQueryRunnerForSegments$5(Iterable specs, QueryRunner baseRunner, QueryPlus theQuery, ResponseContext responseContext) {
        QueryPlus newQuery = GroupByQueryRunnerTestHelper.populateResourceId((QueryPlus)theQuery);
        responseContext.initializeRemainingResponses();
        String etag = this.etagProvider.getEtagFor(newQuery.getQuery());
        if (etag != null) {
            responseContext.put(ResponseContext.Keys.ETAG, (Object)etag);
        }
        responseContext.addRemainingResponse(newQuery.getQuery().getMostSpecificId(), 0);
        if (this.scheduler != null) {
            HashSet segments = new HashSet();
            specs.forEach(spec -> segments.add(new SegmentServerSelector(spec)));
            return this.scheduler.run(this.scheduler.prioritizeAndLaneQuery(newQuery, segments), (Sequence)new LazySequence(() -> baseRunner.run(newQuery.withQuery(Queries.withSpecificSegments((Query)newQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext)));
        }
        return baseRunner.run(newQuery.withQuery(Queries.withSpecificSegments((Query)newQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext);
    }

    public static class TestSegmentsBroker {
        public final Map<String, VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>> timelines = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>>();
    }

    private static class WindowedSegment {
        private final ReferenceCountedSegmentProvider segment;
        private final Interval interval;
        private final String version;
        private final int partitionNumber;

        public WindowedSegment(ReferenceCountedSegmentProvider segment, Interval interval, String version, int partitionNumber) {
            if (segment.getBaseSegment().getId() != null) {
                Preconditions.checkArgument((boolean)segment.getBaseSegment().getId().getInterval().contains((ReadableInterval)interval));
            } else {
                Preconditions.checkArgument((boolean)segment.getBaseSegment().getDataInterval().contains((ReadableInterval)interval), (Object)"Data interval for non-table segment should default to external");
            }
            this.segment = segment;
            this.interval = interval;
            this.version = version;
            this.partitionNumber = partitionNumber;
        }

        public ReferenceCountedSegmentProvider getSegment() {
            return this.segment;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentDescriptor getDescriptor() {
            return new SegmentDescriptor(this.interval, this.version, this.partitionNumber);
        }
    }
}

