/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.testing.fieldbinder.Bind;
import com.google.inject.testing.fieldbinder.BoundFieldModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContextTest;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@LazySingleton
public class QueryLifecycleTest {
    private static final String DATASOURCE = "some_datasource";
    private static final String IDENTITY = "some_identity";
    private static final String AUTHORIZER = "some_authorizer";
    private static final Resource RESOURCE = new Resource("some_datasource", "DATASOURCE");
    private final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("some_datasource").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
    QueryToolChest toolChest;
    @Bind
    QueryRunnerFactoryConglomerate conglomerate;
    QueryRunner runner;
    @Bind
    QuerySegmentWalker texasRanger;
    @Bind
    GenericQueryMetricsFactory metricsFactory;
    @Bind
    ServiceEmitter emitter;
    @Bind
    RequestLogger requestLogger;
    Authorizer authorizer;
    @Bind
    AuthorizerMapper authzMapper;
    DefaultQueryConfig queryConfig;
    @Bind(lazy=true)
    Supplier<DefaultQueryConfig> queryConfigSupplier;
    @Bind(lazy=true)
    AuthConfig authConfig;
    @Bind(lazy=true)
    PolicyEnforcer policyEnforcer;
    QueryMetrics metrics;
    AuthenticationResult authenticationResult;
    @Inject
    QueryLifecycleFactory queryLifecycleFactory;
    Injector injector;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.conglomerate = (QueryRunnerFactoryConglomerate)EasyMock.createMock(QueryRunnerFactoryConglomerate.class);
        this.texasRanger = (QuerySegmentWalker)EasyMock.createMock(QuerySegmentWalker.class);
        this.metricsFactory = (GenericQueryMetricsFactory)EasyMock.createMock(GenericQueryMetricsFactory.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        this.requestLogger = (RequestLogger)EasyMock.createNiceMock(RequestLogger.class);
        this.authorizer = (Authorizer)EasyMock.createMock(Authorizer.class);
        this.authzMapper = new AuthorizerMapper((Map)ImmutableMap.of((Object)AUTHORIZER, (Object)this.authorizer));
        this.queryConfig = (DefaultQueryConfig)EasyMock.createMock(DefaultQueryConfig.class);
        this.queryConfigSupplier = () -> this.queryConfig;
        this.toolChest = (QueryToolChest)EasyMock.createMock(QueryToolChest.class);
        this.runner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        this.metrics = (QueryMetrics)EasyMock.createNiceMock(QueryMetrics.class);
        this.authenticationResult = (AuthenticationResult)EasyMock.createMock(AuthenticationResult.class);
        this.authConfig = new AuthConfig();
        this.policyEnforcer = NoopPolicyEnforcer.instance();
        this.injector = Guice.createInjector((Module[])new Module[]{BoundFieldModule.of((Object)this), binder -> binder.bindScope(LazySingleton.class, Scopes.SINGLETON)});
    }

    private QueryLifecycle createLifecycle() {
        this.injector.injectMembers((Object)this);
        return this.queryLifecycleFactory.factorize();
    }

    @After
    public void teardown() {
        EasyMock.verify((Object[])new Object[]{this.conglomerate, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }

    @Test
    public void testRunSimple_preauthorizedAsSuperuser() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).once();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).once();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)this.query, this.authenticationResult, AuthorizationResult.ALLOW_NO_RESTRICTION);
    }

    @Test
    public void testRunSimpleUnauthorized() {
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Unexpected state [UNAUTHORIZED], expecting [AUTHORIZED]");
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)this.query, this.authenticationResult, AuthorizationResult.DENY);
    }

    @Test
    public void testRunSimple_withPolicyRestriction() {
        RowFilterPolicy rowFilterPolicy = RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null));
        AuthorizationResult authorizationResult = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)DATASOURCE, Optional.of(rowFilterPolicy)));
        RestrictedDataSource expectedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)DATASOURCE), (Policy)rowFilterPolicy);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals(QueryLifecycleTest.queryMatchDataSource((DataSource)expectedDataSource), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).once();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).once();
        this.replayAll();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)query, this.authenticationResult, authorizationResult);
    }

    @Test
    public void testRunSimple_withPolicyRestriction_segmentMetadataQueryRunAsInternal() {
        AuthorizationResult authorizationResult = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)DATASOURCE, Optional.of(NoRestrictionPolicy.instance())));
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).once();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).once();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)query, this.authenticationResult, authorizationResult);
    }

    @Test
    public void testRunSimple_withPolicyRestriction_segmentMetadataQueryRunAsExternal() {
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)new NullFilter("col", null));
        AuthorizationResult authorizationResult = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)DATASOURCE, Optional.of(policy)));
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).once();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> lifecycle.runSimple((Query)query, this.authenticationResult, authorizationResult));
        Assert.assertEquals((Object)DruidException.Persona.USER, (Object)e.getTargetPersona());
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e.getCategory());
        Assert.assertEquals((Object)"You do not have permission to run a segmentMetadata query on table[some_datasource].", (Object)e.getMessage());
    }

    @Test
    public void testRunSimple_withoutPolicy() {
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOW_NO_RESTRICTION;
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).anyTimes();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).anyTimes();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)this.query, this.authenticationResult, authorizationResult);
    }

    @Test
    public void testRunSimple_foundDifferentPolicyRestrictions() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Different restrictions on table [some_datasource]: previous policy [RowFilterPolicy{rowFilter=some-column IS NULL}] and new policy [RowFilterPolicy{rowFilter=some-column2 IS NULL}]");
        NullFilter originalFilterOnRDS = new NullFilter("some-column", null);
        RowFilterPolicy originalFilterPolicy = RowFilterPolicy.from((DimFilter)originalFilterOnRDS);
        RowFilterPolicy newFilterPolicy = RowFilterPolicy.from((DimFilter)new NullFilter("some-column2", null));
        AuthorizationResult authorizationResult = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)DATASOURCE, Optional.of(newFilterPolicy)));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)RestrictedDataSource.create((DataSource)TableDataSource.create((String)DATASOURCE), (Policy)originalFilterPolicy)).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).anyTimes();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).anyTimes();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).anyTimes();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.runSimple((Query)query, this.authenticationResult, authorizationResult);
    }

    @Test
    public void testAuthorized_withPolicyRestriction() {
        RowFilterPolicy rowFilterPolicy = RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null));
        Access access = Access.allowWithRestriction((Policy)rowFilterPolicy);
        RestrictedDataSource expectedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)DATASOURCE), (Policy)rowFilterPolicy);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, RESOURCE, Action.READ)).andReturn((Object)access).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).anyTimes();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals(QueryLifecycleTest.queryMatchDataSource((DataSource)expectedDataSource), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).anyTimes();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).anyTimes();
        this.replayAll();
        this.policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName(), (Object)RowFilterPolicy.class.getName()));
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.authenticationResult).allowBasicAccess());
        lifecycle.execute();
    }

    @Test
    public void testAuthorized_withPolicyRestriction_failedSecurityValidation() {
        RowFilterPolicy rowFilterPolicy = RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null));
        Access access = Access.allowWithRestriction((Policy)rowFilterPolicy);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, RESOURCE, Action.READ)).andReturn((Object)access).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).anyTimes();
        this.replayAll();
        this.policyEnforcer = new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)NoRestrictionPolicy.class.getName()));
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> lifecycle.authorize(this.authenticationResult));
        Assert.assertEquals((Object)DruidException.Category.FORBIDDEN, (Object)e.getCategory());
        Assert.assertEquals((Object)DruidException.Persona.OPERATOR, (Object)e.getTargetPersona());
        Assert.assertEquals((Object)"Failed security validation with dataSource [some_datasource]", (Object)e.getMessage());
    }

    @Test
    public void testAuthorized_queryWithRestrictedDataSource_runWithSuperUserPermission() {
        RowFilterPolicy rowFilterPolicy = RowFilterPolicy.from((DimFilter)new NullFilter("some-column", null));
        Access access = Access.allowWithRestriction((Policy)NoRestrictionPolicy.instance());
        RestrictedDataSource restrictedDataSource = RestrictedDataSource.create((DataSource)TableDataSource.create((String)DATASOURCE), (Policy)rowFilterPolicy);
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)restrictedDataSource).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, RESOURCE, Action.READ)).andReturn((Object)access).anyTimes();
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).anyTimes();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals(QueryLifecycleTest.queryMatchDataSource((DataSource)restrictedDataSource), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).anyTimes();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).anyTimes();
        this.replayAll();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.authenticationResult).allowBasicAccess());
        lifecycle.execute();
    }

    @Test
    public void testAuthorizeQueryContext_authorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("baz", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).allowAccessWithNoRestriction());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.authenticationResult).allowAccessWithNoRestriction());
    }

    @Test
    public void testAuthorizeQueryContext_notAuthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.DENIED).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.mockRequest()).allowBasicAccess());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.authenticationResult).allowBasicAccess());
    }

    @Test
    public void testAuthorizeQueryContext_unsecuredKeys() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, RESOURCE, Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setUnsecuredContextKeys((Set)ImmutableSet.of((Object)"foo", (Object)"baz")).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).allowAccessWithNoRestriction());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.authenticationResult).allowAccessWithNoRestriction());
    }

    @Test
    public void testAuthorizeQueryContext_securedKeys() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setSecuredContextKeys((Set)ImmutableSet.of((Object)"foo2", (Object)"baz2")).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).allowBasicAccess());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.authenticationResult).allowBasicAccess());
    }

    @Test
    public void testAuthorizeQueryContext_securedKeysNotAuthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.DENIED).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setSecuredContextKeys((Set)ImmutableSet.of((Object)"foo", (Object)"baz2")).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.mockRequest()).allowBasicAccess());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.authenticationResult).allowBasicAccess());
    }

    @Test
    public void testAuthorizeLegacyQueryContext_authorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("fake", "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("baz", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK).times(2);
        EasyMock.expect((Object)this.conglomerate.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).times(2);
        this.replayAll();
        QueryContextTest.LegacyContextQuery query = new QueryContextTest.LegacyContextQuery((Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux"));
        this.authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Map revisedContext = lifecycle.getQuery().getContext();
        Assert.assertNotNull((Object)revisedContext);
        Assert.assertTrue((boolean)revisedContext.containsKey("foo"));
        Assert.assertTrue((boolean)revisedContext.containsKey("baz"));
        Assert.assertTrue((boolean)revisedContext.containsKey("queryId"));
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).allowBasicAccess());
        lifecycle = this.createLifecycle();
        lifecycle.initialize((Query)query);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).allowBasicAccess());
    }

    public static Query<?> queryMatchDataSource(final DataSource dataSource) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object query) {
                return query instanceof Query && ((Query)query).getDataSource().equals(dataSource);
            }

            public void appendTo(StringBuffer buffer) {
                buffer.append("dataSource(\"").append(dataSource).append("\")");
            }
        });
        return null;
    }

    private HttpServletRequest mockRequest() {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Authentication-Result"))).andReturn((Object)this.authenticationResult).anyTimes();
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Allow-Unsecured-Path"))).andReturn(null).anyTimes();
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Authorization-Checked"))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        return request;
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.conglomerate, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }
}

