/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import io.github.resilience4j.bulkhead.Bulkhead;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryPrioritizationStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.initialization.ServerConfig;

public class ObservableQueryScheduler
extends QueryScheduler {
    private final AtomicLong totalAcquired = new AtomicLong();
    private final AtomicLong totalReleased = new AtomicLong();
    private final AtomicLong laneAcquired = new AtomicLong();
    private final AtomicLong laneNotAcquired = new AtomicLong();
    private final AtomicLong laneReleased = new AtomicLong();
    private final AtomicLong totalPrioritizedAndLaned = new AtomicLong();
    private final AtomicLong totalRun = new AtomicLong();

    public ObservableQueryScheduler(int totalNumThreads, QueryPrioritizationStrategy prioritizationStrategy, QueryLaningStrategy laningStrategy, ServerConfig serverConfig) {
        super(totalNumThreads, prioritizationStrategy, laningStrategy, serverConfig);
    }

    public <T> Sequence<T> run(Query<?> query, Sequence<T> resultSequence) {
        return super.run(query, resultSequence).withBaggage(this.totalRun::incrementAndGet);
    }

    public <T> Query<T> prioritizeAndLaneQuery(QueryPlus<T> queryPlus, Set<SegmentServerSelector> segments) {
        this.totalPrioritizedAndLaned.incrementAndGet();
        return super.prioritizeAndLaneQuery(queryPlus, segments);
    }

    List<Bulkhead> acquireLanes(Query<?> query) {
        List bulkheads = super.acquireLanes(query);
        if (bulkheads.stream().anyMatch(b -> b.getName().equals("total"))) {
            this.totalAcquired.incrementAndGet();
        }
        if (bulkheads.stream().anyMatch(b -> !b.getName().equals("total"))) {
            this.laneAcquired.incrementAndGet();
        }
        return bulkheads;
    }

    void releaseLanes(List<Bulkhead> bulkheads) {
        super.releaseLanes(bulkheads);
        if (bulkheads.stream().anyMatch(b -> b.getName().equals("total"))) {
            this.totalReleased.incrementAndGet();
        }
        if (bulkheads.stream().anyMatch(b -> !b.getName().equals("total"))) {
            this.laneReleased.incrementAndGet();
            if (bulkheads.size() == 1) {
                this.laneNotAcquired.incrementAndGet();
            }
        }
    }

    void finishLanes(List<Bulkhead> bulkheads) {
        super.finishLanes(bulkheads);
        if (bulkheads.stream().anyMatch(b -> b.getName().equals("total"))) {
            this.totalReleased.incrementAndGet();
        }
        if (bulkheads.stream().anyMatch(b -> !b.getName().equals("total"))) {
            this.laneReleased.incrementAndGet();
        }
    }

    public AtomicLong getTotalAcquired() {
        return this.totalAcquired;
    }

    public AtomicLong getTotalReleased() {
        return this.totalReleased;
    }

    public AtomicLong getLaneAcquired() {
        return this.laneAcquired;
    }

    public AtomicLong getLaneNotAcquired() {
        return this.laneNotAcquired;
    }

    public AtomicLong getLaneReleased() {
        return this.laneReleased;
    }

    public AtomicLong getTotalPrioritizedAndLaned() {
        return this.totalPrioritizedAndLaned;
    }

    public AtomicLong getTotalRun() {
        return this.totalRun;
    }
}

