/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.router.ConsistentHasher;
import org.junit.Assert;
import org.junit.Test;

public class ConsistentHasherTest {
    private static HashFunction TEST_HASH_FN = Hashing.murmur3_128();
    private static int NUM_ITERATIONS = 10000;
    private static final Logger log = new Logger(ConsistentHasherTest.class);

    @Test
    public void testBasic() {
        int i;
        ConsistentHasher hasher = new ConsistentHasher(TEST_HASH_FN);
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        hasher.updateKeys(nodes);
        for (i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        for (i = 0; i < 2; ++i) {
            for (Map.Entry entry : uuidServerMap.entrySet()) {
                String targetServer = hasher.findKey(StringUtils.toUtf8((String)((String)entry.getKey())));
                Assert.assertEquals(entry.getValue(), (Object)targetServer);
            }
        }
    }

    @Test
    public void testAddNode() {
        ConsistentHasher hasher = new ConsistentHasher(TEST_HASH_FN);
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        hasher.updateKeys(nodes);
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.add("localhost:6");
        hasher.updateKeys(nodes);
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testAddNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.2 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNode() {
        ConsistentHasher hasher = new ConsistentHasher(TEST_HASH_FN);
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        hasher.updateKeys(nodes);
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.remove("localhost:3");
        hasher.updateKeys(nodes);
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testRemoveNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.25 ? 1 : 0) != 0);
    }

    @Test
    public void testInconsistentView1() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:3");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView1", nodes, nodes2, 0.33);
    }

    @Test
    public void testInconsistentView2() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:2");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView2", nodes, nodes2, 0.5);
    }

    @Test
    public void testInconsistentView3() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView3", nodes, nodes2, 0.66);
    }

    @Test
    public void testInconsistentView4() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:2");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView4", nodes, nodes2, 0.95);
    }

    /*
     * WARNING - void declaration
     */
    public void testInconsistentViewHelper(String testName, Set<String> nodes, Set<String> nodes2, double expectedDiffRatio) {
        void var11_14;
        ConsistentHasher hasher = new ConsistentHasher(TEST_HASH_FN);
        hasher.updateKeys(nodes);
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.findKey(StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        ConsistentHasher hasher2 = new ConsistentHasher(TEST_HASH_FN);
        hasher2.updateKeys(nodes2);
        HashMap<String, Object> uuidServerMap2 = new HashMap<String, Object>();
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher2.findKey(StringUtils.toUtf8((String)((String)entry.getKey())));
            uuidServerMap2.put((String)entry.getKey(), targetServer);
        }
        int same = 0;
        boolean bl = false;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String otherServer = (String)uuidServerMap2.get(entry.getKey());
            if (((String)entry.getValue()).equals(otherServer)) {
                ++same;
                continue;
            }
            ++var11_14;
        }
        double actualDiffRatio = (double)var11_14 / (double)NUM_ITERATIONS;
        log.info(StringUtils.format((String)"%s Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{testName, NUM_ITERATIONS, same, (int)var11_14}), new Object[0]);
        log.info("Expected diff ratio: %s, Actual diff ratio: %s", new Object[]{expectedDiffRatio, actualDiffRatio});
        Assert.assertTrue((actualDiffRatio <= expectedDiffRatio ? 1 : 0) != 0);
    }
}

