/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.sink;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.sink.Sink;
import org.apache.druid.segment.realtime.sink.SinkSegmentReference;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SinkTest
extends InitializedNullHandlingTest {
    private static final ShardSpec SHARD_SPEC = new NumberedShardSpec(0, 1);
    private static final int MAX_ROWS_IN_MEMORY = 100;

    @Test
    public void testSwap() throws Exception {
        DataSchema schema = DataSchema.builder().withDataSource("test").withTimestamp(new TimestampSpec(null, null, null)).withDimensions(DimensionsSpec.EMPTY).withAggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null)).build();
        Interval interval = Intervals.of((String)"2013-01-01/2013-01-02");
        String version = DateTimes.nowUtc().toString();
        Sink sink = new Sink(interval, schema, SHARD_SPEC, version, TuningConfig.DEFAULT_APPENDABLE_INDEX, 100, TuningConfig.DEFAULT_APPENDABLE_INDEX.getDefaultMaxBytesInMemory());
        sink.add(new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>();
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)"2013-01-01").getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)"2013-01-01");
            }

            public List<String> getDimension(String dimension) {
                return new ArrayList<String>();
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        });
        FireHydrant currHydrant = sink.getCurrHydrant();
        Assert.assertEquals((Object)Intervals.of((String)"2013-01-01/PT1M"), (Object)currHydrant.getIndex().getInterval());
        FireHydrant swapHydrant = sink.swap();
        sink.add(new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>();
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)"2013-01-01").getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)"2013-01-01");
            }

            public List<String> getDimension(String dimension) {
                return new ArrayList<String>();
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        });
        Assert.assertEquals((Object)currHydrant, (Object)swapHydrant);
        Assert.assertNotSame((Object)currHydrant, (Object)sink.getCurrHydrant());
        Assert.assertEquals((Object)Intervals.of((String)"2013-01-01/PT1M"), (Object)sink.getCurrHydrant().getIndex().getInterval());
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)sink.iterator()));
    }

    @Test
    public void testAcquireSegmentReferences_empty() {
        Assert.assertEquals(Collections.emptyList(), (Object)Sink.acquireSegmentReferences(Collections.emptyList(), (SegmentMapFunction)SegmentMapFunction.IDENTITY, (boolean)false));
    }

    @Test
    public void testAcquireSegmentReferences_two() throws IOException {
        List<FireHydrant> hydrants = SinkTest.twoHydrants();
        List references = Sink.acquireSegmentReferences(hydrants, (SegmentMapFunction)SegmentMapFunction.IDENTITY, (boolean)false);
        Assert.assertNotNull((Object)references);
        Assert.assertEquals((long)2L, (long)references.size());
        Assert.assertEquals((long)0L, (long)((SinkSegmentReference)references.get(0)).getHydrantNumber());
        Assert.assertFalse((boolean)((SinkSegmentReference)references.get(0)).isImmutable());
        Assert.assertEquals((long)1L, (long)((SinkSegmentReference)references.get(1)).getHydrantNumber());
        Assert.assertTrue((boolean)((SinkSegmentReference)references.get(1)).isImmutable());
        CloseableUtils.closeAll((Iterable)references);
    }

    @Test
    public void testAcquireSegmentReferences_two_skipIncremental() throws IOException {
        List<FireHydrant> hydrants = SinkTest.twoHydrants();
        List references = Sink.acquireSegmentReferences(hydrants, (SegmentMapFunction)SegmentMapFunction.IDENTITY, (boolean)true);
        Assert.assertNotNull((Object)references);
        Assert.assertEquals((long)1L, (long)references.size());
        Assert.assertEquals((long)1L, (long)((SinkSegmentReference)references.get(0)).getHydrantNumber());
        Assert.assertTrue((boolean)((SinkSegmentReference)references.get(0)).isImmutable());
        CloseableUtils.closeAll((Iterable)references);
    }

    @Test
    public void testAcquireSegmentReferences_twoWithOneSwappedToNull() {
        List<FireHydrant> hydrants = SinkTest.twoHydrants();
        hydrants.get(1).swapSegment(null);
        List references = Sink.acquireSegmentReferences(hydrants, (SegmentMapFunction)SegmentMapFunction.IDENTITY, (boolean)false);
        Assert.assertNull((Object)references);
    }

    @Test
    public void testGetSinkSignature() {
        DataSchema schema = DataSchema.builder().withDataSource("test").withTimestamp(new TimestampSpec(null, null, null)).withDimensions(new DimensionSchema[]{new StringDimensionSchema("dim1"), new LongDimensionSchema("dimLong")}).withAggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null)).build();
        Interval interval = Intervals.of((String)"2013-01-01/2013-01-02");
        String version = DateTimes.nowUtc().toString();
        Sink sink = new Sink(interval, schema, SHARD_SPEC, version, TuningConfig.DEFAULT_APPENDABLE_INDEX, 100, TuningConfig.DEFAULT_APPENDABLE_INDEX.getDefaultMaxBytesInMemory());
        sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"dim1", (Object)"dimLong"), (Map)ImmutableMap.of((Object)"dim1", (Object)"value1", (Object)"dimLong", (Object)"20")));
        LinkedHashMap expectedColumnTypeMap = Maps.newLinkedHashMap();
        expectedColumnTypeMap.put("__time", ColumnType.LONG);
        expectedColumnTypeMap.put("dim1", ColumnType.STRING);
        expectedColumnTypeMap.put("dimLong", ColumnType.LONG);
        expectedColumnTypeMap.put("rows", ColumnType.LONG);
        RowSignature signature = sink.getSignature();
        Assert.assertEquals((Object)this.toRowSignature(expectedColumnTypeMap), (Object)signature);
        sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"dim1", (Object)"dimLong", (Object)"newCol1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"value2", (Object)"dimLong", (Object)"30", (Object)"newCol1", (Object)"value")));
        expectedColumnTypeMap.remove("rows");
        expectedColumnTypeMap.put("newCol1", ColumnType.STRING);
        expectedColumnTypeMap.put("rows", ColumnType.LONG);
        signature = sink.getSignature();
        Assert.assertEquals((Object)this.toRowSignature(expectedColumnTypeMap), (Object)signature);
        sink.swap();
        sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"dim1", (Object)"dimLong", (Object)"newCol2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"value3", (Object)"dimLong", (Object)"30", (Object)"newCol2", (Object)"value")));
        expectedColumnTypeMap.put("newCol2", ColumnType.STRING);
        signature = sink.getSignature();
        Assert.assertEquals((Object)this.toRowSignature(expectedColumnTypeMap), (Object)signature);
        sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"dim1", (Object)"dimLong", (Object)"newCol3"), (Map)ImmutableMap.of((Object)"dim1", (Object)"value3", (Object)"dimLong", (Object)"30", (Object)"newCol3", (Object)"value")));
        expectedColumnTypeMap.put("newCol3", ColumnType.STRING);
        signature = sink.getSignature();
        Assert.assertEquals((Object)this.toRowSignature(expectedColumnTypeMap), (Object)signature);
        sink.swap();
        sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"dim1", (Object)"dimLong", (Object)"newCol4"), (Map)ImmutableMap.of((Object)"dim1", (Object)"value3", (Object)"dimLong", (Object)"30", (Object)"newCol4", (Object)"value")));
        expectedColumnTypeMap.put("newCol4", ColumnType.STRING);
        signature = sink.getSignature();
        Assert.assertEquals((Object)this.toRowSignature(expectedColumnTypeMap), (Object)signature);
    }

    private RowSignature toRowSignature(Map<String, ColumnType> columnTypeMap) {
        RowSignature.Builder builder = RowSignature.builder();
        for (Map.Entry<String, ColumnType> entry : columnTypeMap.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private static List<FireHydrant> twoHydrants() {
        SegmentId segmentId = SegmentId.dummy((String)"foo");
        return Arrays.asList(new FireHydrant((IncrementalIndex)EasyMock.createMock(IncrementalIndex.class), 0, segmentId), new FireHydrant((Segment)new RowBasedSegment(Sequences.empty(), RowAdapters.standardRow(), RowSignature.empty()), 1));
    }
}

