/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class TransactionalSegmentPublisherTest {
    @Test(timeout=60000L)
    public void testPublishSegments_retriesUpto5Times_ifFailureIsRetryable() throws IOException {
        AtomicInteger attemptCount = new AtomicInteger(0);
        TransactionalSegmentPublisher publisher = this.createPublisher(SegmentPublishResult.retryableFailure((String)"this error is retryable", (Object[])new Object[0]), attemptCount);
        Assert.assertEquals((Object)SegmentPublishResult.retryableFailure((String)"this error is retryable", (Object[])new Object[0]), (Object)publisher.publishSegments(null, Set.of(), Function.identity(), null, null));
        Assert.assertEquals((long)6L, (long)attemptCount.get());
    }

    @Test
    public void testPublishSegments_doesNotRetry_ifFailureIsNotRetryable() throws IOException {
        AtomicInteger attemptCount = new AtomicInteger(0);
        TransactionalSegmentPublisher publisher = this.createPublisher(SegmentPublishResult.fail((String)"this error is not retryable", (Object[])new Object[0]), attemptCount);
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"this error is not retryable", (Object[])new Object[0]), (Object)publisher.publishSegments(null, Set.of(), Function.identity(), null, null));
        Assert.assertEquals((long)1L, (long)attemptCount.get());
    }

    @Test
    public void testPublishAnnotatedSegments_doesNotRetry() throws Exception {
        AtomicInteger attemptCount = new AtomicInteger(0);
        TransactionalSegmentPublisher publisher = this.createPublisher(SegmentPublishResult.retryableFailure((String)"this error is retryable", (Object[])new Object[0]), attemptCount);
        Assert.assertEquals((Object)SegmentPublishResult.retryableFailure((String)"this error is retryable", (Object[])new Object[0]), (Object)publisher.publishAnnotatedSegments(null, Set.of(), null, null));
        Assert.assertEquals((long)1L, (long)attemptCount.get());
    }

    private TransactionalSegmentPublisher createPublisher(final SegmentPublishResult publishResult, final AtomicInteger attemptCount) {
        return new TransactionalSegmentPublisher(){

            public SegmentPublishResult publishAnnotatedSegments(@Nullable Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, @Nullable Object commitMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
                attemptCount.incrementAndGet();
                return publishResult;
            }
        };
    }
}

