/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.segment.realtime.appenderator.PublishedSegmentRetriever;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;

public class TestPublishedSegmentRetriever
implements PublishedSegmentRetriever {
    private final List<DataSegment> pushedSegments;

    public TestPublishedSegmentRetriever(List<DataSegment> pushedSegments) {
        this.pushedSegments = pushedSegments;
    }

    public Set<DataSegment> findPublishedSegments(Set<SegmentId> identifiers) {
        SegmentTimeline timeline = SegmentTimeline.forSegments(this.pushedSegments);
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        for (SegmentId segmentId : identifiers) {
            for (TimelineObjectHolder holder : timeline.lookup(segmentId.getInterval())) {
                for (PartitionChunk chunk : holder.getObject()) {
                    if (!identifiers.contains(((DataSegment)chunk.getObject()).getId())) continue;
                    retVal.add((DataSegment)chunk.getObject());
                }
            }
        }
        return retVal;
    }
}

