/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.junit.Assert;
import org.junit.Test;

public class SegmentGenerationMetricsTest {
    @Test
    public void testSnapshotBeforeProcessing() {
        SegmentGenerationMetrics metrics = new SegmentGenerationMetrics();
        SegmentGenerationMetricsTest.assertMessageGapAggregateMetricsReset(metrics);
        SegmentGenerationMetrics snapshot = metrics.snapshot();
        SegmentGenerationMetricsTest.assertMessageGapAggregateMetricsReset(metrics);
        Assert.assertTrue((0L > snapshot.maxSegmentHandoffTime() ? 1 : 0) != 0);
    }

    @Test
    public void testSnapshotAfterProcessingOver() {
        SegmentGenerationMetrics metrics = new SegmentGenerationMetrics();
        metrics.reportMessageGap(20L);
        metrics.reportMessageMaxTimestamp(20L);
        metrics.reportMaxSegmentHandoffTime(7L);
        SegmentGenerationMetrics snapshot = metrics.snapshot();
        Assert.assertTrue((snapshot.messageGap() >= 20L ? 1 : 0) != 0);
        SegmentGenerationMetrics.MessageGapStats messageGapStats = snapshot.getMessageGapStats();
        Assert.assertEquals((long)20L, (long)messageGapStats.min());
        Assert.assertEquals((long)20L, (long)messageGapStats.max());
        Assert.assertEquals((long)messageGapStats.min(), (long)messageGapStats.max());
        Assert.assertEquals((double)20.0, (double)messageGapStats.avg(), (double)0.0);
        Assert.assertEquals((long)7L, (long)snapshot.maxSegmentHandoffTime());
    }

    @Test
    public void testProcessingOverAfterSnapshot() {
        SegmentGenerationMetrics metrics = new SegmentGenerationMetrics();
        metrics.reportMessageMaxTimestamp(10L);
        metrics.reportMessageGap(1L);
        metrics.reportMaxSegmentHandoffTime(7L);
        metrics.snapshot();
        metrics.markProcessingDone();
        SegmentGenerationMetrics snapshot = metrics.snapshot();
        Assert.assertEquals((long)-1L, (long)snapshot.messageGap());
        SegmentGenerationMetrics.MessageGapStats messageGapStats = snapshot.getMessageGapStats();
        Assert.assertEquals((long)0L, (long)messageGapStats.count());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)messageGapStats.max());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)messageGapStats.min());
        Assert.assertEquals((double)Double.NaN, (double)messageGapStats.avg(), (double)0.0);
        Assert.assertTrue((0L > snapshot.maxSegmentHandoffTime() ? 1 : 0) != 0);
    }

    @Test
    public void testMessageGapAggregateMetrics() {
        SegmentGenerationMetrics metrics = new SegmentGenerationMetrics();
        for (int i = 0; i < 5; ++i) {
            metrics.reportMessageGap((long)(i * 30));
        }
        metrics.reportMessageMaxTimestamp(10L);
        metrics.reportMaxSegmentHandoffTime(7L);
        metrics.markProcessingDone();
        SegmentGenerationMetrics snapshot = metrics.snapshot();
        Assert.assertEquals((long)-1L, (long)snapshot.messageGap());
        SegmentGenerationMetrics.MessageGapStats messageGapStats = snapshot.getMessageGapStats();
        Assert.assertEquals((long)5L, (long)messageGapStats.count());
        Assert.assertEquals((long)0L, (long)messageGapStats.min());
        Assert.assertEquals((long)120L, (long)messageGapStats.max());
        Assert.assertEquals((double)60.0, (double)messageGapStats.avg(), (double)0.0);
        Assert.assertEquals((long)7L, (long)snapshot.maxSegmentHandoffTime());
    }

    private static void assertMessageGapAggregateMetricsReset(SegmentGenerationMetrics metrics) {
        SegmentGenerationMetrics.MessageGapStats messageGapStats = metrics.getMessageGapStats();
        Assert.assertEquals((long)0L, (long)messageGapStats.count());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)messageGapStats.max());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)messageGapStats.min());
        Assert.assertEquals((double)Double.NaN, (double)messageGapStats.avg(), (double)0.0);
    }
}

