/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import java.io.IOException;
import java.util.Optional;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FireHydrantTest
extends InitializedNullHandlingTest {
    private IncrementalIndexSegment incrementalIndexSegment;
    private QueryableIndexSegment queryableIndexSegment;
    private FireHydrant hydrant;

    @Before
    public void setup() {
        this.incrementalIndexSegment = new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"test"));
        this.queryableIndexSegment = new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test"));
        this.hydrant = new FireHydrant((Segment)this.incrementalIndexSegment, 0);
    }

    @Test
    public void testAcquireSegmentNotSwapped() {
        Assert.assertEquals((long)0L, (long)this.hydrant.getHydrantSegment().getNumReferences());
        Segment segment = this.hydrant.acquireSegment();
        Assert.assertNotNull((Object)segment);
        Assert.assertSame((Object)this.incrementalIndexSegment, (Object)((ReferenceCountedSegmentProvider.ReferenceClosingSegment)segment).getProvider().getBaseSegment());
        Assert.assertEquals((long)1L, (long)this.hydrant.getHydrantSegment().getNumReferences());
    }

    @Test
    public void testAcquireSegmentSwapped() {
        ReferenceCountedSegmentProvider incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        this.hydrant.swapSegment((Segment)this.queryableIndexSegment);
        Segment segment = this.hydrant.acquireSegment();
        Assert.assertNotNull((Object)segment);
        Assert.assertSame((Object)this.queryableIndexSegment, (Object)((ReferenceCountedSegmentProvider.ReferenceClosingSegment)segment).getProvider().getBaseSegment());
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)1L, (long)this.hydrant.getHydrantSegment().getNumReferences());
    }

    @Test
    public void testAcquireSegmentClosed() {
        this.hydrant.getHydrantSegment().close();
        Assert.assertEquals((long)0L, (long)this.hydrant.getHydrantSegment().getNumReferences());
        Throwable t = Assert.assertThrows(ISE.class, () -> ((FireHydrant)this.hydrant).acquireSegment());
        Assert.assertEquals((Object)"segment.close() is called somewhere outside FireHydrant.swapSegment()", (Object)t.getMessage());
    }

    @Test
    public void testGetSegmentForQuery() throws IOException {
        ReferenceCountedSegmentProvider incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(SegmentMapFunction.IDENTITY);
        Assert.assertTrue((boolean)maybeSegmentAndCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)incrementalSegmentReference.getNumReferences());
        Segment segmentAndCloseable = (Segment)maybeSegmentAndCloseable.get();
        segmentAndCloseable.close();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
    }

    @Test
    public void testGetSegmentForQuerySwapped() throws IOException {
        ReferenceCountedSegmentProvider incrementalSegmentReference = this.hydrant.getHydrantSegment();
        this.hydrant.swapSegment((Segment)this.queryableIndexSegment);
        ReferenceCountedSegmentProvider queryableSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)0L, (long)queryableSegmentReference.getNumReferences());
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(SegmentMapFunction.IDENTITY);
        Assert.assertTrue((boolean)maybeSegmentAndCloseable.isPresent());
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)1L, (long)queryableSegmentReference.getNumReferences());
        Segment segmentAndCloseable = (Segment)maybeSegmentAndCloseable.get();
        segmentAndCloseable.close();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertEquals((long)0L, (long)queryableSegmentReference.getNumReferences());
    }

    @Test
    public void testGetSegmentForQuerySwappedWithNull() {
        ReferenceCountedSegmentProvider incrementalSegmentReference = this.hydrant.getHydrantSegment();
        this.hydrant.swapSegment(null);
        ReferenceCountedSegmentProvider queryableSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertNull((Object)queryableSegmentReference);
        Optional maybeSegmentAndCloseable = this.hydrant.getSegmentForQuery(SegmentMapFunction.IDENTITY);
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        Assert.assertFalse((boolean)maybeSegmentAndCloseable.isPresent());
    }

    @Test
    public void testGetSegmentForQueryButNotAbleToAcquireReferencesSegmentClosed() {
        ReferenceCountedSegmentProvider incrementalSegmentReference = this.hydrant.getHydrantSegment();
        Assert.assertEquals((long)0L, (long)incrementalSegmentReference.getNumReferences());
        incrementalSegmentReference.close();
        Throwable t = Assert.assertThrows(ISE.class, () -> this.hydrant.getSegmentForQuery(SegmentMapFunction.IDENTITY));
        Assert.assertEquals((Object)"segment.close() is called somewhere outside FireHydrant.swapSegment()", (Object)t.getMessage());
    }

    @Test
    public void testToStringWhenSwappedWithNull() {
        this.hydrant.swapSegment(null);
        this.hydrant.toString();
    }
}

