/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.easymock.EasyMock;
import org.mockito.Mockito;

public class TestCoordinatorServerView
extends CoordinatorServerView {
    private static final DruidServer DUMMY_SERVER = new DruidServer("dummy", "dummy", null, 0L, ServerType.HISTORICAL, "dummy", 0);
    private static final DruidServer DUMMY_SERVER_REALTIME = new DruidServer("dummy2", "dummy2", null, 0L, ServerType.INDEXER_EXECUTOR, "dummy", 0);
    private static final DruidServer DUMMY_BROKER = new DruidServer("dummy3", "dummy3", null, 0L, ServerType.BROKER, "dummy", 0);
    private final Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines;
    private Map<Pair<DataSegment, ServerType>, Pair<DruidServerMetadata, SegmentLoadInfo>> segmentInfo;
    private List<DataSegment> segments = new ArrayList<DataSegment>();
    private List<DataSegment> realtimeSegments = new ArrayList<DataSegment>();
    private List<DataSegment> brokerSegments = new ArrayList<DataSegment>();
    private List<Pair<Executor, TimelineServerView.TimelineCallback>> timelineCallbackExecs = new ArrayList<Pair<Executor, TimelineServerView.TimelineCallback>>();

    public TestCoordinatorServerView(List<DataSegment> segments, List<DataSegment> realtimeSegments) {
        super((ServerInventoryView)Mockito.mock(ServerInventoryView.class), (CoordinatorSegmentWatcherConfig)Mockito.mock(CoordinatorSegmentWatcherConfig.class), (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (DirectDruidClientFactory)Mockito.mock(DirectDruidClientFactory.class));
        this.timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        this.segmentInfo = new HashMap<Pair<DataSegment, ServerType>, Pair<DruidServerMetadata, SegmentLoadInfo>>();
        for (DataSegment segment : segments) {
            this.addToTimeline(segment, DUMMY_SERVER);
        }
        for (DataSegment realtimeSegment : realtimeSegments) {
            this.addToTimeline(realtimeSegment, DUMMY_SERVER_REALTIME);
        }
    }

    private DruidServer getServerForType(ServerType serverType) {
        switch (serverType) {
            case BROKER: {
                return DUMMY_BROKER;
            }
            case INDEXER_EXECUTOR: {
                return DUMMY_SERVER_REALTIME;
            }
        }
        return DUMMY_SERVER;
    }

    private void addToTimeline(DataSegment dataSegment, DruidServer druidServer) {
        if (druidServer.getMetadata().getType() == ServerType.INDEXER_EXECUTOR) {
            this.realtimeSegments.add(dataSegment);
        } else if (druidServer.getMetadata().getType() == ServerType.BROKER) {
            this.brokerSegments.add(dataSegment);
        } else {
            this.segments.add(dataSegment);
        }
        SegmentDescriptor segmentDescriptor = dataSegment.getId().toDescriptor();
        SegmentLoadInfo segmentLoadInfo = new SegmentLoadInfo(dataSegment);
        segmentLoadInfo.addServer(druidServer.getMetadata());
        this.segmentInfo.put((Pair<DataSegment, ServerType>)Pair.of((Object)dataSegment, (Object)druidServer.getType()), (Pair<DruidServerMetadata, SegmentLoadInfo>)Pair.of((Object)druidServer.getMetadata(), (Object)segmentLoadInfo));
        TableDataSource tableDataSource = new TableDataSource(dataSegment.getDataSource());
        this.timelines.computeIfAbsent(tableDataSource.getName(), value -> new VersionedIntervalTimeline(Comparator.naturalOrder()));
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.timelines.get(tableDataSource.getName());
        SingleDimensionShardSpec shardSpec = new SingleDimensionShardSpec("dimAll", null, null, 0, Integer.valueOf(1));
        timeline.add(dataSegment.getInterval(), (Object)segmentDescriptor.getVersion(), shardSpec.createChunk((Object)segmentLoadInfo));
    }

    public QueryRunner getQueryRunner(String serverName) {
        return (QueryRunner)EasyMock.mock(QueryRunner.class);
    }

    public VersionedIntervalTimeline<String, SegmentLoadInfo> getTimeline(DataSource dataSource) {
        return this.timelines.get(Iterables.getOnlyElement((Iterable)dataSource.getTableNames()));
    }

    public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
        for (DataSegment segment : this.segments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER.getMetadata(), segment));
        }
        for (DataSegment segment : this.realtimeSegments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER_REALTIME.getMetadata(), segment));
        }
        exec.execute(() -> ((TimelineServerView.TimelineCallback)callback).timelineInitialized());
        this.timelineCallbackExecs.add((Pair<Executor, TimelineServerView.TimelineCallback>)new Pair((Object)exec, (Object)callback));
    }

    public void addSegment(DataSegment segment, ServerType serverType) {
        DruidServer druidServer = this.getServerForType(serverType);
        this.addToTimeline(segment, druidServer);
        this.timelineCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> ((TimelineServerView.TimelineCallback)execAndCallback.rhs).segmentAdded(druidServer.getMetadata(), segment)));
    }

    public void removeSegment(DataSegment segment, ServerType serverType) {
        DruidServerMetadata druidServerMetadata;
        if (serverType == ServerType.BROKER) {
            druidServerMetadata = DUMMY_BROKER.getMetadata();
            this.brokerSegments.remove(segment);
        } else if (serverType == ServerType.INDEXER_EXECUTOR) {
            druidServerMetadata = DUMMY_SERVER_REALTIME.getMetadata();
            this.realtimeSegments.remove(segment);
        } else {
            druidServerMetadata = DUMMY_SERVER.getMetadata();
            this.segments.remove(segment);
        }
        Pair key = Pair.of((Object)segment, (Object)serverType);
        Pair<DruidServerMetadata, SegmentLoadInfo> info = this.segmentInfo.get(key);
        this.segmentInfo.remove(key);
        if (null != info) {
            this.timelines.get(segment.getDataSource()).remove(segment.getInterval(), (Object)"0", new SingleDimensionShardSpec("dimAll", null, null, 0, Integer.valueOf(1)).createChunk((Object)((SegmentLoadInfo)info.rhs)));
        }
        this.timelineCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> {
            ((TimelineServerView.TimelineCallback)execAndCallback.rhs).serverSegmentRemoved(druidServerMetadata, segment);
            if (!(this.segments.contains(segment) || this.brokerSegments.contains(segment) || this.realtimeSegments.remove(segment))) {
                ((TimelineServerView.TimelineCallback)execAndCallback.rhs).segmentRemoved(segment);
            }
        }));
    }

    public void addSegmentSchemas(SegmentSchemas segmentSchemas) {
        this.timelineCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> ((TimelineServerView.TimelineCallback)execAndCallback.rhs).segmentSchemasAnnounced(segmentSchemas)));
    }

    @Nullable
    public List<DruidServer> getInventory() {
        return Lists.newArrayList((Object[])new DruidServer[]{DUMMY_SERVER, DUMMY_SERVER_REALTIME});
    }

    public List<DataSegment> getSegmentsOfServer(DruidServer druidServer) {
        if (druidServer.getType() == ServerType.BROKER) {
            return Lists.newArrayList(this.brokerSegments);
        }
        if (druidServer.getType() == ServerType.INDEXER_EXECUTOR) {
            return Lists.newArrayList(this.realtimeSegments);
        }
        return Lists.newArrayList(this.segments);
    }
}

