/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class SegmentMetadataCacheTestBase
extends InitializedNullHandlingTest {
    public static final String DATASOURCE1 = "foo";
    public static final String DATASOURCE2 = "foo2";
    public static final String DATASOURCE3 = "foo3";
    public static final String SOME_DATASOURCE = "some_datasource";
    public static final String TIMESTAMP_COLUMN = "t";
    private static final InputRowSchema FOO_SCHEMA = new InputRowSchema(new TimestampSpec("t", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"))), null);
    public final List<InputRow> ROWS1 = ImmutableList.of((Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2")));
    public final List<InputRow> ROWS2 = ImmutableList.of((Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-01", (Object)"m1", (Object)"4.0", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-02", (Object)"m1", (Object)"5.0", (Object)"dim2", (Object)ImmutableList.of((Object)"abc"))), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-03", (Object)"m1", (Object)"6.0")));
    public QueryRunnerFactoryConglomerate conglomerate;
    public Closer resourceCloser;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public QueryableIndex index1;
    public QueryableIndex index2;
    public QueryableIndex indexAuto1;
    public QueryableIndex indexAuto2;
    public DataSegment realtimeSegment1;
    public DataSegment segment1;
    public DataSegment segment2;
    public DataSegment segment3;
    public DataSegment segment4;
    public DataSegment segment5;

    public void setUpCommon() {
        this.resourceCloser = Closer.create();
        this.conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate(this.resourceCloser);
    }

    public void setUpData() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        this.index1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows(this.ROWS1).buildMMappedIndex();
        this.index2 = IndexBuilder.create().tmpDir(new File(tmpDir, "2")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("m1", "m1")}).withRollup(false).build()).rows(this.ROWS2).buildMMappedIndex();
        InputRowSchema rowSchema = new InputRowSchema(new TimestampSpec(TIMESTAMP_COLUMN, null, null), DimensionsSpec.builder().useSchemaDiscovery(true).build(), null);
        ImmutableList autoRows1 = ImmutableList.of((Object)this.createRow(ImmutableMap.builder().put((Object)TIMESTAMP_COLUMN, (Object)"2023-01-01T00:00Z").put((Object)"numbery", (Object)Float.valueOf(1.1f)).put((Object)"numberyArrays", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)).put((Object)"stringy", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).put((Object)"array", (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3)).put((Object)"nested", (Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L)).build(), rowSchema));
        ImmutableList autoRows2 = ImmutableList.of((Object)this.createRow(ImmutableMap.builder().put((Object)TIMESTAMP_COLUMN, (Object)"2023-01-02T00:00Z").put((Object)"numbery", (Object)1L).put((Object)"numberyArrays", (Object)ImmutableList.of((Object)3.3, (Object)2.2, (Object)3.1)).put((Object)"stringy", (Object)"a").put((Object)"array", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)).put((Object)"nested", (Object)"hello").build(), rowSchema));
        this.indexAuto1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(rowSchema.getTimestampSpec()).withDimensionsSpec(rowSchema.getDimensionsSpec()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)autoRows1).buildMMappedIndex();
        this.indexAuto2 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(new TimestampSpec(TIMESTAMP_COLUMN, null, null)).withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(true).build()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)autoRows2).buildMMappedIndex();
        this.segment1 = DataSegment.builder().dataSource(DATASOURCE1).interval(Intervals.of((String)"2000/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        this.segment2 = DataSegment.builder().dataSource(DATASOURCE1).interval(Intervals.of((String)"2001/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        this.segment3 = DataSegment.builder().dataSource(DATASOURCE2).interval(this.index2.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        this.segment4 = DataSegment.builder().dataSource(SOME_DATASOURCE).interval(Intervals.of((String)"2023-01-01T00Z/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        this.segment5 = DataSegment.builder().dataSource(SOME_DATASOURCE).interval(Intervals.of((String)"2023-01-02T00Z/P1D")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        this.realtimeSegment1 = DataSegment.builder((SegmentId)SegmentId.of((String)DATASOURCE3, (Interval)Intervals.of((String)"2012/2013"), (String)"version3", null)).shardSpec((ShardSpec)new NumberedShardSpec(2, 3)).dimensions((List)ImmutableList.of((Object)"dim1", (Object)"dim2")).metrics((List)ImmutableList.of((Object)"met1", (Object)"met2")).projections((List)ImmutableList.of((Object)"proj1", (Object)"proj2")).binaryVersion(Integer.valueOf(1)).size(100L).build();
    }

    public void tearDown() throws Exception {
        this.resourceCloser.close();
    }

    public InputRow createRow(ImmutableMap<String, ?> map) {
        return MapInputRowParser.parse((InputRowSchema)FOO_SCHEMA, map);
    }

    InputRow createRow(ImmutableMap<String, ?> map, InputRowSchema inputRowSchema) {
        return MapInputRowParser.parse((InputRowSchema)inputRowSchema, map);
    }

    public QueryLifecycleFactory getQueryLifecycleFactory(QuerySegmentWalker walker) {
        return new QueryLifecycleFactory(this.conglomerate, walker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)new TestRequestLogger(), new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of())));
    }

    public DataSegment newSegment(String datasource, int partitionId) {
        return DataSegment.builder((SegmentId)SegmentId.of((String)datasource, (Interval)Intervals.of((String)"2012/2013"), (String)"version1", (int)partitionId)).shardSpec((ShardSpec)new NumberedShardSpec(partitionId, 0)).dimensions((List)ImmutableList.of((Object)"dim1", (Object)"dim2")).metrics((List)ImmutableList.of((Object)"met1", (Object)"met2")).projections((List)ImmutableList.of((Object)"proj1", (Object)"proj2")).binaryVersion(Integer.valueOf(1)).size(100L).build();
    }
}

