/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorSegmentMetadataCacheConfigTest {
    private static final String CONFIG_BASE = "druid.coordinator.segmentMetadataCache";

    @Test
    public void testDefaultConfig() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, SegmentMetadataCacheConfig.class);
        Properties properties = new Properties();
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        SegmentMetadataCacheConfig config = (SegmentMetadataCacheConfig)provider.get();
        Assert.assertFalse((boolean)config.isAwaitInitializationOnStart());
        Assert.assertEquals((Object)Period.minutes((int)1), (Object)config.getMetadataRefreshPeriod());
        Assert.assertEquals((Object)new AbstractSegmentMetadataCache.LeastRestrictiveTypeMergePolicy(), (Object)config.getMetadataColumnTypeMergePolicy());
    }

    @Test
    public void testCustomizedConfig() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, SegmentMetadataCacheConfig.class);
        Properties properties = new Properties();
        properties.setProperty("druid.coordinator.segmentMetadataCache.metadataColumnTypeMergePolicy", "latestInterval");
        properties.setProperty("druid.coordinator.segmentMetadataCache.metadataRefreshPeriod", "PT2M");
        properties.setProperty("druid.coordinator.segmentMetadataCache.awaitInitializationOnStart", "false");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        SegmentMetadataCacheConfig config = (SegmentMetadataCacheConfig)provider.get();
        Assert.assertFalse((boolean)config.isAwaitInitializationOnStart());
        Assert.assertEquals((Object)Period.minutes((int)2), (Object)config.getMetadataRefreshPeriod());
        Assert.assertEquals((Object)new AbstractSegmentMetadataCache.FirstTypeMergePolicy(), (Object)config.getMetadataColumnTypeMergePolicy());
    }

    private Injector createInjector() {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)CONFIG_BASE, SegmentMetadataCacheConfig.class)));
    }
}

