/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.handoff;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifier;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorBasedSegmentHandoffNotifierTest {
    private final CoordinatorBasedSegmentHandoffNotifierConfig notifierConfig = new CoordinatorBasedSegmentHandoffNotifierConfig(){

        public Duration getPollDuration() {
            return Duration.millis((long)10L);
        }
    };

    @Test
    public void testHandoffCallbackNotCalled() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.isHandoffComplete("test_ds", descriptor)).andReturn((Object)Futures.immediateFuture((Object)false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig, "test_task");
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)Execs.directExecutor(), () -> callbackCalled.set(true));
        notifier.checkForSegmentHandoffs();
        Assert.assertEquals((long)1L, (long)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        Assert.assertFalse((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }

    @Test
    public void testHandoffCallbackCalled() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.isHandoffComplete("test_ds", descriptor)).andReturn((Object)Futures.immediateFuture((Object)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig, "test_task");
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)Execs.directExecutor(), () -> callbackCalled.set(true));
        Assert.assertEquals((long)1L, (long)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        notifier.checkForSegmentHandoffs();
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().isEmpty());
        Assert.assertTrue((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }
}

