/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupSegment;
import org.apache.druid.query.lookup.LookupSegmentTest;
import org.apache.druid.segment.LookupSegmentWrangler;
import org.apache.druid.segment.Segment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LookupSegmentWranglerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final LookupSegmentWrangler factory = new LookupSegmentWrangler(new LookupExtractorFactoryContainerProvider(){

        public Set<String> getAllLookupNames() {
            return ImmutableSet.of((Object)"mylookup");
        }

        public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
            if ("mylookup".equals(lookupName)) {
                return Optional.of(new LookupExtractorFactoryContainer("v0", LookupSegmentTest.LOOKUP_EXTRACTOR_FACTORY));
            }
            return Optional.empty();
        }

        public String getCanonicalLookupName(String lookupName) {
            return lookupName;
        }
    });

    @Test
    public void test_getSegmentsForIntervals_nonLookup() {
        this.expectedException.expect(ClassCastException.class);
        this.expectedException.expectMessage("TableDataSource cannot be cast");
        Iterable ignored = this.factory.getSegmentsForIntervals((DataSource)new TableDataSource("foo"), (Iterable)Intervals.ONLY_ETERNITY);
    }

    @Test
    public void test_getSegmentsForIntervals_lookupThatExists() {
        ImmutableList segments = ImmutableList.copyOf((Iterable)this.factory.getSegmentsForIntervals((DataSource)new LookupDataSource("mylookup"), (Iterable)Intervals.ONLY_ETERNITY));
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertThat((Object)((Segment)Iterables.getOnlyElement((Iterable)segments)), (Matcher)CoreMatchers.instanceOf(LookupSegment.class));
    }

    @Test
    public void test_getSegmentsForIntervals_lookupThatDoesNotExist() {
        ImmutableList segments = ImmutableList.copyOf((Iterable)this.factory.getSegmentsForIntervals((DataSource)new LookupDataSource("nonexistent"), (Iterable)Intervals.ONLY_ETERNITY));
        Assert.assertEquals((long)0L, (long)segments.size());
    }
}

