/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SpecificTaskServiceLocator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class SpecificTaskServiceLocatorTest {
    private static final String TASK_ID = "test-task";
    private static final TaskLocation TASK_LOCATION1 = TaskLocation.create((String)"example.com", (int)-1, (int)9998);
    private static final ServiceLocation SERVICE_LOCATION1 = new ServiceLocation("example.com", -1, 9998, "/druid/worker/v1/chat/test-task");
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private OverlordClient overlordClient;

    @Test
    public void test_locate_noLocationYet() throws Exception {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn(SpecificTaskServiceLocatorTest.status(TaskState.RUNNING, TaskLocation.unknown()));
        TaskStatusResponse response = new TaskStatusResponse(TASK_ID, new TaskStatusPlus(TASK_ID, null, null, DateTimes.nowUtc(), DateTimes.EPOCH, TaskState.RUNNING, null, null, null, TaskLocation.unknown(), null, null));
        Mockito.when((Object)this.overlordClient.taskStatus(TASK_ID)).thenReturn((Object)Futures.immediateFuture((Object)response));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        Assert.assertEquals((Object)ServiceLocations.forLocations(Collections.emptySet()), (Object)future.get());
    }

    @Test
    public void test_locate_taskRunning() throws Exception {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn(SpecificTaskServiceLocatorTest.status(TaskState.RUNNING, TASK_LOCATION1));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        Assert.assertEquals((Object)ServiceLocations.forLocation((ServiceLocation)SERVICE_LOCATION1), (Object)locator.locate().get());
    }

    @Test
    public void test_locate_taskNotFound() throws Exception {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn((Object)Futures.immediateFuture(Collections.singletonMap(TASK_ID, null)));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)future.get());
    }

    @Test
    public void test_locate_taskSuccess() throws Exception {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn(SpecificTaskServiceLocatorTest.status(TaskState.SUCCESS, TaskLocation.unknown()));
        TaskStatusResponse response = new TaskStatusResponse(TASK_ID, new TaskStatusPlus(TASK_ID, null, null, DateTimes.nowUtc(), DateTimes.EPOCH, TaskState.FAILED, null, null, Long.valueOf(100L), TaskLocation.unknown(), null, null));
        Mockito.when((Object)this.overlordClient.taskStatus(TASK_ID)).thenReturn((Object)Futures.immediateFuture((Object)response));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)future.get());
    }

    @Test
    public void test_locate_taskFailed() throws Exception {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn(SpecificTaskServiceLocatorTest.status(TaskState.FAILED, TaskLocation.unknown()));
        TaskStatusResponse response = new TaskStatusResponse(TASK_ID, new TaskStatusPlus(TASK_ID, null, null, DateTimes.nowUtc(), DateTimes.EPOCH, TaskState.FAILED, null, null, Long.valueOf(100L), TaskLocation.unknown(), null, null));
        Mockito.when((Object)this.overlordClient.taskStatus(TASK_ID)).thenReturn((Object)Futures.immediateFuture((Object)response));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)future.get());
    }

    @Test
    public void test_locate_overlordError() {
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn((Object)Futures.immediateFailedFuture((Throwable)new ISE("oh no", new Object[0])));
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
    }

    @Test
    public void test_locate_afterClose() throws Exception {
        SettableFuture overlordFuture = SettableFuture.create();
        Mockito.when((Object)this.overlordClient.taskStatuses(Collections.singleton(TASK_ID))).thenReturn((Object)overlordFuture);
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(TASK_ID, this.overlordClient);
        ListenableFuture future = locator.locate();
        locator.close();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)future.get());
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)locator.locate().get());
        Assert.assertTrue((boolean)overlordFuture.isCancelled());
    }

    private static ListenableFuture<Map<String, TaskStatus>> status(TaskState state, TaskLocation location) {
        TaskStatus status = new TaskStatus(TASK_ID, state, 1L, null, location);
        return Futures.immediateFuture(Collections.singletonMap(TASK_ID, status));
    }
}

