/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import java.net.URI;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class ServiceLocationTest {
    @Test
    public void test_stripBrackets() {
        Assert.assertEquals((Object)"1:2:3:4:5:6:7:8", (Object)ServiceLocation.stripBrackets((String)"[1:2:3:4:5:6:7:8]"));
        Assert.assertEquals((Object)"1:2:3:4:5:6:7:8", (Object)ServiceLocation.stripBrackets((String)"1:2:3:4:5:6:7:8"));
        Assert.assertEquals((Object)"1.2.3.4", (Object)ServiceLocation.stripBrackets((String)"1.2.3.4"));
    }

    @Test
    public void test_fromUri_http() {
        ServiceLocation location = ServiceLocation.fromUri((URI)URI.create("http://example.com:8100/xyz"));
        Assert.assertEquals((Object)"example.com", (Object)location.getHost());
        Assert.assertEquals((long)-1L, (long)location.getTlsPort());
        Assert.assertEquals((long)8100L, (long)location.getPlaintextPort());
        Assert.assertEquals((Object)"/xyz", (Object)location.getBasePath());
    }

    @Test
    public void test_fromUri_https_defaultPort() {
        ServiceLocation location = ServiceLocation.fromUri((URI)URI.create("https://example.com/xyz"));
        Assert.assertEquals((Object)"example.com", (Object)location.getHost());
        Assert.assertEquals((long)443L, (long)location.getTlsPort());
        Assert.assertEquals((long)-1L, (long)location.getPlaintextPort());
        Assert.assertEquals((Object)"/xyz", (Object)location.getBasePath());
    }

    @Test
    public void test_fromUri_https() {
        ServiceLocation location = ServiceLocation.fromUri((URI)URI.create("https://example.com:8100/xyz"));
        Assert.assertEquals((Object)"example.com", (Object)location.getHost());
        Assert.assertEquals((long)8100L, (long)location.getTlsPort());
        Assert.assertEquals((long)-1L, (long)location.getPlaintextPort());
        Assert.assertEquals((Object)"/xyz", (Object)location.getBasePath());
    }

    @Test
    public void test_fromDruidServerMetadata_withPort() {
        DruidServerMetadata druidServerMetadata = new DruidServerMetadata("name", "hostName:9092", null, 1L, ServerType.INDEXER_EXECUTOR, "tier1", 2);
        Assert.assertEquals((Object)new ServiceLocation("hostName", 9092, -1, ""), (Object)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)druidServerMetadata));
    }

    @Test
    public void test_fromDruidServerMetadata_withTlsPort() {
        DruidServerMetadata druidServerMetadata = new DruidServerMetadata("name", null, "hostName:8100", 1L, ServerType.INDEXER_EXECUTOR, "tier1", 2);
        Assert.assertEquals((Object)new ServiceLocation("hostName", -1, 8100, ""), (Object)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)druidServerMetadata));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(ServiceLocation.class).usingGetClass().verify();
    }
}

