/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupSerdeModuleTest {
    private Injector injector;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        this.injector = new CoreInjectorBuilder(new StartupInjectorBuilder().build()).add(new Object[]{new ExpressionModule(), new LookupSerdeModule()}).build();
        this.objectMapper = (ObjectMapper)this.injector.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    @Test
    public void testExpressionVirtualColumnSerde() throws Exception {
        ExpressionVirtualColumn virtualColumn = new ExpressionVirtualColumn("v", "lookup(xxx, 'beep')", ColumnType.STRING, (ExprMacroTable)this.injector.getInstance(ExprMacroTable.class));
        Assert.assertEquals((Object)virtualColumn, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)virtualColumn), VirtualColumn.class));
    }

    @Test
    public void testExtractionDimensionSerde() throws Exception {
        ExtractionDimensionSpec dimensionSpec = new ExtractionDimensionSpec("xxx", "d", (ExtractionFn)new RegisteredLookupExtractionFn(null, "beep", false, null, null, null));
        Assert.assertEquals((Object)dimensionSpec, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)dimensionSpec), DimensionSpec.class));
    }

    @Test
    public void testExtractionFilterSere() throws Exception {
        SelectorDimFilter filter = new SelectorDimFilter("xxx", "d", (ExtractionFn)new RegisteredLookupExtractionFn(null, "beep", false, null, null, null));
        Assert.assertEquals((Object)filter, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)filter), DimFilter.class));
    }

    @Test
    public void testExpressionTransformSerde() throws Exception {
        ExpressionTransform transform = new ExpressionTransform("xxx", "lookup(xxx, 'beep')", (ExprMacroTable)this.injector.getInstance(ExprMacroTable.class));
        Assert.assertEquals((Object)transform, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)transform), ExpressionTransform.class));
    }

    @Test
    public void testGetCanonicalLookupName() {
        LookupExtractorFactoryContainerProvider instance = (LookupExtractorFactoryContainerProvider)this.injector.getInstance(LookupExtractorFactoryContainerProvider.class);
        String lookupName = "lookupName1";
        Assert.assertEquals((Object)lookupName, (Object)instance.getCanonicalLookupName(lookupName));
    }
}

