/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LookupReferencesManagerTest {
    private static final String LOOKUP_TIER = "lookupTier";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    LookupReferencesManager lookupReferencesManager;
    LookupExtractorFactory lookupExtractorFactory;
    LookupExtractorFactoryContainer container;
    ObjectMapper mapper = new DefaultObjectMapper();
    private CoordinatorClientImpl coordinatorClient;
    private LookupListeningAnnouncerConfig config;

    @Before
    public void setUp() throws IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.coordinatorClient = (CoordinatorClientImpl)EasyMock.createMock(CoordinatorClientImpl.class);
        this.config = (LookupListeningAnnouncerConfig)EasyMock.createMock(LookupListeningAnnouncerConfig.class);
        EasyMock.expect((Object)this.config.getLookupLoadingSpec()).andReturn((Object)LookupLoadingSpec.ALL).anyTimes();
        this.lookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);
        this.container = new LookupExtractorFactoryContainer("v0", this.lookupExtractorFactory);
        this.mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, (CoordinatorClient)this.coordinatorClient, this.config, true);
    }

    @Test
    public void testStartStop() throws IOException {
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(null), this.mapper, (CoordinatorClient)this.coordinatorClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForStartStop", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertNull((Object)this.lookupReferencesManager.mainThread);
        Assert.assertNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.start();
        Assert.assertTrue((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertTrue((boolean)this.lookupReferencesManager.mainThread.isAlive());
        Assert.assertNotNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.stop();
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertFalse((boolean)this.lookupReferencesManager.mainThread.isAlive());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetExceptionWhenClosed() {
        this.lookupReferencesManager.get("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testAddExceptionWhenClosed() {
        this.lookupReferencesManager.add("test", (LookupExtractorFactoryContainer)EasyMock.createMock(LookupExtractorFactoryContainer.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testRemoveExceptionWhenClosed() {
        this.lookupReferencesManager.remove("test", null);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetAllLookupsStateExceptionWhenClosed() {
        this.lookupReferencesManager.getAllLookupsState();
    }

    @Test
    public void testAddGetRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForAddGetRemove", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.add("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        this.lookupReferencesManager.remove("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
    }

    @Test
    public void testLoadBadContaineAfterOldGoodContainer() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForAddGetRemove", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.add("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactory badLookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)badLookupExtractorFactory.start()).andReturn((Object)false).anyTimes();
        badLookupExtractorFactory.awaitInitialization();
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException());
        EasyMock.expect((Object)badLookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)badLookupExtractorFactory.isInitialized()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{badLookupExtractorFactory});
        LookupExtractorFactoryContainer badContainer = new LookupExtractorFactoryContainer("0", badLookupExtractorFactory);
        this.lookupReferencesManager.add("test", badContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        this.lookupReferencesManager.remove("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
    }

    @Test
    public void testDropOldContainerAfterNewLoadGoodContainer() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForAddGetRemove", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.add("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactory badLookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)badLookupExtractorFactory.start()).andReturn((Object)false).anyTimes();
        badLookupExtractorFactory.awaitInitialization();
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException());
        EasyMock.expect((Object)badLookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)badLookupExtractorFactory.isInitialized()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{badLookupExtractorFactory});
        LookupExtractorFactoryContainer badContainer = new LookupExtractorFactoryContainer("0", badLookupExtractorFactory);
        this.lookupReferencesManager.remove("test", badContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        this.lookupReferencesManager.remove("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
    }

    @Test
    public void testCloseIsCalledAfterStopping() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForCloseIsCalledAfterStopping", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", new LookupExtractorFactoryContainer("0", lookupExtractorFactory));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testDestroyIsCalledAfterRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForDestroyIsCalledAfterRemove", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        LookupExtractorFactoryContainer container = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", container);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("testMock", container);
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testGetNotThere() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForGetNotThere", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("notThere"));
    }

    @Test
    public void testUpdateWithHigherVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory1.destroy()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory2.isInitialized()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory2.start()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithHigherVersion", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("2", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testUpdateWithLowerVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithLowerVersion", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("0", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testAddingNewContainerImmediatelyWithoutWaiting() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory1.isInitialized()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1});
        HashMap lookupMap = new HashMap();
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertTrue((boolean)this.lookupReferencesManager.get("testName").isPresent());
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1});
    }

    @Test
    public void testRemoveNonExisting() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRemoveNonExisting", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.remove("test", null);
        this.lookupReferencesManager.handlePendingNotices();
    }

    @Test
    public void testGetAllLookupNames() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        HashMap lookupMap = new HashMap();
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("one", container1);
        this.lookupReferencesManager.add("two", container2);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"one", (Object)"two"), (Object)this.lookupReferencesManager.getAllLookupNames());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"one", (Object)"two"), (Object)this.lookupReferencesManager.getAllLookupNames());
    }

    @Test
    public void testGetCanonicalLookupName() {
        String lookupName = "lookupName1";
        Assert.assertEquals((Object)lookupName, (Object)this.lookupReferencesManager.getCanonicalLookupName(lookupName));
    }

    @Test
    public void testGetAllLookupsState() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap lookupMap = new HashMap();
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("one", container1);
        this.lookupReferencesManager.add("two", container2);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("one", container1);
        this.lookupReferencesManager.add("three", container3);
        LookupsState state = this.lookupReferencesManager.getAllLookupsState();
        Assert.assertEquals((long)2L, (long)state.getCurrent().size());
        Assert.assertEquals((Object)container1, state.getCurrent().get("one"));
        Assert.assertEquals((Object)container2, state.getCurrent().get("two"));
        Assert.assertEquals((long)1L, (long)state.getToLoad().size());
        Assert.assertEquals((Object)container3, state.getToLoad().get("three"));
        Assert.assertEquals((long)1L, (long)state.getToDrop().size());
        Assert.assertTrue((boolean)state.getToDrop().contains("one"));
    }

    @Test(timeout=60000L)
    public void testRealModeWithMainThread() throws Exception {
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, (CoordinatorClient)this.coordinatorClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRealModeWithMainThread", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        lookupReferencesManager.start();
        Assert.assertTrue((boolean)lookupReferencesManager.mainThread.isAlive());
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.isInitialized()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        Assert.assertEquals(Optional.empty(), (Object)lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        lookupReferencesManager.add("test", testContainer);
        while (!Optional.of(testContainer).equals(lookupReferencesManager.get("test"))) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test", (Object)"testMockForRealModeWithMainThread"), (Object)lookupReferencesManager.getAllLookupNames());
        lookupReferencesManager.remove("test", null);
        while (lookupReferencesManager.get("test").isPresent()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)"testMockForRealModeWithMainThread"), (Object)lookupReferencesManager.getAllLookupNames());
        lookupReferencesManager.stop();
        Assert.assertFalse((boolean)lookupReferencesManager.mainThread.isAlive());
    }

    @Test
    public void testCoordinatorLookupSync() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testLookup1", container1);
        lookupMap.put("testLookup2", container2);
        lookupMap.put("testLookup3", container3);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.of(container1), (Object)this.lookupReferencesManager.get("testLookup1"));
        Assert.assertEquals(Optional.of(container2), (Object)this.lookupReferencesManager.get("testLookup2"));
        Assert.assertEquals(Optional.of(container3), (Object)this.lookupReferencesManager.get("testLookup3"));
    }

    private Map<String, LookupExtractorFactoryContainer> getLookupMapForSelectiveLoadingOfLookups(LookupLoadingSpec lookupLoadingSpec) throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.reset((Object[])new Object[]{this.coordinatorClient});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testLookup1", container1);
        lookupMap.put("testLookup2", container2);
        lookupMap.put("testLookup3", container3);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER);
        EasyMock.expect((Object)this.config.getLookupLoadingSpec()).andReturn((Object)lookupLoadingSpec);
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        return lookupMap;
    }

    @Test
    public void testCoordinatorLoadAllLookups() throws Exception {
        Map<String, LookupExtractorFactoryContainer> lookupMap = this.getLookupMapForSelectiveLoadingOfLookups(LookupLoadingSpec.ALL);
        for (String lookupName : lookupMap.keySet()) {
            Assert.assertEquals(Optional.of(lookupMap.get(lookupName)), (Object)this.lookupReferencesManager.get(lookupName));
        }
    }

    @Test
    public void testCoordinatorLoadNoLookups() throws Exception {
        Map<String, LookupExtractorFactoryContainer> lookupMap = this.getLookupMapForSelectiveLoadingOfLookups(LookupLoadingSpec.NONE);
        for (String lookupName : lookupMap.keySet()) {
            Assert.assertFalse((boolean)this.lookupReferencesManager.get(lookupName).isPresent());
        }
    }

    @Test
    public void testCoordinatorLoadSubsetOfLookups() throws Exception {
        Map<String, LookupExtractorFactoryContainer> lookupMap = this.getLookupMapForSelectiveLoadingOfLookups(LookupLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"testLookup1", (Object)"testLookup2")));
        Assert.assertEquals(Optional.of(lookupMap.get("testLookup1")), (Object)this.lookupReferencesManager.get("testLookup1"));
        Assert.assertEquals(Optional.of(lookupMap.get("testLookup2")), (Object)this.lookupReferencesManager.get("testLookup2"));
        Assert.assertFalse((boolean)this.lookupReferencesManager.get("testLookup3").isPresent());
    }

    @Test
    public void testAddWithRequiredLoadingSpec() throws Exception {
        LookupLoadingSpec loadingSpec = LookupLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"testLookup1"));
        this.getLookupMapForSelectiveLoadingOfLookups(loadingSpec);
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory(Map.of("key2", "value2"), true));
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.config.getLookupLoadingSpec()).andReturn((Object)loadingSpec);
        EasyMock.replay((Object[])new Object[]{this.config});
        this.lookupReferencesManager.add("testLookup2", container2);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Set.of("testLookup1"), (Object)this.lookupReferencesManager.getAllLookupNames());
    }

    @Test
    public void testAddWithNoneLoadingSpec() throws Exception {
        this.getLookupMapForSelectiveLoadingOfLookups(LookupLoadingSpec.NONE);
        LookupExtractorFactoryContainer container = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory(Map.of("key2", "value2"), true));
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.config.getLookupLoadingSpec()).andReturn((Object)LookupLoadingSpec.NONE);
        EasyMock.replay((Object[])new Object[]{this.config});
        this.lookupReferencesManager.add("testLookup", container);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertTrue((boolean)this.lookupReferencesManager.getAllLookupNames().isEmpty());
    }

    @Test
    public void testLoadLookupOnCoordinatorFailure() throws Exception {
        LookupConfig lookupConfig = new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()){

            public int getCoordinatorRetryDelay() {
                return 10;
            }
        };
        this.lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, (CoordinatorClient)this.coordinatorClient, this.config);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andThrow((Throwable)new RuntimeException()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMockForLoadLookupOnCoordinatorFailure", this.container);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        lookupConfig = new LookupConfig(this.lookupReferencesManager.lookupSnapshotTaker.getPersistFile(LOOKUP_TIER).getParent()){

            public int getCoordinatorRetryDelay() {
                return 10;
            }
        };
        this.lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, (CoordinatorClient)this.coordinatorClient, this.config, true);
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.reset((Object[])new Object[]{this.coordinatorClient});
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.expect((Object)this.config.getLookupLoadingSpec()).andReturn((Object)LookupLoadingSpec.ALL).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andThrow((Throwable)new RuntimeException((Throwable)new HttpResponseException(new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND), StandardCharsets.UTF_8)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinatorClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.of(this.container), (Object)this.lookupReferencesManager.get("testMockForLoadLookupOnCoordinatorFailure"));
    }

    @Test
    public void testDisableLookupSync() throws Exception {
        LookupConfig lookupConfig = new LookupConfig(null){

            public boolean getEnableLookupSyncOnStartup() {
                return false;
            }
        };
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, (CoordinatorClient)this.coordinatorClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForDisableLookupSync", this.container);
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.coordinatorClient.fetchLookupsForTierSync(LOOKUP_TIER)).andReturn(lookupMap);
        lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)lookupReferencesManager.get("testMockForDisableLookupSync"));
    }
}

