/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.cache.HeapMemorySegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.NoopSegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.simulate.BlockingExecutorService;
import org.apache.druid.server.coordinator.simulate.WrappingScheduledExecutorService;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Update;

public class HeapMemorySegmentMetadataCacheTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.enabled((boolean)true));
    private BlockingExecutorService pollExecutor;
    private ScheduledExecutorFactory executorFactory;
    private TestDerbyConnector derbyConnector;
    private StubServiceEmitter serviceEmitter;
    private HeapMemorySegmentMetadataCache cache;
    private SegmentSchemaCache schemaCache;
    private SegmentSchemaTestUtils schemaTestUtils;

    @Before
    public void setup() {
        this.pollExecutor = new BlockingExecutorService("test-poll-exec");
        this.executorFactory = (poolSize, name) -> new WrappingScheduledExecutorService(name, this.pollExecutor, false);
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.serviceEmitter = new StubServiceEmitter();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createSegmentSchemasTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.schemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, this.derbyConnector, TestHelper.JSON_MAPPER);
        EmittingLogger.registerEmitter((ServiceEmitter)this.serviceEmitter);
    }

    @After
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stopBeingLeader();
            this.cache.stop();
        }
    }

    private void setupTargetWithCaching(SegmentMetadataCache.UsageMode cacheMode) {
        this.setupTargetWithCaching(cacheMode, false);
    }

    private void setupTargetWithCaching(SegmentMetadataCache.UsageMode cacheMode, boolean useSchemaCache) {
        if (this.cache != null) {
            throw new ISE("Test target has already been initialized with caching[%s]", new Object[]{this.cache.isEnabled()});
        }
        SegmentsMetadataManagerConfig metadataManagerConfig = new SegmentsMetadataManagerConfig(null, cacheMode, null);
        this.schemaCache = useSchemaCache ? new SegmentSchemaCache() : new NoopSegmentSchemaCache();
        this.cache = new HeapMemorySegmentMetadataCache(TestHelper.JSON_MAPPER, () -> metadataManagerConfig, this.derbyConnectorRule.metadataTablesConfigSupplier(), this.schemaCache, (SQLMetadataConnector)this.derbyConnector, this.executorFactory, (ServiceEmitter)this.serviceEmitter);
    }

    private void setupAndSyncCacheWithSchema() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS, true);
        this.cache.start();
        this.cache.becomeLeader();
        this.syncCacheAfterBecomingLeader();
    }

    private void setupAndSyncCache() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        this.cache.start();
        this.cache.becomeLeader();
        this.syncCacheAfterBecomingLeader();
    }

    private void syncCacheAfterBecomingLeader() {
        this.syncCache();
        this.syncCache();
    }

    private void syncCache() {
        this.serviceEmitter.flush();
        this.pollExecutor.finishNextPendingTasks(2);
    }

    @Test
    public void testStart_schedulesDbPoll_ifCacheIsEnabled() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        Assert.assertTrue((boolean)this.cache.isEnabled());
        this.cache.start();
        Assert.assertTrue((boolean)this.pollExecutor.hasPendingTasks());
        this.syncCache();
        this.serviceEmitter.verifyEmitted("segment/metadataCache/sync/time", 1);
        Assert.assertTrue((boolean)this.pollExecutor.hasPendingTasks());
    }

    @Test
    public void testStart_doesNotScheduleDbPoll_ifCacheIsDisabled() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.NEVER);
        Assert.assertFalse((boolean)this.cache.isEnabled());
        this.cache.start();
        Assert.assertFalse((boolean)this.cache.isEnabled());
        Assert.assertFalse((boolean)this.pollExecutor.hasPendingTasks());
    }

    @Test
    public void testStop_stopsDbPoll_ifCacheIsEnabled() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        Assert.assertTrue((boolean)this.cache.isEnabled());
        this.cache.start();
        Assert.assertTrue((boolean)this.pollExecutor.hasPendingTasks());
        this.cache.stop();
        Assert.assertTrue((boolean)this.pollExecutor.isShutdown());
        Assert.assertFalse((boolean)this.pollExecutor.hasPendingTasks());
    }

    @Test
    public void testBecomeLeader_isNoop_ifCacheIsDisabled() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.NEVER);
        this.cache.start();
        Assert.assertFalse((boolean)this.pollExecutor.hasPendingTasks());
        this.cache.becomeLeader();
        Assert.assertFalse((boolean)this.pollExecutor.hasPendingTasks());
    }

    @Test
    public void testBecomeLeader_throwsException_ifCacheIsStopped() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        DruidExceptionMatcher.defensive().expectMessageIs("Cache has not been started yet").assertThrowsAndMatches(() -> this.cache.becomeLeader());
    }

    @Test
    public void testReadCacheForDataSource_throwsException_ifCacheIsDisabled() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.NEVER);
        DruidExceptionMatcher.defensive().expectMessageIs("Segment metadata cache is not enabled.").assertThrowsAndMatches(() -> this.cache.readCacheForDataSource("wiki", d -> 0));
    }

    @Test
    public void testReadCacheForDataSource_throwsException_ifCacheIsStoppedOrNotLeader() {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        Assert.assertTrue((boolean)this.cache.isEnabled());
        DruidExceptionMatcher.internalServerError().expectMessageIs("Segment metadata cache has not been started yet.").assertThrowsAndMatches(() -> this.cache.readCacheForDataSource("wiki", d -> 0));
        this.cache.start();
        DruidExceptionMatcher.internalServerError().expectMessageIs("Not leader yet. Segment metadata cache is not usable.").assertThrowsAndMatches(() -> this.cache.readCacheForDataSource("wiki", d -> 0));
    }

    @Test(timeout=60000L)
    public void testReadCacheForDataSource_waitsForOneSync_afterBecomingLeader() throws InterruptedException {
        this.setupTargetWithCaching(SegmentMetadataCache.UsageMode.ALWAYS);
        this.cache.start();
        this.cache.becomeLeader();
        ArrayList observedEventOrder = new ArrayList();
        Thread getDatasourceThread = new Thread(() -> {
            this.cache.readCacheForDataSource("wiki", d -> 0);
            observedEventOrder.add("getDatasource completed");
        });
        getDatasourceThread.start();
        Thread.sleep(100L);
        Thread syncCompleteThread = new Thread(() -> {
            observedEventOrder.add("before first sync");
            this.syncCacheAfterBecomingLeader();
        });
        syncCompleteThread.start();
        getDatasourceThread.join();
        syncCompleteThread.join();
        Assert.assertEquals(List.of("before first sync", "getDatasource completed"), observedEventOrder);
        Thread getDatasourceThread2 = new Thread(() -> {
            this.cache.readCacheForDataSource("wiki", d -> 0);
            observedEventOrder.add("getDatasource 2 completed");
        });
        getDatasourceThread2.start();
        getDatasourceThread2.join();
        Assert.assertEquals(List.of("before first sync", "getDatasource completed", "getDatasource 2 completed"), observedEventOrder);
    }

    @Test
    public void testAddSegmentsToCache() {
        this.setupAndSyncCache();
        DataSegmentPlus segment = CreateDataSegments.ofDatasource("wiki").markUsed().asPlus();
        SegmentId segmentId = segment.getDataSegment().getId();
        Assert.assertNull((Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(segmentId)));
        int numInsertedSegments = (Integer)this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(segment)));
        Assert.assertEquals((long)1L, (long)numInsertedSegments);
        Assert.assertEquals((Object)segment.getDataSegment(), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(segmentId)));
    }

    @Test
    public void testSync_addsUsedSegment_ifNotPresentInCache() {
        this.setupAndSyncCache();
        DataSegmentPlus usedSegmentPlus = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
        this.insertSegmentsInMetadataStore(Set.of(usedSegmentPlus));
        Assert.assertTrue((boolean)((Set)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegmentsPlusOverlappingAnyOf(List.of()))).isEmpty());
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/used/stale", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/updated", (Number)1L);
        this.serviceEmitter.verifyValue("segment/used/count", (Number)1L);
        Assert.assertEquals((Object)usedSegmentPlus.getDataSegment(), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(usedSegmentPlus.getDataSegment().getId())));
    }

    @Test
    public void testSync_emitsAlert_ifErrorOccurs() {
        this.setupAndSyncCache();
        this.serviceEmitter.verifyEmitted("segment/metadataCache/sync/time", 1);
        this.derbyConnector.tearDown();
        this.syncCache();
        List alerts = this.serviceEmitter.getAlerts();
        Assert.assertEquals((long)1L, (long)alerts.size());
        Assert.assertEquals((Object)"Could not sync segment metadata cache with metadata store", (Object)((AlertEvent)alerts.get(0)).getDescription());
        this.serviceEmitter.verifyNotEmitted("segment/metadataCache/sync/time");
    }

    @Test
    public void testSync_doesNotFail_ifSegmentRecordIsBad() {
        DataSegmentPlus validSegment = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
        DataSegmentPlus invalidSegment = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
        this.insertSegmentsInMetadataStore(Set.of(validSegment, invalidSegment));
        this.derbyConnectorRule.segments().update("UPDATE %1$s SET id = 'invalid', payload = ? WHERE id = ?", "invalid".getBytes(StandardCharsets.UTF_8), invalidSegment.getDataSegment().getId().toString());
        this.setupAndSyncCache();
        this.serviceEmitter.verifyEmitted("segment/metadataCache/sync/time", 1);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/skipped", (Number)1L);
        Assert.assertNull((Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(invalidSegment.getDataSegment().getId())));
        Assert.assertEquals((Object)validSegment.getDataSegment(), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(validSegment.getDataSegment().getId())));
    }

    @Test
    public void testSync_doesNotFail_ifPendingSegmentRecordIsBad() {
        this.derbyConnector.retryWithHandle(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload)", (Object[])new Object[]{((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getPendingSegmentsTable(), this.derbyConnector.getQuoteString()})).bind("id", "1")).bind("dataSource", "wiki")).bind("created_date", "1")).bind("start", "-start-")).bind("end", "-end-")).bind("sequence_name", "s1")).bind("sequence_prev_id", "")).bind("sequence_name_prev_id_sha1", "abcdef")).bind("payload", new byte[0])).execute());
        DataSegmentPlus segment = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
        this.insertSegmentsInMetadataStore(Set.of(segment));
        this.setupAndSyncCache();
        this.serviceEmitter.verifyEmitted("segment/metadataCache/sync/time", 1);
        this.serviceEmitter.verifyValue("segment/metadataCache/pending/skipped", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/pending/count", (Number)0L);
        Assert.assertEquals((Object)segment.getDataSegment(), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(segment.getDataSegment().getId())));
        Assert.assertTrue((boolean)((List)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findPendingSegmentsOverlapping(Intervals.ETERNITY))).isEmpty());
    }

    @Test
    public void testSync_updatesUsedSegment_ifCacheHasOlderEntry() {
        this.setupAndSyncCache();
        DateTime updateTime = DateTimes.nowUtc();
        DataSegmentPlus usedSegmentPlus = CreateDataSegments.ofDatasource("wiki").markUsed().lastUpdatedOn(updateTime).asPlus();
        this.insertSegmentsInMetadataStore(Set.of(usedSegmentPlus));
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(usedSegmentPlus)));
        Assert.assertEquals(Set.of(usedSegmentPlus), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegmentsPlusOverlappingAnyOf(List.of())));
        DataSegmentPlus updatedSegment = new DataSegmentPlus(usedSegmentPlus.getDataSegment(), usedSegmentPlus.getCreatedDate(), updateTime.plus(1L), Boolean.valueOf(true), null, null, null);
        this.updateSegmentInMetadataStore(updatedSegment);
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/stale", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/updated", (Number)1L);
        Assert.assertEquals(Set.of(updatedSegment), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegmentsPlusOverlappingAnyOf(List.of())));
    }

    @Test
    public void testSync_removesUsedSegment_ifNotPresentInMetadataStore() {
        this.setupAndSyncCache();
        DataSegmentPlus unpersistedSegmentPlus = CreateDataSegments.ofDatasource("wiki").markUsed().asPlus();
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(unpersistedSegmentPlus)));
        DataSegment unpersistedSegment = unpersistedSegmentPlus.getDataSegment();
        Assert.assertEquals((Object)unpersistedSegment, (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(unpersistedSegment.getId())));
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/deleted", (Number)1L);
        this.serviceEmitter.verifyNotEmitted("segment/used/count");
        Assert.assertNull((Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findUsedSegment(unpersistedSegment.getId())));
    }

    @Test
    public void testSync_removesUnusedSegment_ifCacheHasOlderEntry() {
        this.setupAndSyncCache();
        DateTime now = DateTimes.nowUtc();
        DataSegmentPlus unpersistedSegmentPlus = CreateDataSegments.ofDatasource("wiki").markUsed().asPlus();
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(unpersistedSegmentPlus)));
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.markSegmentAsUnused(unpersistedSegmentPlus.getDataSegment().getId(), now.minusMinutes(1)));
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/deleted", (Number)1L);
        this.serviceEmitter.verifyNotEmitted("segment/used/count");
        this.serviceEmitter.verifyNotEmitted("segment/metadataCache/used/count");
        this.serviceEmitter.verifyNotEmitted("segment/metadataCache/unused/count");
    }

    @Test
    public void testSync_doesNotRemoveIntervalWithOnlyUnusedSegments() {
        this.setupAndSyncCache();
        DataSegmentPlus usedSegment = CreateDataSegments.ofDatasource("wiki").updatedNow().markUsed().asPlus();
        DateTime now = DateTimes.nowUtc();
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(usedSegment)));
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.markSegmentAsUnused(usedSegment.getDataSegment().getId(), now.plusMinutes(1)));
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/unused/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/interval/count", (Number)1L);
        this.serviceEmitter.flush();
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/unused/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/interval/count", (Number)1L);
    }

    @Test
    public void testSync_addsPendingSegment_ifNotPresentInCache() {
        this.setupAndSyncCache();
        PendingSegmentRecord pendingSegment = HeapMemorySegmentMetadataCacheTest.createPendingSegment(DateTimes.nowUtc());
        this.derbyConnectorRule.pendingSegments().insert(List.of(pendingSegment), false, TestHelper.JSON_MAPPER);
        SegmentIdWithShardSpec segmentId = pendingSegment.getId();
        Assert.assertTrue((boolean)((List)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findPendingSegmentIdsWithExactInterval(pendingSegment.getSequenceName(), segmentId.getInterval()))).isEmpty());
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/pending/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/pending/updated", (Number)1L);
        Assert.assertEquals(List.of(segmentId), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findPendingSegmentIdsWithExactInterval(pendingSegment.getSequenceName(), segmentId.getInterval())));
    }

    @Test
    public void testSync_removesPendingSegment_ifNotPresentInMetadataStore() {
        this.setupAndSyncCache();
        PendingSegmentRecord pendingSegment = HeapMemorySegmentMetadataCacheTest.createPendingSegment(DateTimes.nowUtc().minusHours(1));
        this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertPendingSegment(pendingSegment, false));
        SegmentIdWithShardSpec segmentId = pendingSegment.getId();
        Assert.assertEquals(List.of(segmentId), (Object)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findPendingSegmentIdsWithExactInterval(pendingSegment.getSequenceName(), segmentId.getInterval())));
        this.syncCache();
        this.serviceEmitter.verifyNotEmitted("segment/pending/count");
        this.serviceEmitter.verifyValue("segment/metadataCache/pending/deleted", (Number)1L);
        Assert.assertTrue((boolean)((List)this.cache.readCacheForDataSource("wiki", wikiCache -> wikiCache.findPendingSegmentIdsWithExactInterval(pendingSegment.getSequenceName(), segmentId.getInterval()))).isEmpty());
    }

    @Test
    public void testSync_cleansUpDataSourceCache_ifEmptyAndNotInUse() {
        this.setupAndSyncCache();
        DateTime now = DateTimes.nowUtc();
        DataSegmentPlus segment = CreateDataSegments.ofDatasource("wiki").markUsed().lastUpdatedOn(now.minusHours(1)).asPlus();
        int numInsertedSegments = (Integer)this.cache.writeCacheForDataSource("wiki", wikiCache -> wikiCache.insertSegments(Set.of(segment)));
        Assert.assertEquals((long)1L, (long)numInsertedSegments);
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/metadataCache/deleted", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/dataSource/deleted", (Number)1L);
    }

    @Test
    public void test_sync_addsUsedSegmentSchema_ifNotPresentInCache() {
        this.setupAndSyncCacheWithSchema();
        Assert.assertTrue((boolean)this.schemaCache.getPublishedSchemaPayloadMap().isEmpty());
        SchemaPayload payload = new SchemaPayload(RowSignature.builder().add("col1", null).build());
        String fingerprint = HeapMemorySegmentMetadataCacheTest.getSchemaFingerprint(payload);
        this.schemaTestUtils.insertSegmentSchema("wiki", Map.of(fingerprint, payload), Set.of(fingerprint));
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/schemaCache/usedFingerprint/count", (Number)1L);
        Assert.assertEquals(Map.of(fingerprint, payload), (Object)this.schemaCache.getPublishedSchemaPayloadMap());
    }

    @Test
    public void test_sync_removesUsedSegmentSchema_ifNotPresentInMetadataStore() {
        this.setupAndSyncCacheWithSchema();
        SchemaPayload payload = new SchemaPayload(RowSignature.builder().add("col1", null).build());
        String fingerprint = HeapMemorySegmentMetadataCacheTest.getSchemaFingerprint(payload);
        this.schemaCache.resetSchemaForPublishedSegments(Map.of(), Map.of(fingerprint, payload));
        Assert.assertEquals(Map.of(fingerprint, payload), (Object)this.schemaCache.getPublishedSchemaPayloadMap());
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/schemaCache/usedFingerprint/count", (Number)0L);
        Assert.assertTrue((boolean)this.schemaCache.getPublishedSchemaPayloadMap().isEmpty());
    }

    @Test
    public void test_sync_addsUsedSegmentMetadata_ifNotPresentInCache() {
        this.setupAndSyncCacheWithSchema();
        Assert.assertTrue((boolean)this.schemaCache.getPublishedSegmentMetadataMap().isEmpty());
        SchemaPayload payload = new SchemaPayload(RowSignature.builder().add("col1", null).build());
        String fingerprint = HeapMemorySegmentMetadataCacheTest.getSchemaFingerprint(payload);
        DataSegmentPlus usedSegmentPlus = CreateDataSegments.ofDatasource("wiki").withNumRows(10L).withSchemaFingerprint(fingerprint).updatedNow().markUsed().asPlus();
        this.insertSegmentsInMetadataStoreWithSchema(usedSegmentPlus);
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/count", (Number)1L);
        this.serviceEmitter.verifyValue("segment/metadataCache/used/updated", (Number)1L);
        this.serviceEmitter.verifyValue("segment/schemaCache/used/count", (Number)1L);
        Assert.assertEquals(Map.of(usedSegmentPlus.getDataSegment().getId(), new SegmentMetadata(Long.valueOf(10L), fingerprint)), (Object)this.schemaCache.getPublishedSegmentMetadataMap());
    }

    @Test
    public void test_sync_removesUsedSegmentMetadata_ifNotPresentInMetadataStore() {
        this.setupAndSyncCacheWithSchema();
        SchemaPayload payload = new SchemaPayload(RowSignature.builder().add("col1", null).build());
        String fingerprint = HeapMemorySegmentMetadataCacheTest.getSchemaFingerprint(payload);
        SegmentId segmentId = SegmentId.dummy((String)"wiki");
        SegmentMetadata metadata = new SegmentMetadata(Long.valueOf(10L), fingerprint);
        this.schemaCache.resetSchemaForPublishedSegments(Map.of(segmentId, metadata), Map.of());
        Assert.assertEquals(Map.of(segmentId, metadata), (Object)this.schemaCache.getPublishedSegmentMetadataMap());
        this.syncCache();
        this.serviceEmitter.verifyValue("segment/schemaCache/used/count", (Number)0L);
        Assert.assertTrue((boolean)this.schemaCache.getPublishedSegmentMetadataMap().isEmpty());
    }

    private static String getSchemaFingerprint(SchemaPayload payload) {
        return new FingerprintGenerator(TestHelper.JSON_MAPPER).generateFingerprint(payload, "wiki", 1);
    }

    private void insertSegmentsInMetadataStore(Set<DataSegmentPlus> segments) {
        IndexerSqlMetadataStorageCoordinatorTestBase.insertSegments(segments, false, this.derbyConnectorRule, TestHelper.JSON_MAPPER);
    }

    private void insertSegmentsInMetadataStoreWithSchema(DataSegmentPlus ... segments) {
        IndexerSqlMetadataStorageCoordinatorTestBase.insertSegments(Set.of(segments), true, this.derbyConnectorRule, TestHelper.JSON_MAPPER);
    }

    private void updateSegmentInMetadataStore(DataSegmentPlus segment) {
        int updatedRows = this.derbyConnectorRule.segments().update("UPDATE %1$s SET used = ?, used_status_last_updated = ? WHERE id = ?", Boolean.TRUE.equals(segment.getUsed()), segment.getUsedStatusLastUpdatedDate().toString(), segment.getDataSegment().getId().toString());
        Assert.assertEquals((long)1L, (long)updatedRows);
    }

    private static PendingSegmentRecord createPendingSegment(DateTime createdTime) {
        SegmentIdWithShardSpec segmentId = new SegmentIdWithShardSpec("wiki", Intervals.of((String)"2021-01-01/P1D"), "v1", (ShardSpec)new NumberedShardSpec(0, 1));
        return new PendingSegmentRecord(segmentId, "sequence1", null, null, "allocator1", createdTime);
    }
}

