/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import java.util.List;
import java.util.Set;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.segment.cache.CacheStats;
import org.apache.druid.metadata.segment.cache.HeapMemoryDatasourceSegmentCache;
import org.apache.druid.metadata.segment.cache.SegmentRecord;
import org.apache.druid.metadata.segment.cache.SegmentSyncResult;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HeapMemoryDatasourceSegmentCacheTest {
    private static final String WIKI = "wiki";
    private static final Interval FIRST_WEEK_OF_JAN = Intervals.of((String)"2024-01-01/P1W");
    private static final Interval FIRST_DAY_OF_JAN = FIRST_WEEK_OF_JAN.withDurationAfterStart((ReadableDuration)Duration.standardDays((long)1L));
    private static final DataSegmentPlus JAN_1_SEGMENT = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().startingAt(FIRST_DAY_OF_JAN.getStart()).withVersion("v1").asPlus();
    private static final DataSegmentPlus JAN_2_SEGMENT = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().startingAt(FIRST_DAY_OF_JAN.getEnd()).withVersion("v2").asPlus();
    private static final DataSegmentPlus JAN_3_SEGMENT = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().startingAt(FIRST_DAY_OF_JAN.getEnd().plusDays(1)).withVersion("v3").asPlus();
    private HeapMemoryDatasourceSegmentCache cache;

    @Before
    public void setup() {
        this.cache = new HeapMemoryDatasourceSegmentCache(WIKI);
    }

    @Test
    public void testEmptyCache() {
        Assert.assertNull((Object)this.cache.findUsedSegment(SegmentId.dummy((String)WIKI)));
        Assert.assertTrue((boolean)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()).isEmpty());
        Assert.assertTrue((boolean)this.cache.findPendingSegmentsOverlapping(Intervals.ETERNITY).isEmpty());
    }

    @Test
    public void testFindSegment_throwsUnsupported() {
        DruidExceptionMatcher.defensive().expectMessageIs("Unsupported: Unused segments are not cached").assertThrowsAndMatches(() -> this.cache.findSegment(SegmentId.dummy((String)WIKI)));
    }

    @Test
    public void testFindUnusedSegments_throwsUnsupported() {
        DruidExceptionMatcher.defensive().expectMessageIs("Unsupported: Unused segments are not cached").assertThrowsAndMatches(() -> this.cache.findUnusedSegments(null, null, null, null));
    }

    @Test
    public void testFindSegments_throwsUnsupported() {
        DruidExceptionMatcher.defensive().expectMessageIs("Unsupported: Unused segments are not cached").assertThrowsAndMatches(() -> this.cache.findSegments(Set.of()));
    }

    @Test
    public void testFindSegmentsWithSchema_throwsUnsupported() {
        DruidExceptionMatcher.defensive().expectMessageIs("Unsupported: Unused segments are not cached").assertThrowsAndMatches(() -> this.cache.findSegmentsWithSchema(Set.of()));
    }

    @Test
    public void testFindExistingSegmentIds_throwsUnsupported() {
        DruidExceptionMatcher.defensive().expectMessageIs("Unsupported: Unused segments are not cached").assertThrowsAndMatches(() -> this.cache.findExistingSegmentIds(Set.of()));
    }

    @Test
    public void testInsertSegments_withUsedSegment() {
        DataSegmentPlus segmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().asPlus();
        DataSegment segment = segmentPlus.getDataSegment();
        this.cache.insertSegments(Set.of(segmentPlus));
        SegmentId segmentId = segment.getId();
        Interval interval = segmentId.getInterval();
        Assert.assertEquals((Object)segment, (Object)this.cache.findUsedSegment(segmentId));
        Assert.assertEquals(List.of(segmentPlus), (Object)this.cache.findUsedSegments(Set.of(segmentId)));
        Assert.assertEquals(Set.of(segmentId), (Object)this.cache.findUsedSegmentIdsOverlapping(interval));
        Assert.assertEquals(Set.of(segmentId), (Object)this.cache.findUsedSegmentIdsOverlapping(Intervals.ETERNITY));
        Assert.assertEquals(Set.of(segment), (Object)this.cache.findUsedSegmentsOverlappingAnyOf(List.of()));
        Assert.assertEquals(Set.of(segment), (Object)this.cache.findUsedSegmentsOverlappingAnyOf(List.of(interval)));
        Assert.assertEquals(Set.of(segment), (Object)this.cache.findUsedSegmentsOverlappingAnyOf(List.of(Intervals.ETERNITY)));
        Assert.assertEquals(Set.of(segmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
        Assert.assertEquals(Set.of(segmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(interval)));
        Assert.assertEquals(Set.of(segmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(Intervals.ETERNITY)));
    }

    @Test
    public void testInsertSegments_updatesCacheWithNewerEntry() {
        DateTime now = DateTimes.nowUtc();
        DataSegmentPlus segmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().lastUpdatedOn(now).asPlus();
        Assert.assertEquals((long)1L, (long)this.cache.insertSegments(Set.of(segmentPlus)));
        Assert.assertEquals(Set.of(segmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
        DataSegmentPlus oldSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.updateSegment(segmentPlus, now.minus(1L));
        Assert.assertEquals((long)0L, (long)this.cache.insertSegments(Set.of(oldSegmentPlus)));
        Assert.assertEquals(Set.of(segmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
        DataSegmentPlus newSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.updateSegment(segmentPlus, now.plus(1L));
        Assert.assertEquals((long)1L, (long)this.cache.insertSegments(Set.of(newSegmentPlus)));
        Assert.assertEquals(Set.of(newSegmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
    }

    @Test
    public void testInsertSegments_withUnusedSegment() {
        DataSegmentPlus segmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().asPlus();
        DataSegment segment = segmentPlus.getDataSegment();
        SegmentId segmentId = segment.getId();
        this.cache.insertSegments(Set.of(segmentPlus));
        Assert.assertNull((Object)this.cache.findUsedSegment(segmentId));
        Assert.assertTrue((boolean)this.cache.findUsedSegments(Set.of(segmentId)).isEmpty());
        Assert.assertTrue((boolean)this.cache.findUsedSegmentIdsOverlapping(segment.getInterval()).isEmpty());
        Assert.assertTrue((boolean)this.cache.findUsedSegmentsOverlappingAnyOf(List.of()).isEmpty());
        Assert.assertTrue((boolean)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()).isEmpty());
        CacheStats cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)0L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUnusedSegments());
    }

    @Test
    public void testInsertSegments_addsToCache_ifUpdatedTimeIsNull() {
        DataSegmentPlus usedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().lastUpdatedOn(null).asPlus();
        Assert.assertEquals((long)1L, (long)this.cache.insertSegments(Set.of(usedSegmentPlus)));
        Assert.assertEquals(Set.of(usedSegmentPlus), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
    }

    @Test
    public void testInsertSegments_doesNotUpdateCache_ifNewUpdatedTimeIsNull() {
        DataSegmentPlus usedSegment = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().lastUpdatedOn(null).asPlus();
        Assert.assertEquals((long)1L, (long)this.cache.insertSegments(Set.of(usedSegment)));
        Assert.assertEquals((long)0L, (long)this.cache.insertSegments(Set.of(HeapMemoryDatasourceSegmentCacheTest.updateSegment(usedSegment, null))));
    }

    @Test
    public void testInsertSegments_canMarkItAsUnused() {
        DataSegmentPlus unusedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().asPlus();
        DataSegment segment = unusedSegmentPlus.getDataSegment();
        SegmentId segmentId = segment.getId();
        this.cache.insertSegments(Set.of(unusedSegmentPlus));
        Assert.assertNull((Object)this.cache.findUsedSegment(segmentId));
        DataSegmentPlus usedSegmentPlus = new DataSegmentPlus(segment, null, DateTimes.EPOCH, Boolean.valueOf(true), null, null, null);
        this.cache.insertSegments(Set.of(usedSegmentPlus));
        Assert.assertEquals((Object)segment, (Object)this.cache.findUsedSegment(segmentId));
    }

    @Test
    public void testSyncSegmentIds_identifiesExpiredUsedSegmentIds() {
        DataSegmentPlus usedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().updatedNow().asPlus();
        SegmentRecord usedRecord = HeapMemoryDatasourceSegmentCacheTest.asRecord(usedSegmentPlus);
        DateTime now = DateTimes.nowUtc();
        SegmentSyncResult result = this.cache.syncSegmentIds(List.of(usedRecord), now);
        Assert.assertEquals(Set.of(usedRecord.getSegmentId()), (Object)result.getExpiredIds());
    }

    @Test
    public void testSyncSegmentIds_ignoresUnusedSegment() {
        DataSegmentPlus unusedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().updatedNow().asPlus();
        SegmentRecord unusedRecord = HeapMemoryDatasourceSegmentCacheTest.asRecord(unusedSegmentPlus);
        DateTime now = DateTimes.nowUtc();
        SegmentSyncResult result = this.cache.syncSegmentIds(List.of(unusedRecord), now);
        Assert.assertEquals((long)0L, (long)result.getUpdated());
        Assert.assertEquals((long)0L, (long)result.getDeleted());
        Assert.assertTrue((boolean)result.getExpiredIds().isEmpty());
    }

    @Test
    public void testInsertPendingSegment() {
        PendingSegmentRecord pendingSegment = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequenceName", null, null, (String)"allocatorId");
        Assert.assertTrue((boolean)this.cache.insertPendingSegment(pendingSegment, false));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegments("allocatorId"));
        Assert.assertEquals(List.of(pendingSegment.getId()), (Object)this.cache.findPendingSegmentIds("sequenceName", ""));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegmentsOverlapping(FIRST_WEEK_OF_JAN.withDurationAfterStart((ReadableDuration)Duration.standardHours((long)1L))));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegmentsWithExactInterval(FIRST_WEEK_OF_JAN));
        Assert.assertEquals(List.of(pendingSegment.getId()), (Object)this.cache.findPendingSegmentIdsWithExactInterval("sequenceName", FIRST_WEEK_OF_JAN));
    }

    @Test
    public void testInsertPendingSegment_doesNotUpdateEntry() {
        DateTime now = DateTimes.nowUtc();
        PendingSegmentRecord pendingSegment = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 1)), "sequenceName", null, null, "allocatorId", now);
        Assert.assertTrue((boolean)this.cache.insertPendingSegment(pendingSegment, false));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegments(pendingSegment.getTaskAllocatorId()));
        PendingSegmentRecord updatedPendingSegment = new PendingSegmentRecord(pendingSegment.getId(), pendingSegment.getSequenceName(), pendingSegment.getSequencePrevId(), pendingSegment.getUpgradedFromSegmentId(), pendingSegment.getTaskAllocatorId(), now.plusDays(1));
        Assert.assertFalse((boolean)this.cache.insertPendingSegment(updatedPendingSegment, false));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegments(pendingSegment.getTaskAllocatorId()));
    }

    @Test
    public void testInsertPendingSegments() {
        PendingSegmentRecord segment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord segment2 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(1, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord segment3 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequenceName", null, null, (String)"group2");
        Assert.assertEquals((long)3L, (long)this.cache.insertPendingSegments(List.of(segment1, segment2, segment3), false));
    }

    @Test
    public void testInsertPendingSegment_isIdempotent() {
        PendingSegmentRecord pendingSegment = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, Intervals.ETERNITY, "v1", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"s1", null, null, null);
        Assert.assertTrue((boolean)this.cache.insertPendingSegment(pendingSegment, true));
        Assert.assertFalse((boolean)this.cache.insertPendingSegment(pendingSegment, true));
        Assert.assertEquals(List.of(pendingSegment), (Object)this.cache.findPendingSegmentsOverlapping(Intervals.ETERNITY));
    }

    @Test
    public void testSyncSegmentIds_removesUsedSegmentUpdatedBeforeSyncStart() {
        DateTime syncTime = DateTimes.nowUtc();
        DataSegmentPlus persistedSegment = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().asPlus();
        DataSegmentPlus unpersistedSegmentUpdatedBeforeSync = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().lastUpdatedOn(syncTime.minus(1L)).asPlus();
        DataSegmentPlus unpersistedSegmentUpdatedAfterSync = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().lastUpdatedOn(syncTime.plus(1L)).asPlus();
        Set<DataSegmentPlus> allSegments = Set.of(persistedSegment, unpersistedSegmentUpdatedBeforeSync, unpersistedSegmentUpdatedAfterSync);
        this.cache.insertSegments(allSegments);
        Assert.assertEquals(allSegments, (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
        this.cache.syncSegmentIds(List.of(HeapMemoryDatasourceSegmentCacheTest.asRecord(persistedSegment)), syncTime);
        Assert.assertEquals(Set.of(persistedSegment, unpersistedSegmentUpdatedAfterSync), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of()));
    }

    @Test
    public void testSyncSegmentIds_removesUnusedSegmentUpdatedBeforeSyncStart() {
        DateTime syncTime = DateTimes.nowUtc();
        DataSegmentPlus usedSegment = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().asPlus();
        DataSegmentPlus unusedSegmentUpdatedBeforeSync = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().lastUpdatedOn(syncTime.minus(1L)).asPlus();
        DataSegmentPlus unusedSegmentUpdatedAfterSync = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().lastUpdatedOn(syncTime.plus(1L)).asPlus();
        this.cache.insertSegments(Set.of(usedSegment, unusedSegmentUpdatedBeforeSync, unusedSegmentUpdatedAfterSync));
        CacheStats cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)2L, (long)cacheStats.getNumUnusedSegments());
        this.cache.syncSegmentIds(List.of(HeapMemoryDatasourceSegmentCacheTest.asRecord(usedSegment)), syncTime);
        cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUnusedSegments());
    }

    @Test
    public void testSyncPendingSegments_removesPendingSegmentCreatedbeforeSyncStart() {
        DateTime syncTime = DateTimes.nowUtc();
        String taskAllocator = "allocator1";
        PendingSegmentRecord persistedSegment = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 2)), "sequenceName", null, null, "allocator1", null);
        PendingSegmentRecord unpersistedSegmentCreatedBeforeSync = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(1, 2)), "sequenceName", null, null, "allocator1", syncTime.minus(1L));
        PendingSegmentRecord unpersistedSegmentCreatedAfterSync = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), "sequenceName", null, null, "allocator1", syncTime.plus(1L));
        List<PendingSegmentRecord> allSegments = List.of(persistedSegment, unpersistedSegmentCreatedBeforeSync, unpersistedSegmentCreatedAfterSync);
        this.cache.insertPendingSegments(allSegments, false);
        Assert.assertEquals(Set.copyOf(allSegments), Set.copyOf(this.cache.findPendingSegments("allocator1")));
        this.cache.syncPendingSegments(List.of(persistedSegment), syncTime);
        Assert.assertEquals(Set.of(persistedSegment, unpersistedSegmentCreatedAfterSync), Set.copyOf(this.cache.findPendingSegments("allocator1")));
    }

    @Test
    public void testDeleteSegments() {
        DataSegmentPlus usedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUsedSegment().asPlus();
        SegmentId usedSegmentId = usedSegmentPlus.getDataSegment().getId();
        DataSegmentPlus unusedSegmentPlus = HeapMemoryDatasourceSegmentCacheTest.createUnusedSegment().withVersion("v1").asPlus();
        SegmentId unusedSegmentId = unusedSegmentPlus.getDataSegment().getId();
        this.cache.insertSegments(Set.of(usedSegmentPlus, unusedSegmentPlus));
        Assert.assertEquals(List.of(usedSegmentPlus), (Object)this.cache.findUsedSegments(Set.of(usedSegmentId)));
        CacheStats cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUnusedSegments());
        Assert.assertFalse((boolean)this.cache.isEmpty());
        Assert.assertEquals((long)2L, (long)this.cache.deleteSegments(Set.of(usedSegmentId, unusedSegmentId)));
        cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)0L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)0L, (long)cacheStats.getNumUnusedSegments());
        Assert.assertTrue((boolean)this.cache.isEmpty());
    }

    @Test
    public void testDeleteSegments_forEmptyOrAbsentIdsReturnsZero() {
        Assert.assertEquals((long)0L, (long)this.cache.deleteSegments(Set.of()));
        Assert.assertEquals((long)0L, (long)this.cache.deleteSegments(Set.of(SegmentId.dummy((String)WIKI))));
    }

    @Test
    public void testDeletePendingSegments_byTaskAllocatorId() {
        PendingSegmentRecord group1PendingSegment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord group1PendingSegment2 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(1, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord group2PendingSegment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequenceName", null, null, (String)"group2");
        this.cache.insertPendingSegments(List.of(group1PendingSegment1, group1PendingSegment2, group2PendingSegment1), false);
        Assert.assertEquals((long)2L, (long)this.cache.deletePendingSegments("group1"));
        Assert.assertTrue((boolean)this.cache.findPendingSegments("group1").isEmpty());
        Assert.assertEquals(List.of(group2PendingSegment1), (Object)this.cache.findPendingSegments("group2"));
    }

    @Test
    public void testDeletePendingSegments_bySegmentIds() {
        PendingSegmentRecord segment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord segment2 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(1, 2)), (String)"sequenceName", null, null, (String)"group1");
        PendingSegmentRecord segment3 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequenceName", null, null, (String)"group1");
        this.cache.insertPendingSegments(List.of(segment1, segment2, segment3), false);
        Assert.assertEquals((long)2L, (long)this.cache.deletePendingSegments(Set.of(segment1.getId().toString(), segment2.getId().toString())));
        Assert.assertEquals(List.of(segment3), (Object)this.cache.findPendingSegments("group1"));
    }

    @Test
    public void testDeleteAllPendingSegments() {
        PendingSegmentRecord segment1 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v1", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequence1", null, null, (String)"group1");
        PendingSegmentRecord segment2 = PendingSegmentRecord.create((SegmentIdWithShardSpec)new SegmentIdWithShardSpec(WIKI, FIRST_WEEK_OF_JAN, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), (String)"sequence2", null, null, (String)"group2");
        this.cache.insertPendingSegments(List.of(segment1, segment2), true);
        Assert.assertEquals((long)2L, (long)this.cache.deleteAllPendingSegments());
        Assert.assertTrue((boolean)this.cache.findPendingSegmentsOverlapping(FIRST_WEEK_OF_JAN).isEmpty());
    }

    @Test
    public void testDeletePendingSegmentsCreatedIn() {
        Interval firstWeekOfJan = Intervals.of((String)"2024-01-01/P1W");
        PendingSegmentRecord segment1 = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, firstWeekOfJan, "v1", (ShardSpec)new NumberedShardSpec(0, 2)), "sequenceName", null, null, "group1", firstWeekOfJan.getStart().plusDays(2));
        PendingSegmentRecord segment2 = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, firstWeekOfJan, "v1", (ShardSpec)new NumberedShardSpec(1, 2)), "sequenceName", null, null, "group1", firstWeekOfJan.getEnd().plusDays(10));
        PendingSegmentRecord segment3 = new PendingSegmentRecord(new SegmentIdWithShardSpec(WIKI, firstWeekOfJan, "v2", (ShardSpec)new NumberedShardSpec(0, 1)), "sequenceName", null, null, "group1", firstWeekOfJan.getStart());
        this.cache.insertPendingSegments(List.of(segment1, segment2, segment3), false);
        Assert.assertEquals((long)2L, (long)this.cache.deletePendingSegmentsCreatedIn(firstWeekOfJan));
        Assert.assertEquals(List.of(segment2), (Object)this.cache.findPendingSegmentsOverlapping(firstWeekOfJan));
    }

    @Test
    public void testMarkSegmentsWithinIntervalAsUnused() {
        this.cache.insertSegments(Set.of(JAN_1_SEGMENT, JAN_2_SEGMENT, JAN_3_SEGMENT));
        Assert.assertEquals(Set.of(JAN_1_SEGMENT, JAN_2_SEGMENT, JAN_3_SEGMENT), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(FIRST_WEEK_OF_JAN)));
        Assert.assertEquals((long)1L, (long)this.cache.markSegmentsWithinIntervalAsUnused(FIRST_DAY_OF_JAN.withDurationAfterStart((ReadableDuration)Duration.standardDays((long)1L)), null, DateTimes.nowUtc()));
        Assert.assertEquals((long)1L, (long)this.cache.markSegmentsWithinIntervalAsUnused(Intervals.ETERNITY, List.of(JAN_2_SEGMENT.getDataSegment().getVersion()), DateTimes.nowUtc()));
        Assert.assertEquals(Set.of(JAN_3_SEGMENT), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(FIRST_WEEK_OF_JAN)));
        CacheStats cacheStats = this.cache.markCacheSynced();
        Assert.assertEquals((long)1L, (long)cacheStats.getNumUsedSegments());
        Assert.assertEquals((long)2L, (long)cacheStats.getNumUnusedSegments());
        Assert.assertEquals((long)3L, (long)cacheStats.getNumIntervals());
    }

    @Test
    public void testMarkSegmentAsUnused() {
        this.cache.insertSegments(Set.of(JAN_1_SEGMENT, JAN_2_SEGMENT, JAN_3_SEGMENT));
        this.cache.markSegmentAsUnused(JAN_1_SEGMENT.getDataSegment().getId(), DateTimes.nowUtc());
        Assert.assertEquals(Set.of(JAN_2_SEGMENT, JAN_3_SEGMENT), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(FIRST_WEEK_OF_JAN)));
    }

    @Test
    public void testMarkSegmentsAsUnused() {
        this.cache.insertSegments(Set.of(JAN_1_SEGMENT, JAN_2_SEGMENT, JAN_3_SEGMENT));
        this.cache.markSegmentsAsUnused(Set.of(JAN_1_SEGMENT.getDataSegment().getId(), JAN_2_SEGMENT.getDataSegment().getId()), DateTimes.nowUtc());
        Assert.assertEquals(Set.of(JAN_3_SEGMENT), (Object)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(FIRST_WEEK_OF_JAN)));
    }

    @Test
    public void testMarkAllSegmentsAsUnused() {
        this.cache.insertSegments(Set.of(JAN_1_SEGMENT, JAN_2_SEGMENT, JAN_3_SEGMENT));
        this.cache.markAllSegmentsAsUnused(DateTimes.nowUtc());
        Assert.assertTrue((boolean)this.cache.findUsedSegmentsPlusOverlappingAnyOf(List.of(FIRST_WEEK_OF_JAN)).isEmpty());
    }

    @Test
    public void testStop_disablesFurtherActions() {
        this.cache.stop();
        DruidExceptionMatcher.internalServerError().expectMessageIs("Cannot perform operation on cache as it is already stopped").assertThrowsAndMatches(() -> this.cache.deleteAllPendingSegments());
        DruidExceptionMatcher.internalServerError().expectMessageIs("Cannot perform operation on cache as it is already stopped").assertThrowsAndMatches(() -> this.cache.findPendingSegments("alloc1"));
    }

    private static CreateDataSegments createUsedSegment() {
        return CreateDataSegments.ofDatasource(WIKI).markUsed();
    }

    private static CreateDataSegments createUnusedSegment() {
        return CreateDataSegments.ofDatasource(WIKI).markUnused();
    }

    private static DataSegmentPlus updateSegment(DataSegmentPlus segment, DateTime newUpdatedTime) {
        return new DataSegmentPlus(segment.getDataSegment(), segment.getCreatedDate(), newUpdatedTime, segment.getUsed(), segment.getSchemaFingerprint(), segment.getNumRows(), segment.getUpgradedFromSegmentId());
    }

    private static SegmentRecord asRecord(DataSegmentPlus segment) {
        return new SegmentRecord(segment.getDataSegment().getId(), Boolean.TRUE.equals(segment.getUsed()), segment.getUsedStatusLastUpdatedDate());
    }
}

