/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class IndexerSqlMetadataStorageCoordinatorTestBase {
    protected static final int MAX_SQL_MEATADATA_RETRY_FOR_TEST = 2;
    protected final ObjectMapper mapper = TestHelper.makeJsonMapper();
    protected final DataSegment defaultSegment = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    protected final DataSegment eternitySegment = new DataSegment("fooDataSource", Intervals.ETERNITY, "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    protected final DataSegment firstHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"3000")), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    protected final DataSegment secondHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.of((String)"1970"), (ReadableInstant)DateTimes.MAX), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    protected final DataSegment defaultSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
    protected final DataSegment defaultSegment2WithBiggerSize = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 200L);
    protected final DataSegment defaultSegment3 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-03T00Z/2015-01-04T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 100L);
    protected final DataSegment defaultSegment4 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    protected final DataSegment numberedSegment0of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
    protected final DataSegment numberedSegment1of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 0), Integer.valueOf(9), 100L);
    protected final DataSegment numberedSegment2of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 0), Integer.valueOf(9), 100L);
    protected final DataSegment numberedSegment2of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 1), Integer.valueOf(9), 100L);
    protected final DataSegment numberedSegment3of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(3, 1), Integer.valueOf(9), 100L);
    protected final DataSegment existingSegment1 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-01T00Z/1994-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    protected final DataSegment existingSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    protected final DataSegment hugeTimeRangeSegment1 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"-9994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    protected final DataSegment hugeTimeRangeSegment2 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"2994-01-02T00Z/2994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    protected final DataSegment hugeTimeRangeSegment3 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"29940-01-02T00Z/29940-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    protected final DataSegment hugeTimeRangeSegment4 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"1990-01-01T00Z/19940-01-01T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    protected final Set<DataSegment> SEGMENTS = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2);
    protected final AtomicLong metadataUpdateCounter = new AtomicLong();
    protected final AtomicLong segmentTableDropUpdateCounter = new AtomicLong();
    protected IndexerSQLMetadataStorageCoordinator coordinator;
    protected TestDerbyConnector derbyConnector;
    protected TestDerbyConnector.SegmentsTable segmentsTable;
    protected SegmentSchemaManager segmentSchemaManager;
    protected FingerprintGenerator fingerprintGenerator;
    protected SegmentSchemaTestUtils segmentSchemaTestUtils;

    protected DataSegment createSegment(Interval interval, String version, ShardSpec shardSpec) {
        return DataSegment.builder().dataSource("wiki").interval(interval).version(version).shardSpec(shardSpec).size(100L).loadSpec((Map)ImmutableMap.of((Object)"hash", (Object)Objects.hash(interval, version, shardSpec))).build();
    }

    protected List<DataSegment> createAndGetUsedYearSegments(int startYear, int endYear) {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int year = startYear; year < endYear; ++year) {
            segments.add(this.createSegment(Intervals.of((String)"%d/%d", (Object[])new Object[]{year, year + 1}), "version", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        }
        HashSet segmentsSet = new HashSet(segments);
        Set committedSegments = this.coordinator.commitSegments(segmentsSet, null);
        Assert.assertTrue((boolean)committedSegments.containsAll(segmentsSet));
        return segments;
    }

    protected ImmutableList<DataSegment> retrieveUnusedSegments(List<Interval> intervals, Integer limit, String lastSegmentId, SortOrder sortOrder, DateTime maxUsedStatusLastUpdatedTime, MetadataStorageTablesConfig tablesConfig) {
        return (ImmutableList)this.derbyConnector.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator iterator = SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)this.derbyConnector, (MetadataStorageTablesConfig)tablesConfig, (ObjectMapper)this.mapper).retrieveUnusedSegments("wiki", (Collection)intervals, null, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                return immutableList;
            }
        });
    }

    protected ImmutableList<DataSegmentPlus> retrieveUnusedSegmentsPlus(List<Interval> intervals, Integer limit, String lastSegmentId, SortOrder sortOrder, DateTime maxUsedStatusLastUpdatedTime, MetadataStorageTablesConfig tablesConfig) {
        return (ImmutableList)this.derbyConnector.inReadOnlyTransaction((handle, status) -> {
            try (CloseableIterator iterator = SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)this.derbyConnector, (MetadataStorageTablesConfig)tablesConfig, (ObjectMapper)this.mapper).retrieveUnusedSegmentsPlus("wiki", (Collection)intervals, null, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                return immutableList;
            }
        });
    }

    protected void verifyContainsAllSegmentsPlus(List<DataSegment> expectedSegments, List<DataSegmentPlus> actualUnusedSegmentsPlus, DateTime usedStatusLastUpdatedTime) {
        Map expectedIdToSegment = expectedSegments.stream().collect(Collectors.toMap(DataSegment::getId, Function.identity()));
        Map actualIdToSegmentPlus = actualUnusedSegmentsPlus.stream().collect(Collectors.toMap(d -> d.getDataSegment().getId(), Function.identity()));
        Assert.assertTrue((boolean)expectedIdToSegment.entrySet().stream().allMatch(e -> {
            DataSegmentPlus segmentPlus = (DataSegmentPlus)actualIdToSegmentPlus.get(e.getKey());
            return segmentPlus != null && !segmentPlus.getCreatedDate().isAfter((ReadableInstant)usedStatusLastUpdatedTime) && segmentPlus.getUsedStatusLastUpdatedDate() != null && segmentPlus.getUsedStatusLastUpdatedDate().equals((Object)usedStatusLastUpdatedTime);
        }));
    }

    protected void verifyEqualsAllSegmentsPlus(List<DataSegment> expectedSegments, List<DataSegmentPlus> actualUnusedSegmentsPlus, DateTime usedStatusLastUpdatedTime) {
        Assert.assertEquals((long)expectedSegments.size(), (long)actualUnusedSegmentsPlus.size());
        for (int i = 0; i < expectedSegments.size(); ++i) {
            DataSegment expectedSegment = expectedSegments.get(i);
            DataSegmentPlus actualSegmentPlus = actualUnusedSegmentsPlus.get(i);
            Assert.assertEquals((Object)expectedSegment.getId(), (Object)actualSegmentPlus.getDataSegment().getId());
            Assert.assertTrue((!actualSegmentPlus.getCreatedDate().isAfter((ReadableInstant)usedStatusLastUpdatedTime) && actualSegmentPlus.getUsedStatusLastUpdatedDate() != null && actualSegmentPlus.getUsedStatusLastUpdatedDate().equals((Object)usedStatusLastUpdatedTime) ? 1 : 0) != 0);
        }
    }

    protected void markAllSegmentsUnused() {
        this.markAllSegmentsUnused(this.SEGMENTS, DateTimes.nowUtc());
    }

    protected void markAllSegmentsUnused(Set<DataSegment> segments, DateTime usedStatusLastUpdatedTime) {
        for (DataSegment segment : segments) {
            Assert.assertEquals((long)1L, (long)this.segmentsTable.update("UPDATE %s SET used = false, used_status_last_updated = ? WHERE id = ?", usedStatusLastUpdatedTime.toString(), segment.getId().toString()));
        }
    }

    protected List<String> retrievePendingSegmentIds(MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getPendingSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + "  ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    protected List<String> retrieveUsedSegmentIds(MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + " WHERE used = true ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    protected List<DataSegment> retrieveUsedSegments(MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT payload FROM " + table + " WHERE used = true ORDER BY id").map((index, result, context) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.mapper, (byte[])result.getBytes(1), DataSegment.class)).list());
    }

    protected List<String> retrieveUnusedSegmentIds(MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id FROM " + table + " WHERE used = false ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list());
    }

    protected Map<String, String> getSegmentsCommittedDuringReplaceTask(String taskId, MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getUpgradeSegmentsTable();
        return (Map)this.derbyConnector.retryWithHandle(handle -> {
            String sql = StringUtils.format((String)"SELECT segment_id, lock_version FROM %1$s WHERE task_id = :task_id", (Object[])new Object[]{table});
            ResultIterator resultIterator = ((Query)handle.createQuery(sql).bind("task_id", taskId)).map((index, r, ctx) -> Pair.of((Object)r.getString("segment_id"), (Object)r.getString("lock_version"))).iterator();
            HashMap<String, String> segmentIdToLockVersion = new HashMap<String, String>();
            while (resultIterator.hasNext()) {
                Pair result = (Pair)resultIterator.next();
                segmentIdToLockVersion.put((String)result.lhs, (String)result.rhs);
            }
            return segmentIdToLockVersion;
        });
    }

    protected void insertIntoUpgradeSegmentsTable(Map<DataSegment, ReplaceTaskLock> segmentToTaskLockMap, MetadataStorageTablesConfig tablesConfig) {
        String table = tablesConfig.getUpgradeSegmentsTable();
        this.derbyConnector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)StringUtils.format((String)"INSERT INTO %1$s (task_id, segment_id, lock_version) VALUES (:task_id, :segment_id, :lock_version)", (Object[])new Object[]{table}), (Object[])new Object[0]));
            for (Map.Entry entry : segmentToTaskLockMap.entrySet()) {
                DataSegment segment = (DataSegment)entry.getKey();
                ReplaceTaskLock lock = (ReplaceTaskLock)entry.getValue();
                ((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("task_id", lock.getSupervisorTaskId())).bind("segment_id", segment.getId().toString())).bind("lock_version", lock.getVersion());
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to insert upgrade segments in DB", new Object[0]);
            }
            return true;
        });
    }

    public static void insertUsedSegments(Set<DataSegment> dataSegments, Map<String, String> upgradedFromSegmentIdMap, TestDerbyConnector.DerbyConnectorRule derbyConnectorRule, ObjectMapper jsonMapper) {
        IndexerSqlMetadataStorageCoordinatorTestBase.insertUsedSegments(dataSegments, upgradedFromSegmentIdMap, derbyConnectorRule.getConnector(), jsonMapper);
    }

    public static void insertUsedSegments(Set<DataSegment> dataSegments, Map<String, String> upgradedFromSegmentIdMap, TestDerbyConnector connector, ObjectMapper jsonMapper) {
        HashSet<DataSegmentPlus> usedSegments = new HashSet<DataSegmentPlus>();
        for (DataSegment segment : dataSegments) {
            DateTime now = DateTimes.nowUtc();
            usedSegments.add(new DataSegmentPlus(segment, now, now, Boolean.valueOf(true), null, null, upgradedFromSegmentIdMap.get(segment.getId().toString())));
        }
        IndexerSqlMetadataStorageCoordinatorTestBase.insertSegments(usedSegments, false, connector, jsonMapper);
    }

    public static void insertSegments(Set<DataSegmentPlus> dataSegments, boolean includeSchema, TestDerbyConnector.DerbyConnectorRule derbyConnectorRule, ObjectMapper jsonMapper) {
        IndexerSqlMetadataStorageCoordinatorTestBase.insertSegments(dataSegments, includeSchema, derbyConnectorRule.getConnector(), jsonMapper);
    }

    public static void insertSegments(Set<DataSegmentPlus> dataSegments, boolean includeSchema, TestDerbyConnector connector, ObjectMapper jsonMapper) {
        String table = connector.getMetadataTablesConfig().getSegmentsTable();
        String sql = IndexerSqlMetadataStorageCoordinatorTestBase.getSegmentInsertSql(includeSchema, table, connector);
        connector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(sql);
            for (DataSegmentPlus segmentPlus : dataSegments) {
                DataSegment segment = segmentPlus.getDataSegment();
                String id = segment.getId().toString();
                PreparedBatchPart segmentRecord = preparedBatch.add();
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)segmentRecord.bind("id", id)).bind("dataSource", segment.getDataSource())).bind("created_date", IndexerSqlMetadataStorageCoordinatorTestBase.nullSafeString(segmentPlus.getCreatedDate()))).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", Boolean.TRUE.equals(segmentPlus.getUsed()))).bind("payload", jsonMapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", IndexerSqlMetadataStorageCoordinatorTestBase.nullSafeString(segmentPlus.getUsedStatusLastUpdatedDate()))).bind("upgraded_from_segment_id", segmentPlus.getUpgradedFromSegmentId());
                if (!includeSchema) continue;
                ((PreparedBatchPart)segmentRecord.bind("num_rows", segmentPlus.getNumRows())).bind("schema_fingerprint", segmentPlus.getSchemaFingerprint());
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to publish segments to DB", new Object[0]);
            }
            return true;
        });
    }

    private static String getSegmentInsertSql(boolean includeSchema, String table, TestDerbyConnector connector) {
        String sql = includeSchema ? StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, upgraded_from_segment_id, num_rows, schema_fingerprint) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :upgraded_from_segment_id, :num_rows, :schema_fingerprint)", (Object[])new Object[]{table, connector.getQuoteString()}) : StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, upgraded_from_segment_id) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :upgraded_from_segment_id)", (Object[])new Object[]{table, connector.getQuoteString()});
        return sql;
    }

    @Nullable
    private static String nullSafeString(DateTime date) {
        return date == null ? null : date.toString();
    }

    protected static class TombstoneShardSpecWith1CorePartition
    extends TombstoneShardSpec {
        protected TombstoneShardSpecWith1CorePartition() {
        }

        @JsonProperty(value="partitions")
        public int getNumCorePartitions() {
            return 1;
        }
    }
}

